/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class JobTagsListCopier {
    static List<JobResourceTags> copy(Collection<? extends JobResourceTags> jobTagsListParam) {
        List<JobResourceTags> list;
        if (jobTagsListParam == null || jobTagsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<JobResourceTags> modifiableList = new ArrayList<>();
            jobTagsListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<JobResourceTags> copyFromBuilder(Collection<? extends JobResourceTags.Builder> jobTagsListParam) {
        List<JobResourceTags> list;
        if (jobTagsListParam == null || jobTagsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<JobResourceTags> modifiableList = new ArrayList<>();
            jobTagsListParam.forEach(entry -> {
                JobResourceTags member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<JobResourceTags.Builder> copyToBuilder(Collection<? extends JobResourceTags> jobTagsListParam) {
        List<JobResourceTags.Builder> list;
        if (jobTagsListParam == null || jobTagsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<JobResourceTags.Builder> modifiableList = new ArrayList<>();
            jobTagsListParam.forEach(entry -> {
                JobResourceTags.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
