/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An over-the-air update (OTA) job configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OTAJobConfig implements SdkPojo, Serializable, ToCopyableBuilder<OTAJobConfig.Builder, OTAJobConfig> {
    private static final SdkField<Boolean> ALLOW_MAJOR_VERSION_UPDATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowMajorVersionUpdate").getter(getter(OTAJobConfig::allowMajorVersionUpdate))
            .setter(setter(Builder::allowMajorVersionUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowMajorVersionUpdate").build())
            .build();

    private static final SdkField<String> IMAGE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageVersion").getter(getter(OTAJobConfig::imageVersion)).setter(setter(Builder::imageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ALLOW_MAJOR_VERSION_UPDATE_FIELD, IMAGE_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean allowMajorVersionUpdate;

    private final String imageVersion;

    private OTAJobConfig(BuilderImpl builder) {
        this.allowMajorVersionUpdate = builder.allowMajorVersionUpdate;
        this.imageVersion = builder.imageVersion;
    }

    /**
     * <p>
     * Whether to apply the update if it is a major version change.
     * </p>
     * 
     * @return Whether to apply the update if it is a major version change.
     */
    public final Boolean allowMajorVersionUpdate() {
        return allowMajorVersionUpdate;
    }

    /**
     * <p>
     * The target version of the device software.
     * </p>
     * 
     * @return The target version of the device software.
     */
    public final String imageVersion() {
        return imageVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowMajorVersionUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(imageVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OTAJobConfig)) {
            return false;
        }
        OTAJobConfig other = (OTAJobConfig) obj;
        return Objects.equals(allowMajorVersionUpdate(), other.allowMajorVersionUpdate())
                && Objects.equals(imageVersion(), other.imageVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OTAJobConfig").add("AllowMajorVersionUpdate", allowMajorVersionUpdate())
                .add("ImageVersion", imageVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowMajorVersionUpdate":
            return Optional.ofNullable(clazz.cast(allowMajorVersionUpdate()));
        case "ImageVersion":
            return Optional.ofNullable(clazz.cast(imageVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OTAJobConfig, T> g) {
        return obj -> g.apply((OTAJobConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OTAJobConfig> {
        /**
         * <p>
         * Whether to apply the update if it is a major version change.
         * </p>
         * 
         * @param allowMajorVersionUpdate
         *        Whether to apply the update if it is a major version change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowMajorVersionUpdate(Boolean allowMajorVersionUpdate);

        /**
         * <p>
         * The target version of the device software.
         * </p>
         * 
         * @param imageVersion
         *        The target version of the device software.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageVersion(String imageVersion);
    }

    static final class BuilderImpl implements Builder {
        private Boolean allowMajorVersionUpdate;

        private String imageVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(OTAJobConfig model) {
            allowMajorVersionUpdate(model.allowMajorVersionUpdate);
            imageVersion(model.imageVersion);
        }

        public final Boolean getAllowMajorVersionUpdate() {
            return allowMajorVersionUpdate;
        }

        public final void setAllowMajorVersionUpdate(Boolean allowMajorVersionUpdate) {
            this.allowMajorVersionUpdate = allowMajorVersionUpdate;
        }

        @Override
        public final Builder allowMajorVersionUpdate(Boolean allowMajorVersionUpdate) {
            this.allowMajorVersionUpdate = allowMajorVersionUpdate;
            return this;
        }

        public final String getImageVersion() {
            return imageVersion;
        }

        public final void setImageVersion(String imageVersion) {
            this.imageVersion = imageVersion;
        }

        @Override
        public final Builder imageVersion(String imageVersion) {
            this.imageVersion = imageVersion;
            return this;
        }

        @Override
        public OTAJobConfig build() {
            return new OTAJobConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
