/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.panorama.model.JobType;
import software.amazon.awssdk.services.panorama.model.UpdateProgress;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LatestDeviceJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LatestDeviceJob> {
    private static final SdkField<String> IMAGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageVersion").getter(LatestDeviceJob.getter(LatestDeviceJob::imageVersion)).setter(LatestDeviceJob.setter(Builder::imageVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageVersion").build()}).build();
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobType").getter(LatestDeviceJob.getter(LatestDeviceJob::jobTypeAsString)).setter(LatestDeviceJob.setter(Builder::jobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(LatestDeviceJob.getter(LatestDeviceJob::statusAsString)).setter(LatestDeviceJob.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_VERSION_FIELD, JOB_TYPE_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String imageVersion;
    private final String jobType;
    private final String status;

    private LatestDeviceJob(BuilderImpl builder) {
        this.imageVersion = builder.imageVersion;
        this.jobType = builder.jobType;
        this.status = builder.status;
    }

    public final String imageVersion() {
        return this.imageVersion;
    }

    public final JobType jobType() {
        return JobType.fromValue(this.jobType);
    }

    public final String jobTypeAsString() {
        return this.jobType;
    }

    public final UpdateProgress status() {
        return UpdateProgress.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LatestDeviceJob)) {
            return false;
        }
        LatestDeviceJob other = (LatestDeviceJob)obj;
        return Objects.equals(this.imageVersion(), other.imageVersion()) && Objects.equals(this.jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LatestDeviceJob").add("ImageVersion", (Object)this.imageVersion()).add("JobType", (Object)this.jobTypeAsString()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageVersion": {
                return Optional.ofNullable(clazz.cast(this.imageVersion()));
            }
            case "JobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LatestDeviceJob, T> g) {
        return obj -> g.apply((LatestDeviceJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String imageVersion;
        private String jobType;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(LatestDeviceJob model) {
            this.imageVersion(model.imageVersion);
            this.jobType(model.jobType);
            this.status(model.status);
        }

        public final String getImageVersion() {
            return this.imageVersion;
        }

        public final void setImageVersion(String imageVersion) {
            this.imageVersion = imageVersion;
        }

        @Override
        public final Builder imageVersion(String imageVersion) {
            this.imageVersion = imageVersion;
            return this;
        }

        public final String getJobType() {
            return this.jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UpdateProgress status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public LatestDeviceJob build() {
            return new LatestDeviceJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LatestDeviceJob> {
        public Builder imageVersion(String var1);

        public Builder jobType(String var1);

        public Builder jobType(JobType var1);

        public Builder status(String var1);

        public Builder status(UpdateProgress var1);
    }
}

