/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A job that runs on a device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceJob implements SdkPojo, Serializable, ToCopyableBuilder<DeviceJob.Builder, DeviceJob> {
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(DeviceJob::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceId").getter(getter(DeviceJob::deviceId)).setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()).build();

    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceName").getter(getter(DeviceJob::deviceName)).setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(DeviceJob::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobType").getter(getter(DeviceJob::jobTypeAsString)).setter(setter(Builder::jobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_TIME_FIELD,
            DEVICE_ID_FIELD, DEVICE_NAME_FIELD, JOB_ID_FIELD, JOB_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdTime;

    private final String deviceId;

    private final String deviceName;

    private final String jobId;

    private final String jobType;

    private DeviceJob(BuilderImpl builder) {
        this.createdTime = builder.createdTime;
        this.deviceId = builder.deviceId;
        this.deviceName = builder.deviceName;
        this.jobId = builder.jobId;
        this.jobType = builder.jobType;
    }

    /**
     * <p>
     * When the job was created.
     * </p>
     * 
     * @return When the job was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The ID of the target device.
     * </p>
     * 
     * @return The ID of the target device.
     */
    public final String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The name of the target device
     * </p>
     * 
     * @return The name of the target device
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * The job's ID.
     * </p>
     * 
     * @return The job's ID.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The job's type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The job's type.
     * @see JobType
     */
    public final JobType jobType() {
        return JobType.fromValue(jobType);
    }

    /**
     * <p>
     * The job's type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The job's type.
     * @see JobType
     */
    public final String jobTypeAsString() {
        return jobType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceJob)) {
            return false;
        }
        DeviceJob other = (DeviceJob) obj;
        return Objects.equals(createdTime(), other.createdTime()) && Objects.equals(deviceId(), other.deviceId())
                && Objects.equals(deviceName(), other.deviceName()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(jobTypeAsString(), other.jobTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeviceJob").add("CreatedTime", createdTime()).add("DeviceId", deviceId())
                .add("DeviceName", deviceName()).add("JobId", jobId()).add("JobType", jobTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "JobType":
            return Optional.ofNullable(clazz.cast(jobTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceJob, T> g) {
        return obj -> g.apply((DeviceJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceJob> {
        /**
         * <p>
         * When the job was created.
         * </p>
         * 
         * @param createdTime
         *        When the job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The ID of the target device.
         * </p>
         * 
         * @param deviceId
         *        The ID of the target device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The name of the target device
         * </p>
         * 
         * @param deviceName
         *        The name of the target device
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * The job's ID.
         * </p>
         * 
         * @param jobId
         *        The job's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The job's type.
         * </p>
         * 
         * @param jobType
         *        The job's type.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * The job's type.
         * </p>
         * 
         * @param jobType
         *        The job's type.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(JobType jobType);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdTime;

        private String deviceId;

        private String deviceName;

        private String jobId;

        private String jobType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceJob model) {
            createdTime(model.createdTime);
            deviceId(model.deviceId);
            deviceName(model.deviceName);
            jobId(model.jobId);
            jobType(model.jobType);
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDeviceId() {
            return deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobType() {
            return jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        @Override
        public DeviceJob build() {
            return new DeviceJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
