/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.panorama.PanoramaClient;
import software.amazon.awssdk.services.panorama.model.ListDevicesJobsRequest;
import software.amazon.awssdk.services.panorama.model.ListDevicesJobsResponse;

public class ListDevicesJobsIterable
implements SdkIterable<ListDevicesJobsResponse> {
    private final PanoramaClient client;
    private final ListDevicesJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDevicesJobsIterable(PanoramaClient client, ListDevicesJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDevicesJobsResponseFetcher();
    }

    public Iterator<ListDevicesJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDevicesJobsResponseFetcher
    implements SyncPageFetcher<ListDevicesJobsResponse> {
        private ListDevicesJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListDevicesJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDevicesJobsResponse nextPage(ListDevicesJobsResponse previousPage) {
            if (previousPage == null) {
                return ListDevicesJobsIterable.this.client.listDevicesJobs(ListDevicesJobsIterable.this.firstRequest);
            }
            return ListDevicesJobsIterable.this.client.listDevicesJobs((ListDevicesJobsRequest)((Object)ListDevicesJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

