/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApplicationInstanceResponse extends PanoramaResponse implements
        ToCopyableBuilder<CreateApplicationInstanceResponse.Builder, CreateApplicationInstanceResponse> {
    private static final SdkField<String> APPLICATION_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationInstanceId").getter(getter(CreateApplicationInstanceResponse::applicationInstanceId))
            .setter(setter(Builder::applicationInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationInstanceId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(APPLICATION_INSTANCE_ID_FIELD));

    private final String applicationInstanceId;

    private CreateApplicationInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.applicationInstanceId = builder.applicationInstanceId;
    }

    /**
     * <p>
     * The application instance's ID.
     * </p>
     * 
     * @return The application instance's ID.
     */
    public final String applicationInstanceId() {
        return applicationInstanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationInstanceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationInstanceResponse)) {
            return false;
        }
        CreateApplicationInstanceResponse other = (CreateApplicationInstanceResponse) obj;
        return Objects.equals(applicationInstanceId(), other.applicationInstanceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateApplicationInstanceResponse").add("ApplicationInstanceId", applicationInstanceId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationInstanceId":
            return Optional.ofNullable(clazz.cast(applicationInstanceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationInstanceResponse, T> g) {
        return obj -> g.apply((CreateApplicationInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateApplicationInstanceResponse> {
        /**
         * <p>
         * The application instance's ID.
         * </p>
         * 
         * @param applicationInstanceId
         *        The application instance's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationInstanceId(String applicationInstanceId);
    }

    static final class BuilderImpl extends PanoramaResponse.BuilderImpl implements Builder {
        private String applicationInstanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationInstanceResponse model) {
            super(model);
            applicationInstanceId(model.applicationInstanceId);
        }

        public final String getApplicationInstanceId() {
            return applicationInstanceId;
        }

        public final void setApplicationInstanceId(String applicationInstanceId) {
            this.applicationInstanceId = applicationInstanceId;
        }

        @Override
        public final Builder applicationInstanceId(String applicationInstanceId) {
            this.applicationInstanceId = applicationInstanceId;
            return this;
        }

        @Override
        public CreateApplicationInstanceResponse build() {
            return new CreateApplicationInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
