/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.panorama.model.CreateApplicationInstanceRequest;
import software.amazon.awssdk.services.panorama.model.CreateApplicationInstanceResponse;
import software.amazon.awssdk.services.panorama.model.CreateJobForDevicesRequest;
import software.amazon.awssdk.services.panorama.model.CreateJobForDevicesResponse;
import software.amazon.awssdk.services.panorama.model.CreateNodeFromTemplateJobRequest;
import software.amazon.awssdk.services.panorama.model.CreateNodeFromTemplateJobResponse;
import software.amazon.awssdk.services.panorama.model.CreatePackageImportJobRequest;
import software.amazon.awssdk.services.panorama.model.CreatePackageImportJobResponse;
import software.amazon.awssdk.services.panorama.model.CreatePackageRequest;
import software.amazon.awssdk.services.panorama.model.CreatePackageResponse;
import software.amazon.awssdk.services.panorama.model.DeleteDeviceRequest;
import software.amazon.awssdk.services.panorama.model.DeleteDeviceResponse;
import software.amazon.awssdk.services.panorama.model.DeletePackageRequest;
import software.amazon.awssdk.services.panorama.model.DeletePackageResponse;
import software.amazon.awssdk.services.panorama.model.DeregisterPackageVersionRequest;
import software.amazon.awssdk.services.panorama.model.DeregisterPackageVersionResponse;
import software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceDetailsRequest;
import software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceDetailsResponse;
import software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceRequest;
import software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceResponse;
import software.amazon.awssdk.services.panorama.model.DescribeDeviceJobRequest;
import software.amazon.awssdk.services.panorama.model.DescribeDeviceJobResponse;
import software.amazon.awssdk.services.panorama.model.DescribeDeviceRequest;
import software.amazon.awssdk.services.panorama.model.DescribeDeviceResponse;
import software.amazon.awssdk.services.panorama.model.DescribeNodeFromTemplateJobRequest;
import software.amazon.awssdk.services.panorama.model.DescribeNodeFromTemplateJobResponse;
import software.amazon.awssdk.services.panorama.model.DescribeNodeRequest;
import software.amazon.awssdk.services.panorama.model.DescribeNodeResponse;
import software.amazon.awssdk.services.panorama.model.DescribePackageImportJobRequest;
import software.amazon.awssdk.services.panorama.model.DescribePackageImportJobResponse;
import software.amazon.awssdk.services.panorama.model.DescribePackageRequest;
import software.amazon.awssdk.services.panorama.model.DescribePackageResponse;
import software.amazon.awssdk.services.panorama.model.DescribePackageVersionRequest;
import software.amazon.awssdk.services.panorama.model.DescribePackageVersionResponse;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesRequest;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesResponse;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesRequest;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesResponse;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstancesRequest;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstancesResponse;
import software.amazon.awssdk.services.panorama.model.ListDevicesJobsRequest;
import software.amazon.awssdk.services.panorama.model.ListDevicesJobsResponse;
import software.amazon.awssdk.services.panorama.model.ListDevicesRequest;
import software.amazon.awssdk.services.panorama.model.ListDevicesResponse;
import software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsRequest;
import software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsResponse;
import software.amazon.awssdk.services.panorama.model.ListNodesRequest;
import software.amazon.awssdk.services.panorama.model.ListNodesResponse;
import software.amazon.awssdk.services.panorama.model.ListPackageImportJobsRequest;
import software.amazon.awssdk.services.panorama.model.ListPackageImportJobsResponse;
import software.amazon.awssdk.services.panorama.model.ListPackagesRequest;
import software.amazon.awssdk.services.panorama.model.ListPackagesResponse;
import software.amazon.awssdk.services.panorama.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.panorama.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.panorama.model.ProvisionDeviceRequest;
import software.amazon.awssdk.services.panorama.model.ProvisionDeviceResponse;
import software.amazon.awssdk.services.panorama.model.RegisterPackageVersionRequest;
import software.amazon.awssdk.services.panorama.model.RegisterPackageVersionResponse;
import software.amazon.awssdk.services.panorama.model.RemoveApplicationInstanceRequest;
import software.amazon.awssdk.services.panorama.model.RemoveApplicationInstanceResponse;
import software.amazon.awssdk.services.panorama.model.SignalApplicationInstanceNodeInstancesRequest;
import software.amazon.awssdk.services.panorama.model.SignalApplicationInstanceNodeInstancesResponse;
import software.amazon.awssdk.services.panorama.model.TagResourceRequest;
import software.amazon.awssdk.services.panorama.model.TagResourceResponse;
import software.amazon.awssdk.services.panorama.model.UntagResourceRequest;
import software.amazon.awssdk.services.panorama.model.UntagResourceResponse;
import software.amazon.awssdk.services.panorama.model.UpdateDeviceMetadataRequest;
import software.amazon.awssdk.services.panorama.model.UpdateDeviceMetadataResponse;
import software.amazon.awssdk.services.panorama.paginators.ListApplicationInstanceDependenciesPublisher;
import software.amazon.awssdk.services.panorama.paginators.ListApplicationInstanceNodeInstancesPublisher;
import software.amazon.awssdk.services.panorama.paginators.ListApplicationInstancesPublisher;
import software.amazon.awssdk.services.panorama.paginators.ListDevicesJobsPublisher;
import software.amazon.awssdk.services.panorama.paginators.ListDevicesPublisher;
import software.amazon.awssdk.services.panorama.paginators.ListNodeFromTemplateJobsPublisher;
import software.amazon.awssdk.services.panorama.paginators.ListNodesPublisher;
import software.amazon.awssdk.services.panorama.paginators.ListPackageImportJobsPublisher;
import software.amazon.awssdk.services.panorama.paginators.ListPackagesPublisher;

/**
 * Service client for accessing Panorama asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@link SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * <fullname>AWS Panorama</fullname>
 * <p>
 * <b>Overview</b>
 * </p>
 * <p>
 * This is the <i>AWS Panorama API Reference</i>. For an introduction to the service, see <a
 * href="https://docs.aws.amazon.com/panorama/latest/dev/panorama-welcome.html">What is AWS Panorama?</a> in the <i>AWS
 * Panorama Developer Guide</i>.
 * </p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface PanoramaAsyncClient extends AwsClient {
    String SERVICE_NAME = "panorama";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "panorama";

    /**
     * <p>
     * Creates an application instance and deploys it to a device.
     * </p>
     *
     * @param createApplicationInstanceRequest
     * @return A Java Future containing the result of the CreateApplicationInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ServiceQuotaExceededException The request would cause a limit to be exceeded.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.CreateApplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreateApplicationInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationInstanceResponse> createApplicationInstance(
            CreateApplicationInstanceRequest createApplicationInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an application instance and deploys it to a device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link CreateApplicationInstanceRequest#builder()}
     * </p>
     *
     * @param createApplicationInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.CreateApplicationInstanceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateApplicationInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ServiceQuotaExceededException The request would cause a limit to be exceeded.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.CreateApplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreateApplicationInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationInstanceResponse> createApplicationInstance(
            Consumer<CreateApplicationInstanceRequest.Builder> createApplicationInstanceRequest) {
        return createApplicationInstance(CreateApplicationInstanceRequest.builder()
                .applyMutation(createApplicationInstanceRequest).build());
    }

    /**
     * <p>
     * Creates a job to run on a device. A job can update a device's software or reboot it.
     * </p>
     *
     * @param createJobForDevicesRequest
     * @return A Java Future containing the result of the CreateJobForDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.CreateJobForDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreateJobForDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateJobForDevicesResponse> createJobForDevices(
            CreateJobForDevicesRequest createJobForDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a job to run on a device. A job can update a device's software or reboot it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateJobForDevicesRequest.Builder} avoiding the
     * need to create one manually via {@link CreateJobForDevicesRequest#builder()}
     * </p>
     *
     * @param createJobForDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.CreateJobForDevicesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateJobForDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.CreateJobForDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreateJobForDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateJobForDevicesResponse> createJobForDevices(
            Consumer<CreateJobForDevicesRequest.Builder> createJobForDevicesRequest) {
        return createJobForDevices(CreateJobForDevicesRequest.builder().applyMutation(createJobForDevicesRequest).build());
    }

    /**
     * <p>
     * Creates a camera stream node.
     * </p>
     *
     * @param createNodeFromTemplateJobRequest
     * @return A Java Future containing the result of the CreateNodeFromTemplateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.CreateNodeFromTemplateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreateNodeFromTemplateJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNodeFromTemplateJobResponse> createNodeFromTemplateJob(
            CreateNodeFromTemplateJobRequest createNodeFromTemplateJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a camera stream node.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNodeFromTemplateJobRequest.Builder} avoiding
     * the need to create one manually via {@link CreateNodeFromTemplateJobRequest#builder()}
     * </p>
     *
     * @param createNodeFromTemplateJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.CreateNodeFromTemplateJobRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateNodeFromTemplateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.CreateNodeFromTemplateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreateNodeFromTemplateJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNodeFromTemplateJobResponse> createNodeFromTemplateJob(
            Consumer<CreateNodeFromTemplateJobRequest.Builder> createNodeFromTemplateJobRequest) {
        return createNodeFromTemplateJob(CreateNodeFromTemplateJobRequest.builder()
                .applyMutation(createNodeFromTemplateJobRequest).build());
    }

    /**
     * <p>
     * Creates a package and storage location in an Amazon S3 access point.
     * </p>
     *
     * @param createPackageRequest
     * @return A Java Future containing the result of the CreatePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.CreatePackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreatePackage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePackageResponse> createPackage(CreatePackageRequest createPackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a package and storage location in an Amazon S3 access point.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePackageRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePackageRequest#builder()}
     * </p>
     *
     * @param createPackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.CreatePackageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreatePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.CreatePackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreatePackage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePackageResponse> createPackage(Consumer<CreatePackageRequest.Builder> createPackageRequest) {
        return createPackage(CreatePackageRequest.builder().applyMutation(createPackageRequest).build());
    }

    /**
     * <p>
     * Imports a node package.
     * </p>
     *
     * @param createPackageImportJobRequest
     * @return A Java Future containing the result of the CreatePackageImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.CreatePackageImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreatePackageImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePackageImportJobResponse> createPackageImportJob(
            CreatePackageImportJobRequest createPackageImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports a node package.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePackageImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePackageImportJobRequest#builder()}
     * </p>
     *
     * @param createPackageImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.CreatePackageImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreatePackageImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.CreatePackageImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreatePackageImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePackageImportJobResponse> createPackageImportJob(
            Consumer<CreatePackageImportJobRequest.Builder> createPackageImportJobRequest) {
        return createPackageImportJob(CreatePackageImportJobRequest.builder().applyMutation(createPackageImportJobRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a device.
     * </p>
     *
     * @param deleteDeviceRequest
     * @return A Java Future containing the result of the DeleteDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.DeleteDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DeleteDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDeviceResponse> deleteDevice(DeleteDeviceRequest deleteDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDeviceRequest#builder()}
     * </p>
     *
     * @param deleteDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.DeleteDeviceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.DeleteDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DeleteDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDeviceResponse> deleteDevice(Consumer<DeleteDeviceRequest.Builder> deleteDeviceRequest) {
        return deleteDevice(DeleteDeviceRequest.builder().applyMutation(deleteDeviceRequest).build());
    }

    /**
     * <p>
     * Deletes a package.
     * </p>
     * <note>
     * <p>
     * To delete a package, you need permission to call <code>s3:DeleteObject</code> in addition to permissions for the
     * AWS Panorama API.
     * </p>
     * </note>
     *
     * @param deletePackageRequest
     * @return A Java Future containing the result of the DeletePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.DeletePackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DeletePackage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePackageResponse> deletePackage(DeletePackageRequest deletePackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a package.
     * </p>
     * <note>
     * <p>
     * To delete a package, you need permission to call <code>s3:DeleteObject</code> in addition to permissions for the
     * AWS Panorama API.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePackageRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePackageRequest#builder()}
     * </p>
     *
     * @param deletePackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.DeletePackageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeletePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.DeletePackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DeletePackage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePackageResponse> deletePackage(Consumer<DeletePackageRequest.Builder> deletePackageRequest) {
        return deletePackage(DeletePackageRequest.builder().applyMutation(deletePackageRequest).build());
    }

    /**
     * <p>
     * Deregisters a package version.
     * </p>
     *
     * @param deregisterPackageVersionRequest
     * @return A Java Future containing the result of the DeregisterPackageVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.DeregisterPackageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DeregisterPackageVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterPackageVersionResponse> deregisterPackageVersion(
            DeregisterPackageVersionRequest deregisterPackageVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters a package version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterPackageVersionRequest.Builder} avoiding
     * the need to create one manually via {@link DeregisterPackageVersionRequest#builder()}
     * </p>
     *
     * @param deregisterPackageVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.DeregisterPackageVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeregisterPackageVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.DeregisterPackageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DeregisterPackageVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterPackageVersionResponse> deregisterPackageVersion(
            Consumer<DeregisterPackageVersionRequest.Builder> deregisterPackageVersionRequest) {
        return deregisterPackageVersion(DeregisterPackageVersionRequest.builder().applyMutation(deregisterPackageVersionRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about an application instance on a device.
     * </p>
     *
     * @param describeApplicationInstanceRequest
     * @return A Java Future containing the result of the DescribeApplicationInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.DescribeApplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeApplicationInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApplicationInstanceResponse> describeApplicationInstance(
            DescribeApplicationInstanceRequest describeApplicationInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an application instance on a device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationInstanceRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeApplicationInstanceRequest#builder()}
     * </p>
     *
     * @param describeApplicationInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeApplicationInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.DescribeApplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeApplicationInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApplicationInstanceResponse> describeApplicationInstance(
            Consumer<DescribeApplicationInstanceRequest.Builder> describeApplicationInstanceRequest) {
        return describeApplicationInstance(DescribeApplicationInstanceRequest.builder()
                .applyMutation(describeApplicationInstanceRequest).build());
    }

    /**
     * <p>
     * Returns information about an application instance's configuration manifest.
     * </p>
     *
     * @param describeApplicationInstanceDetailsRequest
     * @return A Java Future containing the result of the DescribeApplicationInstanceDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.DescribeApplicationInstanceDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeApplicationInstanceDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApplicationInstanceDetailsResponse> describeApplicationInstanceDetails(
            DescribeApplicationInstanceDetailsRequest describeApplicationInstanceDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an application instance's configuration manifest.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationInstanceDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeApplicationInstanceDetailsRequest#builder()}
     * </p>
     *
     * @param describeApplicationInstanceDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceDetailsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeApplicationInstanceDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.DescribeApplicationInstanceDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeApplicationInstanceDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApplicationInstanceDetailsResponse> describeApplicationInstanceDetails(
            Consumer<DescribeApplicationInstanceDetailsRequest.Builder> describeApplicationInstanceDetailsRequest) {
        return describeApplicationInstanceDetails(DescribeApplicationInstanceDetailsRequest.builder()
                .applyMutation(describeApplicationInstanceDetailsRequest).build());
    }

    /**
     * <p>
     * Returns information about a device.
     * </p>
     *
     * @param describeDeviceRequest
     * @return A Java Future containing the result of the DescribeDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.DescribeDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDeviceResponse> describeDevice(DescribeDeviceRequest describeDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeDeviceRequest#builder()}
     * </p>
     *
     * @param describeDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.DescribeDeviceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.DescribeDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDeviceResponse> describeDevice(Consumer<DescribeDeviceRequest.Builder> describeDeviceRequest) {
        return describeDevice(DescribeDeviceRequest.builder().applyMutation(describeDeviceRequest).build());
    }

    /**
     * <p>
     * Returns information about a device job.
     * </p>
     *
     * @param describeDeviceJobRequest
     * @return A Java Future containing the result of the DescribeDeviceJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.DescribeDeviceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeDeviceJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDeviceJobResponse> describeDeviceJob(DescribeDeviceJobRequest describeDeviceJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a device job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeviceJobRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDeviceJobRequest#builder()}
     * </p>
     *
     * @param describeDeviceJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.DescribeDeviceJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDeviceJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.DescribeDeviceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeDeviceJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDeviceJobResponse> describeDeviceJob(
            Consumer<DescribeDeviceJobRequest.Builder> describeDeviceJobRequest) {
        return describeDeviceJob(DescribeDeviceJobRequest.builder().applyMutation(describeDeviceJobRequest).build());
    }

    /**
     * <p>
     * Returns information about a node.
     * </p>
     *
     * @param describeNodeRequest
     * @return A Java Future containing the result of the DescribeNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.DescribeNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeNode" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeNodeResponse> describeNode(DescribeNodeRequest describeNodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a node.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNodeRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeNodeRequest#builder()}
     * </p>
     *
     * @param describeNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.DescribeNodeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.DescribeNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeNode" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeNodeResponse> describeNode(Consumer<DescribeNodeRequest.Builder> describeNodeRequest) {
        return describeNode(DescribeNodeRequest.builder().applyMutation(describeNodeRequest).build());
    }

    /**
     * <p>
     * Returns information about a job to create a camera stream node.
     * </p>
     *
     * @param describeNodeFromTemplateJobRequest
     * @return A Java Future containing the result of the DescribeNodeFromTemplateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.DescribeNodeFromTemplateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeNodeFromTemplateJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeNodeFromTemplateJobResponse> describeNodeFromTemplateJob(
            DescribeNodeFromTemplateJobRequest describeNodeFromTemplateJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a job to create a camera stream node.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNodeFromTemplateJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeNodeFromTemplateJobRequest#builder()}
     * </p>
     *
     * @param describeNodeFromTemplateJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.DescribeNodeFromTemplateJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeNodeFromTemplateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.DescribeNodeFromTemplateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeNodeFromTemplateJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeNodeFromTemplateJobResponse> describeNodeFromTemplateJob(
            Consumer<DescribeNodeFromTemplateJobRequest.Builder> describeNodeFromTemplateJobRequest) {
        return describeNodeFromTemplateJob(DescribeNodeFromTemplateJobRequest.builder()
                .applyMutation(describeNodeFromTemplateJobRequest).build());
    }

    /**
     * <p>
     * Returns information about a package.
     * </p>
     *
     * @param describePackageRequest
     * @return A Java Future containing the result of the DescribePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.DescribePackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribePackage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribePackageResponse> describePackage(DescribePackageRequest describePackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a package.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePackageRequest.Builder} avoiding the need
     * to create one manually via {@link DescribePackageRequest#builder()}
     * </p>
     *
     * @param describePackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.DescribePackageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.DescribePackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribePackage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribePackageResponse> describePackage(
            Consumer<DescribePackageRequest.Builder> describePackageRequest) {
        return describePackage(DescribePackageRequest.builder().applyMutation(describePackageRequest).build());
    }

    /**
     * <p>
     * Returns information about a package import job.
     * </p>
     *
     * @param describePackageImportJobRequest
     * @return A Java Future containing the result of the DescribePackageImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.DescribePackageImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribePackageImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePackageImportJobResponse> describePackageImportJob(
            DescribePackageImportJobRequest describePackageImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a package import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePackageImportJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribePackageImportJobRequest#builder()}
     * </p>
     *
     * @param describePackageImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.DescribePackageImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePackageImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.DescribePackageImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribePackageImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePackageImportJobResponse> describePackageImportJob(
            Consumer<DescribePackageImportJobRequest.Builder> describePackageImportJobRequest) {
        return describePackageImportJob(DescribePackageImportJobRequest.builder().applyMutation(describePackageImportJobRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about a package version.
     * </p>
     *
     * @param describePackageVersionRequest
     * @return A Java Future containing the result of the DescribePackageVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.DescribePackageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribePackageVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePackageVersionResponse> describePackageVersion(
            DescribePackageVersionRequest describePackageVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a package version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePackageVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePackageVersionRequest#builder()}
     * </p>
     *
     * @param describePackageVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.DescribePackageVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePackageVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.DescribePackageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribePackageVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePackageVersionResponse> describePackageVersion(
            Consumer<DescribePackageVersionRequest.Builder> describePackageVersionRequest) {
        return describePackageVersion(DescribePackageVersionRequest.builder().applyMutation(describePackageVersionRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of application instance dependencies.
     * </p>
     *
     * @param listApplicationInstanceDependenciesRequest
     * @return A Java Future containing the result of the ListApplicationInstanceDependencies operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListApplicationInstanceDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstanceDependencies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationInstanceDependenciesResponse> listApplicationInstanceDependencies(
            ListApplicationInstanceDependenciesRequest listApplicationInstanceDependenciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of application instance dependencies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationInstanceDependenciesRequest.Builder}
     * avoiding the need to create one manually via {@link ListApplicationInstanceDependenciesRequest#builder()}
     * </p>
     *
     * @param listApplicationInstanceDependenciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListApplicationInstanceDependencies operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListApplicationInstanceDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstanceDependencies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationInstanceDependenciesResponse> listApplicationInstanceDependencies(
            Consumer<ListApplicationInstanceDependenciesRequest.Builder> listApplicationInstanceDependenciesRequest) {
        return listApplicationInstanceDependencies(ListApplicationInstanceDependenciesRequest.builder()
                .applyMutation(listApplicationInstanceDependenciesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationInstanceDependencies(software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListApplicationInstanceDependenciesPublisher publisher = client.listApplicationInstanceDependenciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListApplicationInstanceDependenciesPublisher publisher = client.listApplicationInstanceDependenciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationInstanceDependencies(software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationInstanceDependenciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListApplicationInstanceDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstanceDependencies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationInstanceDependenciesPublisher listApplicationInstanceDependenciesPaginator(
            ListApplicationInstanceDependenciesRequest listApplicationInstanceDependenciesRequest) {
        return new ListApplicationInstanceDependenciesPublisher(this, listApplicationInstanceDependenciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationInstanceDependencies(software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListApplicationInstanceDependenciesPublisher publisher = client.listApplicationInstanceDependenciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListApplicationInstanceDependenciesPublisher publisher = client.listApplicationInstanceDependenciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationInstanceDependencies(software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationInstanceDependenciesRequest.Builder}
     * avoiding the need to create one manually via {@link ListApplicationInstanceDependenciesRequest#builder()}
     * </p>
     *
     * @param listApplicationInstanceDependenciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListApplicationInstanceDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstanceDependencies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationInstanceDependenciesPublisher listApplicationInstanceDependenciesPaginator(
            Consumer<ListApplicationInstanceDependenciesRequest.Builder> listApplicationInstanceDependenciesRequest) {
        return listApplicationInstanceDependenciesPaginator(ListApplicationInstanceDependenciesRequest.builder()
                .applyMutation(listApplicationInstanceDependenciesRequest).build());
    }

    /**
     * <p>
     * Returns a list of application node instances.
     * </p>
     *
     * @param listApplicationInstanceNodeInstancesRequest
     * @return A Java Future containing the result of the ListApplicationInstanceNodeInstances operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListApplicationInstanceNodeInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstanceNodeInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationInstanceNodeInstancesResponse> listApplicationInstanceNodeInstances(
            ListApplicationInstanceNodeInstancesRequest listApplicationInstanceNodeInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of application node instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListApplicationInstanceNodeInstancesRequest.Builder} avoiding the need to create one manually via
     * {@link ListApplicationInstanceNodeInstancesRequest#builder()}
     * </p>
     *
     * @param listApplicationInstanceNodeInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListApplicationInstanceNodeInstances operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListApplicationInstanceNodeInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstanceNodeInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationInstanceNodeInstancesResponse> listApplicationInstanceNodeInstances(
            Consumer<ListApplicationInstanceNodeInstancesRequest.Builder> listApplicationInstanceNodeInstancesRequest) {
        return listApplicationInstanceNodeInstances(ListApplicationInstanceNodeInstancesRequest.builder()
                .applyMutation(listApplicationInstanceNodeInstancesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationInstanceNodeInstances(software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListApplicationInstanceNodeInstancesPublisher publisher = client.listApplicationInstanceNodeInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListApplicationInstanceNodeInstancesPublisher publisher = client.listApplicationInstanceNodeInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationInstanceNodeInstances(software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationInstanceNodeInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListApplicationInstanceNodeInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstanceNodeInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationInstanceNodeInstancesPublisher listApplicationInstanceNodeInstancesPaginator(
            ListApplicationInstanceNodeInstancesRequest listApplicationInstanceNodeInstancesRequest) {
        return new ListApplicationInstanceNodeInstancesPublisher(this, listApplicationInstanceNodeInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationInstanceNodeInstances(software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListApplicationInstanceNodeInstancesPublisher publisher = client.listApplicationInstanceNodeInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListApplicationInstanceNodeInstancesPublisher publisher = client.listApplicationInstanceNodeInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationInstanceNodeInstances(software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListApplicationInstanceNodeInstancesRequest.Builder} avoiding the need to create one manually via
     * {@link ListApplicationInstanceNodeInstancesRequest#builder()}
     * </p>
     *
     * @param listApplicationInstanceNodeInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListApplicationInstanceNodeInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstanceNodeInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationInstanceNodeInstancesPublisher listApplicationInstanceNodeInstancesPaginator(
            Consumer<ListApplicationInstanceNodeInstancesRequest.Builder> listApplicationInstanceNodeInstancesRequest) {
        return listApplicationInstanceNodeInstancesPaginator(ListApplicationInstanceNodeInstancesRequest.builder()
                .applyMutation(listApplicationInstanceNodeInstancesRequest).build());
    }

    /**
     * <p>
     * Returns a list of application instances.
     * </p>
     *
     * @param listApplicationInstancesRequest
     * @return A Java Future containing the result of the ListApplicationInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListApplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationInstancesResponse> listApplicationInstances(
            ListApplicationInstancesRequest listApplicationInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of application instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationInstancesRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationInstancesRequest#builder()}
     * </p>
     *
     * @param listApplicationInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListApplicationInstancesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListApplicationInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListApplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationInstancesResponse> listApplicationInstances(
            Consumer<ListApplicationInstancesRequest.Builder> listApplicationInstancesRequest) {
        return listApplicationInstances(ListApplicationInstancesRequest.builder().applyMutation(listApplicationInstancesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationInstances(software.amazon.awssdk.services.panorama.model.ListApplicationInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListApplicationInstancesPublisher publisher = client.listApplicationInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListApplicationInstancesPublisher publisher = client.listApplicationInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.panorama.model.ListApplicationInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.panorama.model.ListApplicationInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationInstances(software.amazon.awssdk.services.panorama.model.ListApplicationInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListApplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationInstancesPublisher listApplicationInstancesPaginator(
            ListApplicationInstancesRequest listApplicationInstancesRequest) {
        return new ListApplicationInstancesPublisher(this, listApplicationInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationInstances(software.amazon.awssdk.services.panorama.model.ListApplicationInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListApplicationInstancesPublisher publisher = client.listApplicationInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListApplicationInstancesPublisher publisher = client.listApplicationInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.panorama.model.ListApplicationInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.panorama.model.ListApplicationInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationInstances(software.amazon.awssdk.services.panorama.model.ListApplicationInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationInstancesRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationInstancesRequest#builder()}
     * </p>
     *
     * @param listApplicationInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListApplicationInstancesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListApplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationInstancesPublisher listApplicationInstancesPaginator(
            Consumer<ListApplicationInstancesRequest.Builder> listApplicationInstancesRequest) {
        return listApplicationInstancesPaginator(ListApplicationInstancesRequest.builder()
                .applyMutation(listApplicationInstancesRequest).build());
    }

    /**
     * <p>
     * Returns a list of devices.
     * </p>
     *
     * @param listDevicesRequest
     * @return A Java Future containing the result of the ListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDevicesResponse> listDevices(ListDevicesRequest listDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of devices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDevicesRequest#builder()}
     * </p>
     *
     * @param listDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListDevicesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDevicesResponse> listDevices(Consumer<ListDevicesRequest.Builder> listDevicesRequest) {
        return listDevices(ListDevicesRequest.builder().applyMutation(listDevicesRequest).build());
    }

    /**
     * <p>
     * Returns a list of jobs.
     * </p>
     *
     * @param listDevicesJobsRequest
     * @return A Java Future containing the result of the ListDevicesJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListDevicesJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListDevicesJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDevicesJobsResponse> listDevicesJobs(ListDevicesJobsRequest listDevicesJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicesJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDevicesJobsRequest#builder()}
     * </p>
     *
     * @param listDevicesJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListDevicesJobsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDevicesJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListDevicesJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListDevicesJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDevicesJobsResponse> listDevicesJobs(
            Consumer<ListDevicesJobsRequest.Builder> listDevicesJobsRequest) {
        return listDevicesJobs(ListDevicesJobsRequest.builder().applyMutation(listDevicesJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDevicesJobs(software.amazon.awssdk.services.panorama.model.ListDevicesJobsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListDevicesJobsPublisher publisher = client.listDevicesJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListDevicesJobsPublisher publisher = client.listDevicesJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.panorama.model.ListDevicesJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.panorama.model.ListDevicesJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevicesJobs(software.amazon.awssdk.services.panorama.model.ListDevicesJobsRequest)} operation.</b>
     * </p>
     *
     * @param listDevicesJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListDevicesJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListDevicesJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesJobsPublisher listDevicesJobsPaginator(ListDevicesJobsRequest listDevicesJobsRequest) {
        return new ListDevicesJobsPublisher(this, listDevicesJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDevicesJobs(software.amazon.awssdk.services.panorama.model.ListDevicesJobsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListDevicesJobsPublisher publisher = client.listDevicesJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListDevicesJobsPublisher publisher = client.listDevicesJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.panorama.model.ListDevicesJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.panorama.model.ListDevicesJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevicesJobs(software.amazon.awssdk.services.panorama.model.ListDevicesJobsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicesJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDevicesJobsRequest#builder()}
     * </p>
     *
     * @param listDevicesJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListDevicesJobsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListDevicesJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListDevicesJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesJobsPublisher listDevicesJobsPaginator(Consumer<ListDevicesJobsRequest.Builder> listDevicesJobsRequest) {
        return listDevicesJobsPaginator(ListDevicesJobsRequest.builder().applyMutation(listDevicesJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listDevices(software.amazon.awssdk.services.panorama.model.ListDevicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListDevicesPublisher publisher = client.listDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListDevicesPublisher publisher = client.listDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.panorama.model.ListDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.panorama.model.ListDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevices(software.amazon.awssdk.services.panorama.model.ListDevicesRequest)} operation.</b>
     * </p>
     *
     * @param listDevicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesPublisher listDevicesPaginator(ListDevicesRequest listDevicesRequest) {
        return new ListDevicesPublisher(this, listDevicesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listDevices(software.amazon.awssdk.services.panorama.model.ListDevicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListDevicesPublisher publisher = client.listDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListDevicesPublisher publisher = client.listDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.panorama.model.ListDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.panorama.model.ListDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevices(software.amazon.awssdk.services.panorama.model.ListDevicesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDevicesRequest#builder()}
     * </p>
     *
     * @param listDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListDevicesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesPublisher listDevicesPaginator(Consumer<ListDevicesRequest.Builder> listDevicesRequest) {
        return listDevicesPaginator(ListDevicesRequest.builder().applyMutation(listDevicesRequest).build());
    }

    /**
     * <p>
     * Returns a list of camera stream node jobs.
     * </p>
     *
     * @param listNodeFromTemplateJobsRequest
     * @return A Java Future containing the result of the ListNodeFromTemplateJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListNodeFromTemplateJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListNodeFromTemplateJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNodeFromTemplateJobsResponse> listNodeFromTemplateJobs(
            ListNodeFromTemplateJobsRequest listNodeFromTemplateJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of camera stream node jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNodeFromTemplateJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListNodeFromTemplateJobsRequest#builder()}
     * </p>
     *
     * @param listNodeFromTemplateJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListNodeFromTemplateJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListNodeFromTemplateJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListNodeFromTemplateJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNodeFromTemplateJobsResponse> listNodeFromTemplateJobs(
            Consumer<ListNodeFromTemplateJobsRequest.Builder> listNodeFromTemplateJobsRequest) {
        return listNodeFromTemplateJobs(ListNodeFromTemplateJobsRequest.builder().applyMutation(listNodeFromTemplateJobsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNodeFromTemplateJobs(software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListNodeFromTemplateJobsPublisher publisher = client.listNodeFromTemplateJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListNodeFromTemplateJobsPublisher publisher = client.listNodeFromTemplateJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNodeFromTemplateJobs(software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNodeFromTemplateJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListNodeFromTemplateJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListNodeFromTemplateJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNodeFromTemplateJobsPublisher listNodeFromTemplateJobsPaginator(
            ListNodeFromTemplateJobsRequest listNodeFromTemplateJobsRequest) {
        return new ListNodeFromTemplateJobsPublisher(this, listNodeFromTemplateJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNodeFromTemplateJobs(software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListNodeFromTemplateJobsPublisher publisher = client.listNodeFromTemplateJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListNodeFromTemplateJobsPublisher publisher = client.listNodeFromTemplateJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNodeFromTemplateJobs(software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNodeFromTemplateJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListNodeFromTemplateJobsRequest#builder()}
     * </p>
     *
     * @param listNodeFromTemplateJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListNodeFromTemplateJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListNodeFromTemplateJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNodeFromTemplateJobsPublisher listNodeFromTemplateJobsPaginator(
            Consumer<ListNodeFromTemplateJobsRequest.Builder> listNodeFromTemplateJobsRequest) {
        return listNodeFromTemplateJobsPaginator(ListNodeFromTemplateJobsRequest.builder()
                .applyMutation(listNodeFromTemplateJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of nodes.
     * </p>
     *
     * @param listNodesRequest
     * @return A Java Future containing the result of the ListNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListNodesResponse> listNodes(ListNodesRequest listNodesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of nodes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNodesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNodesRequest#builder()}
     * </p>
     *
     * @param listNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListNodesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListNodesResponse> listNodes(Consumer<ListNodesRequest.Builder> listNodesRequest) {
        return listNodes(ListNodesRequest.builder().applyMutation(listNodesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listNodes(software.amazon.awssdk.services.panorama.model.ListNodesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListNodesPublisher publisher = client.listNodesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListNodesPublisher publisher = client.listNodesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.panorama.model.ListNodesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.panorama.model.ListNodesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNodes(software.amazon.awssdk.services.panorama.model.ListNodesRequest)} operation.</b>
     * </p>
     *
     * @param listNodesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNodesPublisher listNodesPaginator(ListNodesRequest listNodesRequest) {
        return new ListNodesPublisher(this, listNodesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listNodes(software.amazon.awssdk.services.panorama.model.ListNodesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListNodesPublisher publisher = client.listNodesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListNodesPublisher publisher = client.listNodesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.panorama.model.ListNodesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.panorama.model.ListNodesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNodes(software.amazon.awssdk.services.panorama.model.ListNodesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNodesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNodesRequest#builder()}
     * </p>
     *
     * @param listNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListNodesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNodesPublisher listNodesPaginator(Consumer<ListNodesRequest.Builder> listNodesRequest) {
        return listNodesPaginator(ListNodesRequest.builder().applyMutation(listNodesRequest).build());
    }

    /**
     * <p>
     * Returns a list of package import jobs.
     * </p>
     *
     * @param listPackageImportJobsRequest
     * @return A Java Future containing the result of the ListPackageImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListPackageImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListPackageImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPackageImportJobsResponse> listPackageImportJobs(
            ListPackageImportJobsRequest listPackageImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of package import jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPackageImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPackageImportJobsRequest#builder()}
     * </p>
     *
     * @param listPackageImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListPackageImportJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPackageImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListPackageImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListPackageImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPackageImportJobsResponse> listPackageImportJobs(
            Consumer<ListPackageImportJobsRequest.Builder> listPackageImportJobsRequest) {
        return listPackageImportJobs(ListPackageImportJobsRequest.builder().applyMutation(listPackageImportJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPackageImportJobs(software.amazon.awssdk.services.panorama.model.ListPackageImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListPackageImportJobsPublisher publisher = client.listPackageImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListPackageImportJobsPublisher publisher = client.listPackageImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.panorama.model.ListPackageImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.panorama.model.ListPackageImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPackageImportJobs(software.amazon.awssdk.services.panorama.model.ListPackageImportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPackageImportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListPackageImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListPackageImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPackageImportJobsPublisher listPackageImportJobsPaginator(
            ListPackageImportJobsRequest listPackageImportJobsRequest) {
        return new ListPackageImportJobsPublisher(this, listPackageImportJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPackageImportJobs(software.amazon.awssdk.services.panorama.model.ListPackageImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListPackageImportJobsPublisher publisher = client.listPackageImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListPackageImportJobsPublisher publisher = client.listPackageImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.panorama.model.ListPackageImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.panorama.model.ListPackageImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPackageImportJobs(software.amazon.awssdk.services.panorama.model.ListPackageImportJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPackageImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPackageImportJobsRequest#builder()}
     * </p>
     *
     * @param listPackageImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListPackageImportJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListPackageImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListPackageImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPackageImportJobsPublisher listPackageImportJobsPaginator(
            Consumer<ListPackageImportJobsRequest.Builder> listPackageImportJobsRequest) {
        return listPackageImportJobsPaginator(ListPackageImportJobsRequest.builder().applyMutation(listPackageImportJobsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of packages.
     * </p>
     *
     * @param listPackagesRequest
     * @return A Java Future containing the result of the ListPackages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListPackages" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPackagesResponse> listPackages(ListPackagesRequest listPackagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of packages.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPackagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPackagesRequest#builder()}
     * </p>
     *
     * @param listPackagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListPackagesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListPackages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListPackages" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPackagesResponse> listPackages(Consumer<ListPackagesRequest.Builder> listPackagesRequest) {
        return listPackages(ListPackagesRequest.builder().applyMutation(listPackagesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listPackages(software.amazon.awssdk.services.panorama.model.ListPackagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListPackagesPublisher publisher = client.listPackagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListPackagesPublisher publisher = client.listPackagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.panorama.model.ListPackagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.panorama.model.ListPackagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPackages(software.amazon.awssdk.services.panorama.model.ListPackagesRequest)} operation.</b>
     * </p>
     *
     * @param listPackagesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListPackages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPackagesPublisher listPackagesPaginator(ListPackagesRequest listPackagesRequest) {
        return new ListPackagesPublisher(this, listPackagesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listPackages(software.amazon.awssdk.services.panorama.model.ListPackagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListPackagesPublisher publisher = client.listPackagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.panorama.paginators.ListPackagesPublisher publisher = client.listPackagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.panorama.model.ListPackagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.panorama.model.ListPackagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPackages(software.amazon.awssdk.services.panorama.model.ListPackagesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPackagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPackagesRequest#builder()}
     * </p>
     *
     * @param listPackagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListPackagesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListPackages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPackagesPublisher listPackagesPaginator(Consumer<ListPackagesRequest.Builder> listPackagesRequest) {
        return listPackagesPaginator(ListPackagesRequest.builder().applyMutation(listPackagesRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Creates a device and returns a configuration archive. The configuration archive is a ZIP file that contains a
     * provisioning certificate that is valid for 5 minutes. Name the configuration archive
     * <code>certificates-omni_<i>device-name</i>.zip</code> and transfer it to the device within 5 minutes. Use the
     * included USB storage device and connect it to the USB 3.0 port next to the HDMI output.
     * </p>
     *
     * @param provisionDeviceRequest
     * @return A Java Future containing the result of the ProvisionDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ServiceQuotaExceededException The request would cause a limit to be exceeded.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ProvisionDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ProvisionDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ProvisionDeviceResponse> provisionDevice(ProvisionDeviceRequest provisionDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a device and returns a configuration archive. The configuration archive is a ZIP file that contains a
     * provisioning certificate that is valid for 5 minutes. Name the configuration archive
     * <code>certificates-omni_<i>device-name</i>.zip</code> and transfer it to the device within 5 minutes. Use the
     * included USB storage device and connect it to the USB 3.0 port next to the HDMI output.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ProvisionDeviceRequest.Builder} avoiding the need
     * to create one manually via {@link ProvisionDeviceRequest#builder()}
     * </p>
     *
     * @param provisionDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.ProvisionDeviceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ProvisionDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ServiceQuotaExceededException The request would cause a limit to be exceeded.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.ProvisionDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ProvisionDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ProvisionDeviceResponse> provisionDevice(
            Consumer<ProvisionDeviceRequest.Builder> provisionDeviceRequest) {
        return provisionDevice(ProvisionDeviceRequest.builder().applyMutation(provisionDeviceRequest).build());
    }

    /**
     * <p>
     * Registers a package version.
     * </p>
     *
     * @param registerPackageVersionRequest
     * @return A Java Future containing the result of the RegisterPackageVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.RegisterPackageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/RegisterPackageVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterPackageVersionResponse> registerPackageVersion(
            RegisterPackageVersionRequest registerPackageVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a package version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterPackageVersionRequest.Builder} avoiding the
     * need to create one manually via {@link RegisterPackageVersionRequest#builder()}
     * </p>
     *
     * @param registerPackageVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.RegisterPackageVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RegisterPackageVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.RegisterPackageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/RegisterPackageVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterPackageVersionResponse> registerPackageVersion(
            Consumer<RegisterPackageVersionRequest.Builder> registerPackageVersionRequest) {
        return registerPackageVersion(RegisterPackageVersionRequest.builder().applyMutation(registerPackageVersionRequest)
                .build());
    }

    /**
     * <p>
     * Removes an application instance.
     * </p>
     *
     * @param removeApplicationInstanceRequest
     * @return A Java Future containing the result of the RemoveApplicationInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.RemoveApplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/RemoveApplicationInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveApplicationInstanceResponse> removeApplicationInstance(
            RemoveApplicationInstanceRequest removeApplicationInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an application instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveApplicationInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link RemoveApplicationInstanceRequest#builder()}
     * </p>
     *
     * @param removeApplicationInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.RemoveApplicationInstanceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the RemoveApplicationInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.RemoveApplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/RemoveApplicationInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveApplicationInstanceResponse> removeApplicationInstance(
            Consumer<RemoveApplicationInstanceRequest.Builder> removeApplicationInstanceRequest) {
        return removeApplicationInstance(RemoveApplicationInstanceRequest.builder()
                .applyMutation(removeApplicationInstanceRequest).build());
    }

    /**
     * <p>
     * Signal camera nodes to stop or resume.
     * </p>
     *
     * @param signalApplicationInstanceNodeInstancesRequest
     * @return A Java Future containing the result of the SignalApplicationInstanceNodeInstances operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ServiceQuotaExceededException The request would cause a limit to be exceeded.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.SignalApplicationInstanceNodeInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/SignalApplicationInstanceNodeInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SignalApplicationInstanceNodeInstancesResponse> signalApplicationInstanceNodeInstances(
            SignalApplicationInstanceNodeInstancesRequest signalApplicationInstanceNodeInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Signal camera nodes to stop or resume.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link SignalApplicationInstanceNodeInstancesRequest.Builder} avoiding the need to create one manually via
     * {@link SignalApplicationInstanceNodeInstancesRequest#builder()}
     * </p>
     *
     * @param signalApplicationInstanceNodeInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.SignalApplicationInstanceNodeInstancesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the SignalApplicationInstanceNodeInstances operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ServiceQuotaExceededException The request would cause a limit to be exceeded.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.SignalApplicationInstanceNodeInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/SignalApplicationInstanceNodeInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SignalApplicationInstanceNodeInstancesResponse> signalApplicationInstanceNodeInstances(
            Consumer<SignalApplicationInstanceNodeInstancesRequest.Builder> signalApplicationInstanceNodeInstancesRequest) {
        return signalApplicationInstanceNodeInstances(SignalApplicationInstanceNodeInstancesRequest.builder()
                .applyMutation(signalApplicationInstanceNodeInstancesRequest).build());
    }

    /**
     * <p>
     * Tags a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a device's metadata.
     * </p>
     *
     * @param updateDeviceMetadataRequest
     * @return A Java Future containing the result of the UpdateDeviceMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.UpdateDeviceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/UpdateDeviceMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDeviceMetadataResponse> updateDeviceMetadata(
            UpdateDeviceMetadataRequest updateDeviceMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a device's metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDeviceMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDeviceMetadataRequest#builder()}
     * </p>
     *
     * @param updateDeviceMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.panorama.model.UpdateDeviceMetadataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDeviceMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The target resource is in use.</li>
     *         <li>ValidationException The request contains an invalid parameter value.</li>
     *         <li>AccessDeniedException The requestor does not have permission to access the target action or resource.
     *         </li>
     *         <li>ResourceNotFoundException The target resource was not found.</li>
     *         <li>InternalServerException An internal error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PanoramaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PanoramaAsyncClient.UpdateDeviceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/UpdateDeviceMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDeviceMetadataResponse> updateDeviceMetadata(
            Consumer<UpdateDeviceMetadataRequest.Builder> updateDeviceMetadataRequest) {
        return updateDeviceMetadata(UpdateDeviceMetadataRequest.builder().applyMutation(updateDeviceMetadataRequest).build());
    }

    @Override
    default PanoramaServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link PanoramaAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PanoramaAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PanoramaAsyncClient}.
     */
    static PanoramaAsyncClientBuilder builder() {
        return new DefaultPanoramaAsyncClientBuilder();
    }
}
