/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.panorama.PanoramaAsyncClient;
import software.amazon.awssdk.services.panorama.internal.UserAgentUtils;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesRequest;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesResponse;

public class ListApplicationInstanceDependenciesPublisher
implements SdkPublisher<ListApplicationInstanceDependenciesResponse> {
    private final PanoramaAsyncClient client;
    private final ListApplicationInstanceDependenciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApplicationInstanceDependenciesPublisher(PanoramaAsyncClient client, ListApplicationInstanceDependenciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApplicationInstanceDependenciesPublisher(PanoramaAsyncClient client, ListApplicationInstanceDependenciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApplicationInstanceDependenciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListApplicationInstanceDependenciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListApplicationInstanceDependenciesResponseFetcher
    implements AsyncPageFetcher<ListApplicationInstanceDependenciesResponse> {
        private ListApplicationInstanceDependenciesResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationInstanceDependenciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListApplicationInstanceDependenciesResponse> nextPage(ListApplicationInstanceDependenciesResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationInstanceDependenciesPublisher.this.client.listApplicationInstanceDependencies(ListApplicationInstanceDependenciesPublisher.this.firstRequest);
            }
            return ListApplicationInstanceDependenciesPublisher.this.client.listApplicationInstanceDependencies((ListApplicationInstanceDependenciesRequest)((Object)ListApplicationInstanceDependenciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

