/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An application node that represents a camera stream, a model, code, or output.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Node implements SdkPojo, Serializable, ToCopyableBuilder<Node.Builder, Node> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Category").getter(getter(Node::categoryAsString)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(Node::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Node::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Node::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("NodeId")
            .getter(getter(Node::nodeId)).setter(setter(Builder::nodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerAccount").getter(getter(Node::ownerAccount)).setter(setter(Builder::ownerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccount").build()).build();

    private static final SdkField<String> PACKAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageArn").getter(getter(Node::packageArn)).setter(setter(Builder::packageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageArn").build()).build();

    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageId").getter(getter(Node::packageId)).setter(setter(Builder::packageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageId").build()).build();

    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageName").getter(getter(Node::packageName)).setter(setter(Builder::packageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageName").build()).build();

    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageVersion").getter(getter(Node::packageVersion)).setter(setter(Builder::packageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageVersion").build()).build();

    private static final SdkField<String> PATCH_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PatchVersion").getter(getter(Node::patchVersion)).setter(setter(Builder::patchVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD,
            CREATED_TIME_FIELD, DESCRIPTION_FIELD, NAME_FIELD, NODE_ID_FIELD, OWNER_ACCOUNT_FIELD, PACKAGE_ARN_FIELD,
            PACKAGE_ID_FIELD, PACKAGE_NAME_FIELD, PACKAGE_VERSION_FIELD, PATCH_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String category;

    private final Instant createdTime;

    private final String description;

    private final String name;

    private final String nodeId;

    private final String ownerAccount;

    private final String packageArn;

    private final String packageId;

    private final String packageName;

    private final String packageVersion;

    private final String patchVersion;

    private Node(BuilderImpl builder) {
        this.category = builder.category;
        this.createdTime = builder.createdTime;
        this.description = builder.description;
        this.name = builder.name;
        this.nodeId = builder.nodeId;
        this.ownerAccount = builder.ownerAccount;
        this.packageArn = builder.packageArn;
        this.packageId = builder.packageId;
        this.packageName = builder.packageName;
        this.packageVersion = builder.packageVersion;
        this.patchVersion = builder.patchVersion;
    }

    /**
     * <p>
     * The node's category.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link NodeCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return The node's category.
     * @see NodeCategory
     */
    public final NodeCategory category() {
        return NodeCategory.fromValue(category);
    }

    /**
     * <p>
     * The node's category.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link NodeCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return The node's category.
     * @see NodeCategory
     */
    public final String categoryAsString() {
        return category;
    }

    /**
     * <p>
     * When the node was created.
     * </p>
     * 
     * @return When the node was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The node's description.
     * </p>
     * 
     * @return The node's description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The node's name.
     * </p>
     * 
     * @return The node's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The node's ID.
     * </p>
     * 
     * @return The node's ID.
     */
    public final String nodeId() {
        return nodeId;
    }

    /**
     * <p>
     * The account ID of the node's owner.
     * </p>
     * 
     * @return The account ID of the node's owner.
     */
    public final String ownerAccount() {
        return ownerAccount;
    }

    /**
     * <p>
     * The node's ARN.
     * </p>
     * 
     * @return The node's ARN.
     */
    public final String packageArn() {
        return packageArn;
    }

    /**
     * <p>
     * The node's package ID.
     * </p>
     * 
     * @return The node's package ID.
     */
    public final String packageId() {
        return packageId;
    }

    /**
     * <p>
     * The node's package name.
     * </p>
     * 
     * @return The node's package name.
     */
    public final String packageName() {
        return packageName;
    }

    /**
     * <p>
     * The node's package version.
     * </p>
     * 
     * @return The node's package version.
     */
    public final String packageVersion() {
        return packageVersion;
    }

    /**
     * <p>
     * The node's patch version.
     * </p>
     * 
     * @return The node's patch version.
     */
    public final String patchVersion() {
        return patchVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(packageArn());
        hashCode = 31 * hashCode + Objects.hashCode(packageId());
        hashCode = 31 * hashCode + Objects.hashCode(packageName());
        hashCode = 31 * hashCode + Objects.hashCode(packageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(patchVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node) obj;
        return Objects.equals(categoryAsString(), other.categoryAsString()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(description(), other.description()) && Objects.equals(name(), other.name())
                && Objects.equals(nodeId(), other.nodeId()) && Objects.equals(ownerAccount(), other.ownerAccount())
                && Objects.equals(packageArn(), other.packageArn()) && Objects.equals(packageId(), other.packageId())
                && Objects.equals(packageName(), other.packageName()) && Objects.equals(packageVersion(), other.packageVersion())
                && Objects.equals(patchVersion(), other.patchVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Node").add("Category", categoryAsString()).add("CreatedTime", createdTime())
                .add("Description", description()).add("Name", name()).add("NodeId", nodeId())
                .add("OwnerAccount", ownerAccount()).add("PackageArn", packageArn()).add("PackageId", packageId())
                .add("PackageName", packageName()).add("PackageVersion", packageVersion()).add("PatchVersion", patchVersion())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Category":
            return Optional.ofNullable(clazz.cast(categoryAsString()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NodeId":
            return Optional.ofNullable(clazz.cast(nodeId()));
        case "OwnerAccount":
            return Optional.ofNullable(clazz.cast(ownerAccount()));
        case "PackageArn":
            return Optional.ofNullable(clazz.cast(packageArn()));
        case "PackageId":
            return Optional.ofNullable(clazz.cast(packageId()));
        case "PackageName":
            return Optional.ofNullable(clazz.cast(packageName()));
        case "PackageVersion":
            return Optional.ofNullable(clazz.cast(packageVersion()));
        case "PatchVersion":
            return Optional.ofNullable(clazz.cast(patchVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Node, T> g) {
        return obj -> g.apply((Node) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Node> {
        /**
         * <p>
         * The node's category.
         * </p>
         * 
         * @param category
         *        The node's category.
         * @see NodeCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeCategory
         */
        Builder category(String category);

        /**
         * <p>
         * The node's category.
         * </p>
         * 
         * @param category
         *        The node's category.
         * @see NodeCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeCategory
         */
        Builder category(NodeCategory category);

        /**
         * <p>
         * When the node was created.
         * </p>
         * 
         * @param createdTime
         *        When the node was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The node's description.
         * </p>
         * 
         * @param description
         *        The node's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The node's name.
         * </p>
         * 
         * @param name
         *        The node's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The node's ID.
         * </p>
         * 
         * @param nodeId
         *        The node's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeId(String nodeId);

        /**
         * <p>
         * The account ID of the node's owner.
         * </p>
         * 
         * @param ownerAccount
         *        The account ID of the node's owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccount(String ownerAccount);

        /**
         * <p>
         * The node's ARN.
         * </p>
         * 
         * @param packageArn
         *        The node's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageArn(String packageArn);

        /**
         * <p>
         * The node's package ID.
         * </p>
         * 
         * @param packageId
         *        The node's package ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageId(String packageId);

        /**
         * <p>
         * The node's package name.
         * </p>
         * 
         * @param packageName
         *        The node's package name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageName(String packageName);

        /**
         * <p>
         * The node's package version.
         * </p>
         * 
         * @param packageVersion
         *        The node's package version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageVersion(String packageVersion);

        /**
         * <p>
         * The node's patch version.
         * </p>
         * 
         * @param patchVersion
         *        The node's patch version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchVersion(String patchVersion);
    }

    static final class BuilderImpl implements Builder {
        private String category;

        private Instant createdTime;

        private String description;

        private String name;

        private String nodeId;

        private String ownerAccount;

        private String packageArn;

        private String packageId;

        private String packageName;

        private String packageVersion;

        private String patchVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Node model) {
            category(model.category);
            createdTime(model.createdTime);
            description(model.description);
            name(model.name);
            nodeId(model.nodeId);
            ownerAccount(model.ownerAccount);
            packageArn(model.packageArn);
            packageId(model.packageId);
            packageName(model.packageName);
            packageVersion(model.packageVersion);
            patchVersion(model.patchVersion);
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(NodeCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNodeId() {
            return nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final String getOwnerAccount() {
            return ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final String getPackageArn() {
            return packageArn;
        }

        public final void setPackageArn(String packageArn) {
            this.packageArn = packageArn;
        }

        @Override
        public final Builder packageArn(String packageArn) {
            this.packageArn = packageArn;
            return this;
        }

        public final String getPackageId() {
            return packageId;
        }

        public final void setPackageId(String packageId) {
            this.packageId = packageId;
        }

        @Override
        public final Builder packageId(String packageId) {
            this.packageId = packageId;
            return this;
        }

        public final String getPackageName() {
            return packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getPackageVersion() {
            return packageVersion;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        @Override
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final String getPatchVersion() {
            return patchVersion;
        }

        public final void setPatchVersion(String patchVersion) {
            this.patchVersion = patchVersion;
        }

        @Override
        public final Builder patchVersion(String patchVersion) {
            this.patchVersion = patchVersion;
            return this;
        }

        @Override
        public Node build() {
            return new Node(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
