/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePackageResponse extends PanoramaResponse implements
        ToCopyableBuilder<DescribePackageResponse.Builder, DescribePackageResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribePackageResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(DescribePackageResponse::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageId").getter(getter(DescribePackageResponse::packageId)).setter(setter(Builder::packageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageId").build()).build();

    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageName").getter(getter(DescribePackageResponse::packageName)).setter(setter(Builder::packageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageName").build()).build();

    private static final SdkField<List<String>> READ_ACCESS_PRINCIPAL_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReadAccessPrincipalArns")
            .getter(getter(DescribePackageResponse::readAccessPrincipalArns))
            .setter(setter(Builder::readAccessPrincipalArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadAccessPrincipalArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<StorageLocation> STORAGE_LOCATION_FIELD = SdkField
            .<StorageLocation> builder(MarshallingType.SDK_POJO).memberName("StorageLocation")
            .getter(getter(DescribePackageResponse::storageLocation)).setter(setter(Builder::storageLocation))
            .constructor(StorageLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLocation").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(DescribePackageResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> WRITE_ACCESS_PRINCIPAL_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("WriteAccessPrincipalArns")
            .getter(getter(DescribePackageResponse::writeAccessPrincipalArns))
            .setter(setter(Builder::writeAccessPrincipalArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteAccessPrincipalArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_TIME_FIELD,
            PACKAGE_ID_FIELD, PACKAGE_NAME_FIELD, READ_ACCESS_PRINCIPAL_ARNS_FIELD, STORAGE_LOCATION_FIELD, TAGS_FIELD,
            WRITE_ACCESS_PRINCIPAL_ARNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final Instant createdTime;

    private final String packageId;

    private final String packageName;

    private final List<String> readAccessPrincipalArns;

    private final StorageLocation storageLocation;

    private final Map<String, String> tags;

    private final List<String> writeAccessPrincipalArns;

    private DescribePackageResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.createdTime = builder.createdTime;
        this.packageId = builder.packageId;
        this.packageName = builder.packageName;
        this.readAccessPrincipalArns = builder.readAccessPrincipalArns;
        this.storageLocation = builder.storageLocation;
        this.tags = builder.tags;
        this.writeAccessPrincipalArns = builder.writeAccessPrincipalArns;
    }

    /**
     * <p>
     * The package's ARN.
     * </p>
     * 
     * @return The package's ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * When the package was created.
     * </p>
     * 
     * @return When the package was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The package's ID.
     * </p>
     * 
     * @return The package's ID.
     */
    public final String packageId() {
        return packageId;
    }

    /**
     * <p>
     * The package's name.
     * </p>
     * 
     * @return The package's name.
     */
    public final String packageName() {
        return packageName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReadAccessPrincipalArns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReadAccessPrincipalArns() {
        return readAccessPrincipalArns != null && !(readAccessPrincipalArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * ARNs of accounts that have read access to the package.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReadAccessPrincipalArns} method.
     * </p>
     * 
     * @return ARNs of accounts that have read access to the package.
     */
    public final List<String> readAccessPrincipalArns() {
        return readAccessPrincipalArns;
    }

    /**
     * <p>
     * The package's storage location.
     * </p>
     * 
     * @return The package's storage location.
     */
    public final StorageLocation storageLocation() {
        return storageLocation;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The package's tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The package's tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the WriteAccessPrincipalArns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasWriteAccessPrincipalArns() {
        return writeAccessPrincipalArns != null && !(writeAccessPrincipalArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * ARNs of accounts that have write access to the package.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWriteAccessPrincipalArns} method.
     * </p>
     * 
     * @return ARNs of accounts that have write access to the package.
     */
    public final List<String> writeAccessPrincipalArns() {
        return writeAccessPrincipalArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(packageId());
        hashCode = 31 * hashCode + Objects.hashCode(packageName());
        hashCode = 31 * hashCode + Objects.hashCode(hasReadAccessPrincipalArns() ? readAccessPrincipalArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(storageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWriteAccessPrincipalArns() ? writeAccessPrincipalArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePackageResponse)) {
            return false;
        }
        DescribePackageResponse other = (DescribePackageResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(packageId(), other.packageId()) && Objects.equals(packageName(), other.packageName())
                && hasReadAccessPrincipalArns() == other.hasReadAccessPrincipalArns()
                && Objects.equals(readAccessPrincipalArns(), other.readAccessPrincipalArns())
                && Objects.equals(storageLocation(), other.storageLocation()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasWriteAccessPrincipalArns() == other.hasWriteAccessPrincipalArns()
                && Objects.equals(writeAccessPrincipalArns(), other.writeAccessPrincipalArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePackageResponse").add("Arn", arn()).add("CreatedTime", createdTime())
                .add("PackageId", packageId()).add("PackageName", packageName())
                .add("ReadAccessPrincipalArns", hasReadAccessPrincipalArns() ? readAccessPrincipalArns() : null)
                .add("StorageLocation", storageLocation()).add("Tags", hasTags() ? tags() : null)
                .add("WriteAccessPrincipalArns", hasWriteAccessPrincipalArns() ? writeAccessPrincipalArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "PackageId":
            return Optional.ofNullable(clazz.cast(packageId()));
        case "PackageName":
            return Optional.ofNullable(clazz.cast(packageName()));
        case "ReadAccessPrincipalArns":
            return Optional.ofNullable(clazz.cast(readAccessPrincipalArns()));
        case "StorageLocation":
            return Optional.ofNullable(clazz.cast(storageLocation()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "WriteAccessPrincipalArns":
            return Optional.ofNullable(clazz.cast(writeAccessPrincipalArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("PackageId", PACKAGE_ID_FIELD);
        map.put("PackageName", PACKAGE_NAME_FIELD);
        map.put("ReadAccessPrincipalArns", READ_ACCESS_PRINCIPAL_ARNS_FIELD);
        map.put("StorageLocation", STORAGE_LOCATION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("WriteAccessPrincipalArns", WRITE_ACCESS_PRINCIPAL_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribePackageResponse, T> g) {
        return obj -> g.apply((DescribePackageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribePackageResponse> {
        /**
         * <p>
         * The package's ARN.
         * </p>
         * 
         * @param arn
         *        The package's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * When the package was created.
         * </p>
         * 
         * @param createdTime
         *        When the package was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The package's ID.
         * </p>
         * 
         * @param packageId
         *        The package's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageId(String packageId);

        /**
         * <p>
         * The package's name.
         * </p>
         * 
         * @param packageName
         *        The package's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageName(String packageName);

        /**
         * <p>
         * ARNs of accounts that have read access to the package.
         * </p>
         * 
         * @param readAccessPrincipalArns
         *        ARNs of accounts that have read access to the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readAccessPrincipalArns(Collection<String> readAccessPrincipalArns);

        /**
         * <p>
         * ARNs of accounts that have read access to the package.
         * </p>
         * 
         * @param readAccessPrincipalArns
         *        ARNs of accounts that have read access to the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readAccessPrincipalArns(String... readAccessPrincipalArns);

        /**
         * <p>
         * The package's storage location.
         * </p>
         * 
         * @param storageLocation
         *        The package's storage location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageLocation(StorageLocation storageLocation);

        /**
         * <p>
         * The package's storage location.
         * </p>
         * This is a convenience method that creates an instance of the {@link StorageLocation.Builder} avoiding the
         * need to create one manually via {@link StorageLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #storageLocation(StorageLocation)}.
         * 
         * @param storageLocation
         *        a consumer that will call methods on {@link StorageLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageLocation(StorageLocation)
         */
        default Builder storageLocation(Consumer<StorageLocation.Builder> storageLocation) {
            return storageLocation(StorageLocation.builder().applyMutation(storageLocation).build());
        }

        /**
         * <p>
         * The package's tags.
         * </p>
         * 
         * @param tags
         *        The package's tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * ARNs of accounts that have write access to the package.
         * </p>
         * 
         * @param writeAccessPrincipalArns
         *        ARNs of accounts that have write access to the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeAccessPrincipalArns(Collection<String> writeAccessPrincipalArns);

        /**
         * <p>
         * ARNs of accounts that have write access to the package.
         * </p>
         * 
         * @param writeAccessPrincipalArns
         *        ARNs of accounts that have write access to the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeAccessPrincipalArns(String... writeAccessPrincipalArns);
    }

    static final class BuilderImpl extends PanoramaResponse.BuilderImpl implements Builder {
        private String arn;

        private Instant createdTime;

        private String packageId;

        private String packageName;

        private List<String> readAccessPrincipalArns = DefaultSdkAutoConstructList.getInstance();

        private StorageLocation storageLocation;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<String> writeAccessPrincipalArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePackageResponse model) {
            super(model);
            arn(model.arn);
            createdTime(model.createdTime);
            packageId(model.packageId);
            packageName(model.packageName);
            readAccessPrincipalArns(model.readAccessPrincipalArns);
            storageLocation(model.storageLocation);
            tags(model.tags);
            writeAccessPrincipalArns(model.writeAccessPrincipalArns);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getPackageId() {
            return packageId;
        }

        public final void setPackageId(String packageId) {
            this.packageId = packageId;
        }

        @Override
        public final Builder packageId(String packageId) {
            this.packageId = packageId;
            return this;
        }

        public final String getPackageName() {
            return packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final Collection<String> getReadAccessPrincipalArns() {
            if (readAccessPrincipalArns instanceof SdkAutoConstructList) {
                return null;
            }
            return readAccessPrincipalArns;
        }

        public final void setReadAccessPrincipalArns(Collection<String> readAccessPrincipalArns) {
            this.readAccessPrincipalArns = PrincipalArnsListCopier.copy(readAccessPrincipalArns);
        }

        @Override
        public final Builder readAccessPrincipalArns(Collection<String> readAccessPrincipalArns) {
            this.readAccessPrincipalArns = PrincipalArnsListCopier.copy(readAccessPrincipalArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readAccessPrincipalArns(String... readAccessPrincipalArns) {
            readAccessPrincipalArns(Arrays.asList(readAccessPrincipalArns));
            return this;
        }

        public final StorageLocation.Builder getStorageLocation() {
            return storageLocation != null ? storageLocation.toBuilder() : null;
        }

        public final void setStorageLocation(StorageLocation.BuilderImpl storageLocation) {
            this.storageLocation = storageLocation != null ? storageLocation.build() : null;
        }

        @Override
        public final Builder storageLocation(StorageLocation storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Collection<String> getWriteAccessPrincipalArns() {
            if (writeAccessPrincipalArns instanceof SdkAutoConstructList) {
                return null;
            }
            return writeAccessPrincipalArns;
        }

        public final void setWriteAccessPrincipalArns(Collection<String> writeAccessPrincipalArns) {
            this.writeAccessPrincipalArns = PrincipalArnsListCopier.copy(writeAccessPrincipalArns);
        }

        @Override
        public final Builder writeAccessPrincipalArns(Collection<String> writeAccessPrincipalArns) {
            this.writeAccessPrincipalArns = PrincipalArnsListCopier.copy(writeAccessPrincipalArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder writeAccessPrincipalArns(String... writeAccessPrincipalArns) {
            writeAccessPrincipalArns(Arrays.asList(writeAccessPrincipalArns));
            return this;
        }

        @Override
        public DescribePackageResponse build() {
            return new DescribePackageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
