/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePackageVersionRequest extends PanoramaRequest implements
        ToCopyableBuilder<DescribePackageVersionRequest.Builder, DescribePackageVersionRequest> {
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerAccount").getter(getter(DescribePackageVersionRequest::ownerAccount))
            .setter(setter(Builder::ownerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("OwnerAccount").build()).build();

    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageId").getter(getter(DescribePackageVersionRequest::packageId)).setter(setter(Builder::packageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("PackageId").build()).build();

    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageVersion").getter(getter(DescribePackageVersionRequest::packageVersion))
            .setter(setter(Builder::packageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("PackageVersion").build()).build();

    private static final SdkField<String> PATCH_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PatchVersion").getter(getter(DescribePackageVersionRequest::patchVersion))
            .setter(setter(Builder::patchVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("PatchVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ACCOUNT_FIELD,
            PACKAGE_ID_FIELD, PACKAGE_VERSION_FIELD, PATCH_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String ownerAccount;

    private final String packageId;

    private final String packageVersion;

    private final String patchVersion;

    private DescribePackageVersionRequest(BuilderImpl builder) {
        super(builder);
        this.ownerAccount = builder.ownerAccount;
        this.packageId = builder.packageId;
        this.packageVersion = builder.packageVersion;
        this.patchVersion = builder.patchVersion;
    }

    /**
     * <p>
     * The version's owner account.
     * </p>
     * 
     * @return The version's owner account.
     */
    public final String ownerAccount() {
        return ownerAccount;
    }

    /**
     * <p>
     * The version's ID.
     * </p>
     * 
     * @return The version's ID.
     */
    public final String packageId() {
        return packageId;
    }

    /**
     * <p>
     * The version's version.
     * </p>
     * 
     * @return The version's version.
     */
    public final String packageVersion() {
        return packageVersion;
    }

    /**
     * <p>
     * The version's patch version.
     * </p>
     * 
     * @return The version's patch version.
     */
    public final String patchVersion() {
        return patchVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(packageId());
        hashCode = 31 * hashCode + Objects.hashCode(packageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(patchVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePackageVersionRequest)) {
            return false;
        }
        DescribePackageVersionRequest other = (DescribePackageVersionRequest) obj;
        return Objects.equals(ownerAccount(), other.ownerAccount()) && Objects.equals(packageId(), other.packageId())
                && Objects.equals(packageVersion(), other.packageVersion())
                && Objects.equals(patchVersion(), other.patchVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePackageVersionRequest").add("OwnerAccount", ownerAccount())
                .add("PackageId", packageId()).add("PackageVersion", packageVersion()).add("PatchVersion", patchVersion())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OwnerAccount":
            return Optional.ofNullable(clazz.cast(ownerAccount()));
        case "PackageId":
            return Optional.ofNullable(clazz.cast(packageId()));
        case "PackageVersion":
            return Optional.ofNullable(clazz.cast(packageVersion()));
        case "PatchVersion":
            return Optional.ofNullable(clazz.cast(patchVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OwnerAccount", OWNER_ACCOUNT_FIELD);
        map.put("PackageId", PACKAGE_ID_FIELD);
        map.put("PackageVersion", PACKAGE_VERSION_FIELD);
        map.put("PatchVersion", PATCH_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribePackageVersionRequest, T> g) {
        return obj -> g.apply((DescribePackageVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribePackageVersionRequest> {
        /**
         * <p>
         * The version's owner account.
         * </p>
         * 
         * @param ownerAccount
         *        The version's owner account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccount(String ownerAccount);

        /**
         * <p>
         * The version's ID.
         * </p>
         * 
         * @param packageId
         *        The version's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageId(String packageId);

        /**
         * <p>
         * The version's version.
         * </p>
         * 
         * @param packageVersion
         *        The version's version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageVersion(String packageVersion);

        /**
         * <p>
         * The version's patch version.
         * </p>
         * 
         * @param patchVersion
         *        The version's patch version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchVersion(String patchVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PanoramaRequest.BuilderImpl implements Builder {
        private String ownerAccount;

        private String packageId;

        private String packageVersion;

        private String patchVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePackageVersionRequest model) {
            super(model);
            ownerAccount(model.ownerAccount);
            packageId(model.packageId);
            packageVersion(model.packageVersion);
            patchVersion(model.patchVersion);
        }

        public final String getOwnerAccount() {
            return ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final String getPackageId() {
            return packageId;
        }

        public final void setPackageId(String packageId) {
            this.packageId = packageId;
        }

        @Override
        public final Builder packageId(String packageId) {
            this.packageId = packageId;
            return this;
        }

        public final String getPackageVersion() {
            return packageVersion;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        @Override
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final String getPatchVersion() {
            return patchVersion;
        }

        public final void setPatchVersion(String patchVersion) {
            this.patchVersion = patchVersion;
        }

        @Override
        public final Builder patchVersion(String patchVersion) {
            this.patchVersion = patchVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribePackageVersionRequest build() {
            return new DescribePackageVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
