/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListApplicationInstancesRequest extends PanoramaRequest implements
        ToCopyableBuilder<ListApplicationInstancesRequest.Builder, ListApplicationInstancesRequest> {
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceId").getter(getter(ListApplicationInstancesRequest::deviceId)).setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("deviceId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListApplicationInstancesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListApplicationInstancesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> STATUS_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusFilter").getter(getter(ListApplicationInstancesRequest::statusFilterAsString))
            .setter(setter(Builder::statusFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("statusFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ID_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, STATUS_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String deviceId;

    private final Integer maxResults;

    private final String nextToken;

    private final String statusFilter;

    private ListApplicationInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.deviceId = builder.deviceId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.statusFilter = builder.statusFilter;
    }

    /**
     * <p>
     * The application instances' device ID.
     * </p>
     * 
     * @return The application instances' device ID.
     */
    public final String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The maximum number of application instances to return in one page of results.
     * </p>
     * 
     * @return The maximum number of application instances to return in one page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Specify the pagination token from a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specify the pagination token from a previous request to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Only include instances with a specific status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusFilter} will
     * return {@link StatusFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusFilterAsString}.
     * </p>
     * 
     * @return Only include instances with a specific status.
     * @see StatusFilter
     */
    public final StatusFilter statusFilter() {
        return StatusFilter.fromValue(statusFilter);
    }

    /**
     * <p>
     * Only include instances with a specific status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusFilter} will
     * return {@link StatusFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusFilterAsString}.
     * </p>
     * 
     * @return Only include instances with a specific status.
     * @see StatusFilter
     */
    public final String statusFilterAsString() {
        return statusFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(statusFilterAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationInstancesRequest)) {
            return false;
        }
        ListApplicationInstancesRequest other = (ListApplicationInstancesRequest) obj;
        return Objects.equals(deviceId(), other.deviceId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(statusFilterAsString(), other.statusFilterAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListApplicationInstancesRequest").add("DeviceId", deviceId()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("StatusFilter", statusFilterAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "StatusFilter":
            return Optional.ofNullable(clazz.cast(statusFilterAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("deviceId", DEVICE_ID_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("statusFilter", STATUS_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationInstancesRequest, T> g) {
        return obj -> g.apply((ListApplicationInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListApplicationInstancesRequest> {
        /**
         * <p>
         * The application instances' device ID.
         * </p>
         * 
         * @param deviceId
         *        The application instances' device ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The maximum number of application instances to return in one page of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of application instances to return in one page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Specify the pagination token from a previous request to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specify the pagination token from a previous request to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Only include instances with a specific status.
         * </p>
         * 
         * @param statusFilter
         *        Only include instances with a specific status.
         * @see StatusFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusFilter
         */
        Builder statusFilter(String statusFilter);

        /**
         * <p>
         * Only include instances with a specific status.
         * </p>
         * 
         * @param statusFilter
         *        Only include instances with a specific status.
         * @see StatusFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusFilter
         */
        Builder statusFilter(StatusFilter statusFilter);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PanoramaRequest.BuilderImpl implements Builder {
        private String deviceId;

        private Integer maxResults;

        private String nextToken;

        private String statusFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationInstancesRequest model) {
            super(model);
            deviceId(model.deviceId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            statusFilter(model.statusFilter);
        }

        public final String getDeviceId() {
            return deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getStatusFilter() {
            return statusFilter;
        }

        public final void setStatusFilter(String statusFilter) {
            this.statusFilter = statusFilter;
        }

        @Override
        public final Builder statusFilter(String statusFilter) {
            this.statusFilter = statusFilter;
            return this;
        }

        @Override
        public final Builder statusFilter(StatusFilter statusFilter) {
            this.statusFilter(statusFilter == null ? null : statusFilter.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListApplicationInstancesRequest build() {
            return new ListApplicationInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
