/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionDeviceResponse extends PanoramaResponse implements
        ToCopyableBuilder<ProvisionDeviceResponse.Builder, ProvisionDeviceResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ProvisionDeviceResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<SdkBytes> CERTIFICATES_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("Certificates").getter(getter(ProvisionDeviceResponse::certificates))
            .setter(setter(Builder::certificates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificates").build()).build();

    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceId").getter(getter(ProvisionDeviceResponse::deviceId)).setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()).build();

    private static final SdkField<String> IOT_THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IotThingName").getter(getter(ProvisionDeviceResponse::iotThingName))
            .setter(setter(Builder::iotThingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IotThingName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ProvisionDeviceResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CERTIFICATES_FIELD,
            DEVICE_ID_FIELD, IOT_THING_NAME_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final SdkBytes certificates;

    private final String deviceId;

    private final String iotThingName;

    private final String status;

    private ProvisionDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.certificates = builder.certificates;
        this.deviceId = builder.deviceId;
        this.iotThingName = builder.iotThingName;
        this.status = builder.status;
    }

    /**
     * <p>
     * The device's ARN.
     * </p>
     * 
     * @return The device's ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The device's configuration bundle.
     * </p>
     * 
     * @return The device's configuration bundle.
     */
    public final SdkBytes certificates() {
        return certificates;
    }

    /**
     * <p>
     * The device's ID.
     * </p>
     * 
     * @return The device's ID.
     */
    public final String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The device's IoT thing name.
     * </p>
     * 
     * @return The device's IoT thing name.
     */
    public final String iotThingName() {
        return iotThingName;
    }

    /**
     * <p>
     * The device's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The device's status.
     * @see DeviceStatus
     */
    public final DeviceStatus status() {
        return DeviceStatus.fromValue(status);
    }

    /**
     * <p>
     * The device's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The device's status.
     * @see DeviceStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(certificates());
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(iotThingName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionDeviceResponse)) {
            return false;
        }
        ProvisionDeviceResponse other = (ProvisionDeviceResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(certificates(), other.certificates())
                && Objects.equals(deviceId(), other.deviceId()) && Objects.equals(iotThingName(), other.iotThingName())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisionDeviceResponse").add("Arn", arn()).add("Certificates", certificates())
                .add("DeviceId", deviceId()).add("IotThingName", iotThingName()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Certificates":
            return Optional.ofNullable(clazz.cast(certificates()));
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "IotThingName":
            return Optional.ofNullable(clazz.cast(iotThingName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Certificates", CERTIFICATES_FIELD);
        map.put("DeviceId", DEVICE_ID_FIELD);
        map.put("IotThingName", IOT_THING_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisionDeviceResponse, T> g) {
        return obj -> g.apply((ProvisionDeviceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ProvisionDeviceResponse> {
        /**
         * <p>
         * The device's ARN.
         * </p>
         * 
         * @param arn
         *        The device's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The device's configuration bundle.
         * </p>
         * 
         * @param certificates
         *        The device's configuration bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificates(SdkBytes certificates);

        /**
         * <p>
         * The device's ID.
         * </p>
         * 
         * @param deviceId
         *        The device's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The device's IoT thing name.
         * </p>
         * 
         * @param iotThingName
         *        The device's IoT thing name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotThingName(String iotThingName);

        /**
         * <p>
         * The device's status.
         * </p>
         * 
         * @param status
         *        The device's status.
         * @see DeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The device's status.
         * </p>
         * 
         * @param status
         *        The device's status.
         * @see DeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatus
         */
        Builder status(DeviceStatus status);
    }

    static final class BuilderImpl extends PanoramaResponse.BuilderImpl implements Builder {
        private String arn;

        private SdkBytes certificates;

        private String deviceId;

        private String iotThingName;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionDeviceResponse model) {
            super(model);
            arn(model.arn);
            certificates(model.certificates);
            deviceId(model.deviceId);
            iotThingName(model.iotThingName);
            status(model.status);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final ByteBuffer getCertificates() {
            return certificates == null ? null : certificates.asByteBuffer();
        }

        public final void setCertificates(ByteBuffer certificates) {
            certificates(certificates == null ? null : SdkBytes.fromByteBuffer(certificates));
        }

        @Override
        public final Builder certificates(SdkBytes certificates) {
            this.certificates = certificates;
            return this;
        }

        public final String getDeviceId() {
            return deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getIotThingName() {
            return iotThingName;
        }

        public final void setIotThingName(String iotThingName) {
            this.iotThingName = iotThingName;
        }

        @Override
        public final Builder iotThingName(String iotThingName) {
            this.iotThingName = iotThingName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeviceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ProvisionDeviceResponse build() {
            return new ProvisionDeviceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
