/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A storage location.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StorageLocation implements SdkPojo, Serializable, ToCopyableBuilder<StorageLocation.Builder, StorageLocation> {
    private static final SdkField<String> BINARY_PREFIX_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BinaryPrefixLocation").getter(getter(StorageLocation::binaryPrefixLocation))
            .setter(setter(Builder::binaryPrefixLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BinaryPrefixLocation").build())
            .build();

    private static final SdkField<String> BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Bucket")
            .getter(getter(StorageLocation::bucket)).setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").build()).build();

    private static final SdkField<String> GENERATED_PREFIX_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeneratedPrefixLocation").getter(getter(StorageLocation::generatedPrefixLocation))
            .setter(setter(Builder::generatedPrefixLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedPrefixLocation").build())
            .build();

    private static final SdkField<String> MANIFEST_PREFIX_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestPrefixLocation").getter(getter(StorageLocation::manifestPrefixLocation))
            .setter(setter(Builder::manifestPrefixLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestPrefixLocation").build())
            .build();

    private static final SdkField<String> REPO_PREFIX_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepoPrefixLocation").getter(getter(StorageLocation::repoPrefixLocation))
            .setter(setter(Builder::repoPrefixLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepoPrefixLocation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BINARY_PREFIX_LOCATION_FIELD,
            BUCKET_FIELD, GENERATED_PREFIX_LOCATION_FIELD, MANIFEST_PREFIX_LOCATION_FIELD, REPO_PREFIX_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String binaryPrefixLocation;

    private final String bucket;

    private final String generatedPrefixLocation;

    private final String manifestPrefixLocation;

    private final String repoPrefixLocation;

    private StorageLocation(BuilderImpl builder) {
        this.binaryPrefixLocation = builder.binaryPrefixLocation;
        this.bucket = builder.bucket;
        this.generatedPrefixLocation = builder.generatedPrefixLocation;
        this.manifestPrefixLocation = builder.manifestPrefixLocation;
        this.repoPrefixLocation = builder.repoPrefixLocation;
    }

    /**
     * <p>
     * The location's binary prefix.
     * </p>
     * 
     * @return The location's binary prefix.
     */
    public final String binaryPrefixLocation() {
        return binaryPrefixLocation;
    }

    /**
     * <p>
     * The location's bucket.
     * </p>
     * 
     * @return The location's bucket.
     */
    public final String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The location's generated prefix.
     * </p>
     * 
     * @return The location's generated prefix.
     */
    public final String generatedPrefixLocation() {
        return generatedPrefixLocation;
    }

    /**
     * <p>
     * The location's manifest prefix.
     * </p>
     * 
     * @return The location's manifest prefix.
     */
    public final String manifestPrefixLocation() {
        return manifestPrefixLocation;
    }

    /**
     * <p>
     * The location's repo prefix.
     * </p>
     * 
     * @return The location's repo prefix.
     */
    public final String repoPrefixLocation() {
        return repoPrefixLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(binaryPrefixLocation());
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(generatedPrefixLocation());
        hashCode = 31 * hashCode + Objects.hashCode(manifestPrefixLocation());
        hashCode = 31 * hashCode + Objects.hashCode(repoPrefixLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageLocation)) {
            return false;
        }
        StorageLocation other = (StorageLocation) obj;
        return Objects.equals(binaryPrefixLocation(), other.binaryPrefixLocation()) && Objects.equals(bucket(), other.bucket())
                && Objects.equals(generatedPrefixLocation(), other.generatedPrefixLocation())
                && Objects.equals(manifestPrefixLocation(), other.manifestPrefixLocation())
                && Objects.equals(repoPrefixLocation(), other.repoPrefixLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StorageLocation").add("BinaryPrefixLocation", binaryPrefixLocation()).add("Bucket", bucket())
                .add("GeneratedPrefixLocation", generatedPrefixLocation())
                .add("ManifestPrefixLocation", manifestPrefixLocation()).add("RepoPrefixLocation", repoPrefixLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BinaryPrefixLocation":
            return Optional.ofNullable(clazz.cast(binaryPrefixLocation()));
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "GeneratedPrefixLocation":
            return Optional.ofNullable(clazz.cast(generatedPrefixLocation()));
        case "ManifestPrefixLocation":
            return Optional.ofNullable(clazz.cast(manifestPrefixLocation()));
        case "RepoPrefixLocation":
            return Optional.ofNullable(clazz.cast(repoPrefixLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BinaryPrefixLocation", BINARY_PREFIX_LOCATION_FIELD);
        map.put("Bucket", BUCKET_FIELD);
        map.put("GeneratedPrefixLocation", GENERATED_PREFIX_LOCATION_FIELD);
        map.put("ManifestPrefixLocation", MANIFEST_PREFIX_LOCATION_FIELD);
        map.put("RepoPrefixLocation", REPO_PREFIX_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StorageLocation, T> g) {
        return obj -> g.apply((StorageLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StorageLocation> {
        /**
         * <p>
         * The location's binary prefix.
         * </p>
         * 
         * @param binaryPrefixLocation
         *        The location's binary prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder binaryPrefixLocation(String binaryPrefixLocation);

        /**
         * <p>
         * The location's bucket.
         * </p>
         * 
         * @param bucket
         *        The location's bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The location's generated prefix.
         * </p>
         * 
         * @param generatedPrefixLocation
         *        The location's generated prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedPrefixLocation(String generatedPrefixLocation);

        /**
         * <p>
         * The location's manifest prefix.
         * </p>
         * 
         * @param manifestPrefixLocation
         *        The location's manifest prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestPrefixLocation(String manifestPrefixLocation);

        /**
         * <p>
         * The location's repo prefix.
         * </p>
         * 
         * @param repoPrefixLocation
         *        The location's repo prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repoPrefixLocation(String repoPrefixLocation);
    }

    static final class BuilderImpl implements Builder {
        private String binaryPrefixLocation;

        private String bucket;

        private String generatedPrefixLocation;

        private String manifestPrefixLocation;

        private String repoPrefixLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageLocation model) {
            binaryPrefixLocation(model.binaryPrefixLocation);
            bucket(model.bucket);
            generatedPrefixLocation(model.generatedPrefixLocation);
            manifestPrefixLocation(model.manifestPrefixLocation);
            repoPrefixLocation(model.repoPrefixLocation);
        }

        public final String getBinaryPrefixLocation() {
            return binaryPrefixLocation;
        }

        public final void setBinaryPrefixLocation(String binaryPrefixLocation) {
            this.binaryPrefixLocation = binaryPrefixLocation;
        }

        @Override
        public final Builder binaryPrefixLocation(String binaryPrefixLocation) {
            this.binaryPrefixLocation = binaryPrefixLocation;
            return this;
        }

        public final String getBucket() {
            return bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getGeneratedPrefixLocation() {
            return generatedPrefixLocation;
        }

        public final void setGeneratedPrefixLocation(String generatedPrefixLocation) {
            this.generatedPrefixLocation = generatedPrefixLocation;
        }

        @Override
        public final Builder generatedPrefixLocation(String generatedPrefixLocation) {
            this.generatedPrefixLocation = generatedPrefixLocation;
            return this;
        }

        public final String getManifestPrefixLocation() {
            return manifestPrefixLocation;
        }

        public final void setManifestPrefixLocation(String manifestPrefixLocation) {
            this.manifestPrefixLocation = manifestPrefixLocation;
        }

        @Override
        public final Builder manifestPrefixLocation(String manifestPrefixLocation) {
            this.manifestPrefixLocation = manifestPrefixLocation;
            return this;
        }

        public final String getRepoPrefixLocation() {
            return repoPrefixLocation;
        }

        public final void setRepoPrefixLocation(String repoPrefixLocation) {
            this.repoPrefixLocation = repoPrefixLocation;
        }

        @Override
        public final Builder repoPrefixLocation(String repoPrefixLocation) {
            this.repoPrefixLocation = repoPrefixLocation;
            return this;
        }

        @Override
        public StorageLocation build() {
            return new StorageLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
