/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.panorama.PanoramaClient;
import software.amazon.awssdk.services.panorama.internal.UserAgentUtils;
import software.amazon.awssdk.services.panorama.model.ListPackagesRequest;
import software.amazon.awssdk.services.panorama.model.ListPackagesResponse;

public class ListPackagesIterable
implements SdkIterable<ListPackagesResponse> {
    private final PanoramaClient client;
    private final ListPackagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPackagesIterable(PanoramaClient client, ListPackagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPackagesResponseFetcher();
    }

    public Iterator<ListPackagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPackagesResponseFetcher
    implements SyncPageFetcher<ListPackagesResponse> {
        private ListPackagesResponseFetcher() {
        }

        public boolean hasNextPage(ListPackagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPackagesResponse nextPage(ListPackagesResponse previousPage) {
            if (previousPage == null) {
                return ListPackagesIterable.this.client.listPackages(ListPackagesIterable.this.firstRequest);
            }
            return ListPackagesIterable.this.client.listPackages((ListPackagesRequest)((Object)ListPackagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

