/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.panorama.model.NodeSignalValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeSignal
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeSignal> {
    private static final SdkField<String> NODE_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeInstanceId").getter(NodeSignal.getter(NodeSignal::nodeInstanceId)).setter(NodeSignal.setter(Builder::nodeInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeInstanceId").build()}).build();
    private static final SdkField<String> SIGNAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Signal").getter(NodeSignal.getter(NodeSignal::signalAsString)).setter(NodeSignal.setter(Builder::signal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Signal").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_INSTANCE_ID_FIELD, SIGNAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NodeSignal.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String nodeInstanceId;
    private final String signal;

    private NodeSignal(BuilderImpl builder) {
        this.nodeInstanceId = builder.nodeInstanceId;
        this.signal = builder.signal;
    }

    public final String nodeInstanceId() {
        return this.nodeInstanceId;
    }

    public final NodeSignalValue signal() {
        return NodeSignalValue.fromValue(this.signal);
    }

    public final String signalAsString() {
        return this.signal;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.signalAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeSignal)) {
            return false;
        }
        NodeSignal other = (NodeSignal)obj;
        return Objects.equals(this.nodeInstanceId(), other.nodeInstanceId()) && Objects.equals(this.signalAsString(), other.signalAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NodeSignal").add("NodeInstanceId", (Object)this.nodeInstanceId()).add("Signal", (Object)this.signalAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NodeInstanceId": {
                return Optional.ofNullable(clazz.cast(this.nodeInstanceId()));
            }
            case "Signal": {
                return Optional.ofNullable(clazz.cast(this.signalAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("NodeInstanceId", NODE_INSTANCE_ID_FIELD);
        map.put("Signal", SIGNAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeSignal, T> g) {
        return obj -> g.apply((NodeSignal)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String nodeInstanceId;
        private String signal;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeSignal model) {
            this.nodeInstanceId(model.nodeInstanceId);
            this.signal(model.signal);
        }

        public final String getNodeInstanceId() {
            return this.nodeInstanceId;
        }

        public final void setNodeInstanceId(String nodeInstanceId) {
            this.nodeInstanceId = nodeInstanceId;
        }

        @Override
        public final Builder nodeInstanceId(String nodeInstanceId) {
            this.nodeInstanceId = nodeInstanceId;
            return this;
        }

        public final String getSignal() {
            return this.signal;
        }

        public final void setSignal(String signal) {
            this.signal = signal;
        }

        @Override
        public final Builder signal(String signal) {
            this.signal = signal;
            return this;
        }

        @Override
        public final Builder signal(NodeSignalValue signal) {
            this.signal(signal == null ? null : signal.toString());
            return this;
        }

        public NodeSignal build() {
            return new NodeSignal(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeSignal> {
        public Builder nodeInstanceId(String var1);

        public Builder signal(String var1);

        public Builder signal(NodeSignalValue var1);
    }
}

