/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus;
import software.amazon.awssdk.services.panorama.model.ListDevicesSortBy;
import software.amazon.awssdk.services.panorama.model.PanoramaRequest;
import software.amazon.awssdk.services.panorama.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDevicesRequest
extends PanoramaRequest
implements ToCopyableBuilder<Builder, ListDevicesRequest> {
    private static final SdkField<String> DEVICE_AGGREGATED_STATUS_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceAggregatedStatusFilter").getter(ListDevicesRequest.getter(ListDevicesRequest::deviceAggregatedStatusFilterAsString)).setter(ListDevicesRequest.setter(Builder::deviceAggregatedStatusFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("DeviceAggregatedStatusFilter").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListDevicesRequest.getter(ListDevicesRequest::maxResults)).setter(ListDevicesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NAME_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NameFilter").getter(ListDevicesRequest.getter(ListDevicesRequest::nameFilter)).setter(ListDevicesRequest.setter(Builder::nameFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NameFilter").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDevicesRequest.getter(ListDevicesRequest::nextToken)).setter(ListDevicesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortBy").getter(ListDevicesRequest.getter(ListDevicesRequest::sortByAsString)).setter(ListDevicesRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("SortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortOrder").getter(ListDevicesRequest.getter(ListDevicesRequest::sortOrderAsString)).setter(ListDevicesRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("SortOrder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_AGGREGATED_STATUS_FILTER_FIELD, MAX_RESULTS_FIELD, NAME_FILTER_FIELD, NEXT_TOKEN_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDevicesRequest.memberNameToFieldInitializer();
    private final String deviceAggregatedStatusFilter;
    private final Integer maxResults;
    private final String nameFilter;
    private final String nextToken;
    private final String sortBy;
    private final String sortOrder;

    private ListDevicesRequest(BuilderImpl builder) {
        super(builder);
        this.deviceAggregatedStatusFilter = builder.deviceAggregatedStatusFilter;
        this.maxResults = builder.maxResults;
        this.nameFilter = builder.nameFilter;
        this.nextToken = builder.nextToken;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    public final DeviceAggregatedStatus deviceAggregatedStatusFilter() {
        return DeviceAggregatedStatus.fromValue(this.deviceAggregatedStatusFilter);
    }

    public final String deviceAggregatedStatusFilterAsString() {
        return this.deviceAggregatedStatusFilter;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nameFilter() {
        return this.nameFilter;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final ListDevicesSortBy sortBy() {
        return ListDevicesSortBy.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceAggregatedStatusFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevicesRequest)) {
            return false;
        }
        ListDevicesRequest other = (ListDevicesRequest)((Object)obj);
        return Objects.equals(this.deviceAggregatedStatusFilterAsString(), other.deviceAggregatedStatusFilterAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nameFilter(), other.nameFilter()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListDevicesRequest").add("DeviceAggregatedStatusFilter", (Object)this.deviceAggregatedStatusFilterAsString()).add("MaxResults", (Object)this.maxResults()).add("NameFilter", (Object)this.nameFilter()).add("NextToken", (Object)this.nextToken()).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceAggregatedStatusFilter": {
                return Optional.ofNullable(clazz.cast(this.deviceAggregatedStatusFilterAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NameFilter": {
                return Optional.ofNullable(clazz.cast(this.nameFilter()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "SortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DeviceAggregatedStatusFilter", DEVICE_AGGREGATED_STATUS_FILTER_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NameFilter", NAME_FILTER_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("SortBy", SORT_BY_FIELD);
        map.put("SortOrder", SORT_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDevicesRequest, T> g) {
        return obj -> g.apply((ListDevicesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaRequest.BuilderImpl
    implements Builder {
        private String deviceAggregatedStatusFilter;
        private Integer maxResults;
        private String nameFilter;
        private String nextToken;
        private String sortBy;
        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDevicesRequest model) {
            super(model);
            this.deviceAggregatedStatusFilter(model.deviceAggregatedStatusFilter);
            this.maxResults(model.maxResults);
            this.nameFilter(model.nameFilter);
            this.nextToken(model.nextToken);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
        }

        public final String getDeviceAggregatedStatusFilter() {
            return this.deviceAggregatedStatusFilter;
        }

        public final void setDeviceAggregatedStatusFilter(String deviceAggregatedStatusFilter) {
            this.deviceAggregatedStatusFilter = deviceAggregatedStatusFilter;
        }

        @Override
        public final Builder deviceAggregatedStatusFilter(String deviceAggregatedStatusFilter) {
            this.deviceAggregatedStatusFilter = deviceAggregatedStatusFilter;
            return this;
        }

        @Override
        public final Builder deviceAggregatedStatusFilter(DeviceAggregatedStatus deviceAggregatedStatusFilter) {
            this.deviceAggregatedStatusFilter(deviceAggregatedStatusFilter == null ? null : deviceAggregatedStatusFilter.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNameFilter() {
            return this.nameFilter;
        }

        public final void setNameFilter(String nameFilter) {
            this.nameFilter = nameFilter;
        }

        @Override
        public final Builder nameFilter(String nameFilter) {
            this.nameFilter = nameFilter;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ListDevicesSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDevicesRequest build() {
            return new ListDevicesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PanoramaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDevicesRequest> {
        public Builder deviceAggregatedStatusFilter(String var1);

        public Builder deviceAggregatedStatusFilter(DeviceAggregatedStatus var1);

        public Builder maxResults(Integer var1);

        public Builder nameFilter(String var1);

        public Builder nextToken(String var1);

        public Builder sortBy(String var1);

        public Builder sortBy(ListDevicesSortBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

