/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StatusFilter {
    DEPLOYMENT_SUCCEEDED("DEPLOYMENT_SUCCEEDED"),
    DEPLOYMENT_ERROR("DEPLOYMENT_ERROR"),
    REMOVAL_SUCCEEDED("REMOVAL_SUCCEEDED"),
    REMOVAL_FAILED("REMOVAL_FAILED"),
    PROCESSING_DEPLOYMENT("PROCESSING_DEPLOYMENT"),
    PROCESSING_REMOVAL("PROCESSING_REMOVAL"),
    DEPLOYMENT_FAILED("DEPLOYMENT_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StatusFilter> VALUE_MAP;
    private final String value;

    private StatusFilter(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StatusFilter fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StatusFilter> knownValues() {
        EnumSet<StatusFilter> knownValues = EnumSet.allOf(StatusFilter.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StatusFilter.class, StatusFilter::toString);
    }
}

