/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.panorama.model.DeviceJob;
import software.amazon.awssdk.services.panorama.model.DeviceJobListCopier;
import software.amazon.awssdk.services.panorama.model.PanoramaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDevicesJobsResponse
extends PanoramaResponse
implements ToCopyableBuilder<Builder, ListDevicesJobsResponse> {
    private static final SdkField<List<DeviceJob>> DEVICE_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeviceJobs").getter(ListDevicesJobsResponse.getter(ListDevicesJobsResponse::deviceJobs)).setter(ListDevicesJobsResponse.setter(Builder::deviceJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeviceJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDevicesJobsResponse.getter(ListDevicesJobsResponse::nextToken)).setter(ListDevicesJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_JOBS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDevicesJobsResponse.memberNameToFieldInitializer();
    private final List<DeviceJob> deviceJobs;
    private final String nextToken;

    private ListDevicesJobsResponse(BuilderImpl builder) {
        super(builder);
        this.deviceJobs = builder.deviceJobs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDeviceJobs() {
        return this.deviceJobs != null && !(this.deviceJobs instanceof SdkAutoConstructList);
    }

    public final List<DeviceJob> deviceJobs() {
        return this.deviceJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeviceJobs() ? this.deviceJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevicesJobsResponse)) {
            return false;
        }
        ListDevicesJobsResponse other = (ListDevicesJobsResponse)((Object)obj);
        return this.hasDeviceJobs() == other.hasDeviceJobs() && Objects.equals(this.deviceJobs(), other.deviceJobs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDevicesJobsResponse").add("DeviceJobs", this.hasDeviceJobs() ? this.deviceJobs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceJobs": {
                return Optional.ofNullable(clazz.cast(this.deviceJobs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DeviceJobs", DEVICE_JOBS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDevicesJobsResponse, T> g) {
        return obj -> g.apply((ListDevicesJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaResponse.BuilderImpl
    implements Builder {
        private List<DeviceJob> deviceJobs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDevicesJobsResponse model) {
            super(model);
            this.deviceJobs(model.deviceJobs);
            this.nextToken(model.nextToken);
        }

        public final List<DeviceJob.Builder> getDeviceJobs() {
            List<DeviceJob.Builder> result = DeviceJobListCopier.copyToBuilder(this.deviceJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeviceJobs(Collection<DeviceJob.BuilderImpl> deviceJobs) {
            this.deviceJobs = DeviceJobListCopier.copyFromBuilder(deviceJobs);
        }

        @Override
        public final Builder deviceJobs(Collection<DeviceJob> deviceJobs) {
            this.deviceJobs = DeviceJobListCopier.copy(deviceJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceJobs(DeviceJob ... deviceJobs) {
            this.deviceJobs(Arrays.asList(deviceJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceJobs(Consumer<DeviceJob.Builder> ... deviceJobs) {
            this.deviceJobs(Stream.of(deviceJobs).map(c -> (DeviceJob)((DeviceJob.Builder)DeviceJob.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDevicesJobsResponse build() {
            return new ListDevicesJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PanoramaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDevicesJobsResponse> {
        public Builder deviceJobs(Collection<DeviceJob> var1);

        public Builder deviceJobs(DeviceJob ... var1);

        public Builder deviceJobs(Consumer<DeviceJob.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

