/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralselling.model.ExpectedCustomerSpendCurrencyCodeEnum;
import software.amazon.awssdk.services.partnercentralselling.model.PaymentFrequency;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExpectedCustomerSpend
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExpectedCustomerSpend> {
    private static final SdkField<String> AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Amount").getter(ExpectedCustomerSpend.getter(ExpectedCustomerSpend::amount)).setter(ExpectedCustomerSpend.setter(Builder::amount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amount").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(ExpectedCustomerSpend.getter(ExpectedCustomerSpend::currencyCodeAsString)).setter(ExpectedCustomerSpend.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()}).build();
    private static final SdkField<String> FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Frequency").getter(ExpectedCustomerSpend.getter(ExpectedCustomerSpend::frequencyAsString)).setter(ExpectedCustomerSpend.setter(Builder::frequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frequency").build()}).build();
    private static final SdkField<String> TARGET_COMPANY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetCompany").getter(ExpectedCustomerSpend.getter(ExpectedCustomerSpend::targetCompany)).setter(ExpectedCustomerSpend.setter(Builder::targetCompany)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCompany").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMOUNT_FIELD, CURRENCY_CODE_FIELD, FREQUENCY_FIELD, TARGET_COMPANY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Amount", AMOUNT_FIELD);
            this.put("CurrencyCode", CURRENCY_CODE_FIELD);
            this.put("Frequency", FREQUENCY_FIELD);
            this.put("TargetCompany", TARGET_COMPANY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String amount;
    private final String currencyCode;
    private final String frequency;
    private final String targetCompany;

    private ExpectedCustomerSpend(BuilderImpl builder) {
        this.amount = builder.amount;
        this.currencyCode = builder.currencyCode;
        this.frequency = builder.frequency;
        this.targetCompany = builder.targetCompany;
    }

    public final String amount() {
        return this.amount;
    }

    public final ExpectedCustomerSpendCurrencyCodeEnum currencyCode() {
        return ExpectedCustomerSpendCurrencyCodeEnum.fromValue(this.currencyCode);
    }

    public final String currencyCodeAsString() {
        return this.currencyCode;
    }

    public final PaymentFrequency frequency() {
        return PaymentFrequency.fromValue(this.frequency);
    }

    public final String frequencyAsString() {
        return this.frequency;
    }

    public final String targetCompany() {
        return this.targetCompany;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amount());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.frequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCompany());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpectedCustomerSpend)) {
            return false;
        }
        ExpectedCustomerSpend other = (ExpectedCustomerSpend)obj;
        return Objects.equals(this.amount(), other.amount()) && Objects.equals(this.currencyCodeAsString(), other.currencyCodeAsString()) && Objects.equals(this.frequencyAsString(), other.frequencyAsString()) && Objects.equals(this.targetCompany(), other.targetCompany());
    }

    public final String toString() {
        return ToString.builder((String)"ExpectedCustomerSpend").add("Amount", (Object)this.amount()).add("CurrencyCode", (Object)(this.currencyCodeAsString() == null ? null : "*** Sensitive Data Redacted ***")).add("Frequency", (Object)this.frequencyAsString()).add("TargetCompany", (Object)this.targetCompany()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Amount": {
                return Optional.ofNullable(clazz.cast(this.amount()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCodeAsString()));
            }
            case "Frequency": {
                return Optional.ofNullable(clazz.cast(this.frequencyAsString()));
            }
            case "TargetCompany": {
                return Optional.ofNullable(clazz.cast(this.targetCompany()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ExpectedCustomerSpend, T> g) {
        return obj -> g.apply((ExpectedCustomerSpend)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String amount;
        private String currencyCode;
        private String frequency;
        private String targetCompany;

        private BuilderImpl() {
        }

        private BuilderImpl(ExpectedCustomerSpend model) {
            this.amount(model.amount);
            this.currencyCode(model.currencyCode);
            this.frequency(model.frequency);
            this.targetCompany(model.targetCompany);
        }

        public final String getAmount() {
            return this.amount;
        }

        public final void setAmount(String amount) {
            this.amount = amount;
        }

        @Override
        public final Builder amount(String amount) {
            this.amount = amount;
            return this;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(ExpectedCustomerSpendCurrencyCodeEnum currencyCode) {
            this.currencyCode(currencyCode == null ? null : currencyCode.toString());
            return this;
        }

        public final String getFrequency() {
            return this.frequency;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(PaymentFrequency frequency) {
            this.frequency(frequency == null ? null : frequency.toString());
            return this;
        }

        public final String getTargetCompany() {
            return this.targetCompany;
        }

        public final void setTargetCompany(String targetCompany) {
            this.targetCompany = targetCompany;
        }

        @Override
        public final Builder targetCompany(String targetCompany) {
            this.targetCompany = targetCompany;
            return this;
        }

        public ExpectedCustomerSpend build() {
            return new ExpectedCustomerSpend(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExpectedCustomerSpend> {
        public Builder amount(String var1);

        public Builder currencyCode(String var1);

        public Builder currencyCode(ExpectedCustomerSpendCurrencyCodeEnum var1);

        public Builder frequency(String var1);

        public Builder frequency(PaymentFrequency var1);

        public Builder targetCompany(String var1);
    }
}

