/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ClosedLostReason {
    CUSTOMER_DEFICIENCY("Customer Deficiency"),
    DELAY_CANCELLATION_OF_PROJECT("Delay / Cancellation of Project"),
    LEGAL_TAX_REGULATORY("Legal / Tax / Regulatory"),
    LOST_TO_COMPETITOR_GOOGLE("Lost to Competitor - Google"),
    LOST_TO_COMPETITOR_MICROSOFT("Lost to Competitor - Microsoft"),
    LOST_TO_COMPETITOR_SOFT_LAYER("Lost to Competitor - SoftLayer"),
    LOST_TO_COMPETITOR_VM_WARE("Lost to Competitor - VMWare"),
    LOST_TO_COMPETITOR_OTHER("Lost to Competitor - Other"),
    NO_OPPORTUNITY("No Opportunity"),
    ON_PREMISES_DEPLOYMENT("On Premises Deployment"),
    PARTNER_GAP("Partner Gap"),
    PRICE("Price"),
    SECURITY_COMPLIANCE("Security / Compliance"),
    TECHNICAL_LIMITATIONS("Technical Limitations"),
    CUSTOMER_EXPERIENCE("Customer Experience"),
    OTHER("Other"),
    PEOPLE_RELATIONSHIP_GOVERNANCE("People/Relationship/Governance"),
    PRODUCT_TECHNOLOGY("Product/Technology"),
    FINANCIAL_COMMERCIAL("Financial/Commercial"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ClosedLostReason> VALUE_MAP;
    private final String value;

    private ClosedLostReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ClosedLostReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ClosedLostReason> knownValues() {
        EnumSet<ClosedLostReason> knownValues = EnumSet.allOf(ClosedLostReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ClosedLostReason.class, ClosedLostReason::toString);
    }
}

