/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutSellingSystemSettingsRequest
extends PartnerCentralSellingRequest
implements ToCopyableBuilder<Builder, PutSellingSystemSettingsRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(PutSellingSystemSettingsRequest.getter(PutSellingSystemSettingsRequest::catalog)).setter(PutSellingSystemSettingsRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> RESOURCE_SNAPSHOT_JOB_ROLE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceSnapshotJobRoleIdentifier").getter(PutSellingSystemSettingsRequest.getter(PutSellingSystemSettingsRequest::resourceSnapshotJobRoleIdentifier)).setter(PutSellingSystemSettingsRequest.setter(Builder::resourceSnapshotJobRoleIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSnapshotJobRoleIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, RESOURCE_SNAPSHOT_JOB_ROLE_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Catalog", CATALOG_FIELD);
            this.put("ResourceSnapshotJobRoleIdentifier", RESOURCE_SNAPSHOT_JOB_ROLE_IDENTIFIER_FIELD);
        }
    });
    private final String catalog;
    private final String resourceSnapshotJobRoleIdentifier;

    private PutSellingSystemSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.resourceSnapshotJobRoleIdentifier = builder.resourceSnapshotJobRoleIdentifier;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String resourceSnapshotJobRoleIdentifier() {
        return this.resourceSnapshotJobRoleIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSnapshotJobRoleIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSellingSystemSettingsRequest)) {
            return false;
        }
        PutSellingSystemSettingsRequest other = (PutSellingSystemSettingsRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.resourceSnapshotJobRoleIdentifier(), other.resourceSnapshotJobRoleIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"PutSellingSystemSettingsRequest").add("Catalog", (Object)this.catalog()).add("ResourceSnapshotJobRoleIdentifier", (Object)this.resourceSnapshotJobRoleIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "ResourceSnapshotJobRoleIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceSnapshotJobRoleIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutSellingSystemSettingsRequest, T> g) {
        return obj -> g.apply((PutSellingSystemSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private String resourceSnapshotJobRoleIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSellingSystemSettingsRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.resourceSnapshotJobRoleIdentifier(model.resourceSnapshotJobRoleIdentifier);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getResourceSnapshotJobRoleIdentifier() {
            return this.resourceSnapshotJobRoleIdentifier;
        }

        public final void setResourceSnapshotJobRoleIdentifier(String resourceSnapshotJobRoleIdentifier) {
            this.resourceSnapshotJobRoleIdentifier = resourceSnapshotJobRoleIdentifier;
        }

        @Override
        public final Builder resourceSnapshotJobRoleIdentifier(String resourceSnapshotJobRoleIdentifier) {
            this.resourceSnapshotJobRoleIdentifier = resourceSnapshotJobRoleIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSellingSystemSettingsRequest build() {
            return new PutSellingSystemSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PartnerCentralSellingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutSellingSystemSettingsRequest> {
        public Builder catalog(String var1);

        public Builder resourceSnapshotJobRoleIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

