/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CompetitorName {
    ORACLE_CLOUD("Oracle Cloud"),
    ON_PREM("On-Prem"),
    CO_LOCATION("Co-location"),
    AKAMAI("Akamai"),
    ALI_CLOUD("AliCloud"),
    GOOGLE_CLOUD_PLATFORM("Google Cloud Platform"),
    IBM_SOFTLAYER("IBM Softlayer"),
    MICROSOFT_AZURE("Microsoft Azure"),
    OTHER_COST_OPTIMIZATION("Other- Cost Optimization"),
    NO_COMPETITION("No Competition"),
    OTHER("*Other"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CompetitorName> VALUE_MAP;
    private final String value;

    private CompetitorName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CompetitorName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CompetitorName> knownValues() {
        EnumSet<CompetitorName> knownValues = EnumSet.allOf(CompetitorName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CompetitorName.class, CompetitorName::toString);
    }
}

