/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Industry {
    AEROSPACE("Aerospace"),
    AGRICULTURE("Agriculture"),
    AUTOMOTIVE("Automotive"),
    COMPUTERS_AND_ELECTRONICS("Computers and Electronics"),
    CONSUMER_GOODS("Consumer Goods"),
    EDUCATION("Education"),
    ENERGY_OIL_AND_GAS("Energy - Oil and Gas"),
    ENERGY_POWER_AND_UTILITIES("Energy - Power and Utilities"),
    FINANCIAL_SERVICES("Financial Services"),
    GAMING("Gaming"),
    GOVERNMENT("Government"),
    HEALTHCARE("Healthcare"),
    HOSPITALITY("Hospitality"),
    LIFE_SCIENCES("Life Sciences"),
    MANUFACTURING("Manufacturing"),
    MARKETING_AND_ADVERTISING("Marketing and Advertising"),
    MEDIA_AND_ENTERTAINMENT("Media and Entertainment"),
    MINING("Mining"),
    NON_PROFIT_ORGANIZATION("Non-Profit Organization"),
    PROFESSIONAL_SERVICES("Professional Services"),
    REAL_ESTATE_AND_CONSTRUCTION("Real Estate and Construction"),
    RETAIL("Retail"),
    SOFTWARE_AND_INTERNET("Software and Internet"),
    TELECOMMUNICATIONS("Telecommunications"),
    TRANSPORTATION_AND_LOGISTICS("Transportation and Logistics"),
    TRAVEL("Travel"),
    WHOLESALE_AND_DISTRIBUTION("Wholesale and Distribution"),
    OTHER("Other"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Industry> VALUE_MAP;
    private final String value;

    private Industry(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Industry fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Industry> knownValues() {
        EnumSet<Industry> knownValues = EnumSet.allOf(Industry.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Industry.class, Industry::toString);
    }
}

