/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralselling.PartnerCentralSellingClient;
import software.amazon.awssdk.services.partnercentralselling.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotJobsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotJobsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ResourceSnapshotJobSummary;

public class ListResourceSnapshotJobsIterable
implements SdkIterable<ListResourceSnapshotJobsResponse> {
    private final PartnerCentralSellingClient client;
    private final ListResourceSnapshotJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourceSnapshotJobsIterable(PartnerCentralSellingClient client, ListResourceSnapshotJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResourceSnapshotJobsResponseFetcher();
    }

    public Iterator<ListResourceSnapshotJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceSnapshotJobSummary> resourceSnapshotJobSummaries() {
        Function<ListResourceSnapshotJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceSnapshotJobSummaries() != null) {
                return response.resourceSnapshotJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResourceSnapshotJobsResponseFetcher
    implements SyncPageFetcher<ListResourceSnapshotJobsResponse> {
        private ListResourceSnapshotJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceSnapshotJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourceSnapshotJobsResponse nextPage(ListResourceSnapshotJobsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceSnapshotJobsIterable.this.client.listResourceSnapshotJobs(ListResourceSnapshotJobsIterable.this.firstRequest);
            }
            return ListResourceSnapshotJobsIterable.this.client.listResourceSnapshotJobs((ListResourceSnapshotJobsRequest)((Object)ListResourceSnapshotJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

