/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the <code>Customer</code>'s account details associated with the <code>Opportunity</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Account implements SdkPojo, Serializable, ToCopyableBuilder<Account.Builder, Account> {
    private static final SdkField<Address> ADDRESS_FIELD = SdkField.<Address> builder(MarshallingType.SDK_POJO)
            .memberName("Address").getter(getter(Account::address)).setter(setter(Builder::address))
            .constructor(Address::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(Account::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> COMPANY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompanyName").getter(getter(Account::companyName)).setter(setter(Builder::companyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompanyName").build()).build();

    private static final SdkField<String> DUNS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Duns")
            .getter(getter(Account::duns)).setter(setter(Builder::duns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duns").build()).build();

    private static final SdkField<String> INDUSTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Industry").getter(getter(Account::industryAsString)).setter(setter(Builder::industry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Industry").build()).build();

    private static final SdkField<String> OTHER_INDUSTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OtherIndustry").getter(getter(Account::otherIndustry)).setter(setter(Builder::otherIndustry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherIndustry").build()).build();

    private static final SdkField<String> WEBSITE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebsiteUrl").getter(getter(Account::websiteUrl)).setter(setter(Builder::websiteUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebsiteUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD,
            AWS_ACCOUNT_ID_FIELD, COMPANY_NAME_FIELD, DUNS_FIELD, INDUSTRY_FIELD, OTHER_INDUSTRY_FIELD, WEBSITE_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Address address;

    private final String awsAccountId;

    private final String companyName;

    private final String duns;

    private final String industry;

    private final String otherIndustry;

    private final String websiteUrl;

    private Account(BuilderImpl builder) {
        this.address = builder.address;
        this.awsAccountId = builder.awsAccountId;
        this.companyName = builder.companyName;
        this.duns = builder.duns;
        this.industry = builder.industry;
        this.otherIndustry = builder.otherIndustry;
        this.websiteUrl = builder.websiteUrl;
    }

    /**
     * <p>
     * Specifies the end <code>Customer</code>'s address details associated with the <code>Opportunity</code>.
     * </p>
     * 
     * @return Specifies the end <code>Customer</code>'s address details associated with the <code>Opportunity</code>.
     */
    public final Address address() {
        return address;
    }

    /**
     * <p>
     * Specifies the <code>Customer</code> Amazon Web Services account ID associated with the <code>Opportunity</code>.
     * </p>
     * 
     * @return Specifies the <code>Customer</code> Amazon Web Services account ID associated with the
     *         <code>Opportunity</code>.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * Specifies the end <code>Customer</code>'s company name associated with the <code>Opportunity</code>.
     * </p>
     * 
     * @return Specifies the end <code>Customer</code>'s company name associated with the <code>Opportunity</code>.
     */
    public final String companyName() {
        return companyName;
    }

    /**
     * <p>
     * Indicates the <code>Customer</code> DUNS number, if available.
     * </p>
     * 
     * @return Indicates the <code>Customer</code> DUNS number, if available.
     */
    public final String duns() {
        return duns;
    }

    /**
     * <p>
     * Specifies the industry the end <code>Customer</code> belongs to that's associated with the
     * <code>Opportunity</code>. It refers to the category or sector where the customer's business operates. This is a
     * required field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #industry} will
     * return {@link Industry#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #industryAsString}.
     * </p>
     * 
     * @return Specifies the industry the end <code>Customer</code> belongs to that's associated with the
     *         <code>Opportunity</code>. It refers to the category or sector where the customer's business operates.
     *         This is a required field.
     * @see Industry
     */
    public final Industry industry() {
        return Industry.fromValue(industry);
    }

    /**
     * <p>
     * Specifies the industry the end <code>Customer</code> belongs to that's associated with the
     * <code>Opportunity</code>. It refers to the category or sector where the customer's business operates. This is a
     * required field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #industry} will
     * return {@link Industry#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #industryAsString}.
     * </p>
     * 
     * @return Specifies the industry the end <code>Customer</code> belongs to that's associated with the
     *         <code>Opportunity</code>. It refers to the category or sector where the customer's business operates.
     *         This is a required field.
     * @see Industry
     */
    public final String industryAsString() {
        return industry;
    }

    /**
     * <p>
     * Specifies the end <code>Customer</code>'s industry associated with the <code>Opportunity</code>, when the
     * selected value in the <code>Industry</code> field is <code>Other</code>.
     * </p>
     * 
     * @return Specifies the end <code>Customer</code>'s industry associated with the <code>Opportunity</code>, when the
     *         selected value in the <code>Industry</code> field is <code>Other</code>.
     */
    public final String otherIndustry() {
        return otherIndustry;
    }

    /**
     * <p>
     * Specifies the end customer's company website URL associated with the <code>Opportunity</code>. This value is
     * crucial to map the customer within the Amazon Web Services CRM system. This field is required in all cases except
     * when the opportunity is related to national security.
     * </p>
     * 
     * @return Specifies the end customer's company website URL associated with the <code>Opportunity</code>. This value
     *         is crucial to map the customer within the Amazon Web Services CRM system. This field is required in all
     *         cases except when the opportunity is related to national security.
     */
    public final String websiteUrl() {
        return websiteUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(companyName());
        hashCode = 31 * hashCode + Objects.hashCode(duns());
        hashCode = 31 * hashCode + Objects.hashCode(industryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(otherIndustry());
        hashCode = 31 * hashCode + Objects.hashCode(websiteUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Account)) {
            return false;
        }
        Account other = (Account) obj;
        return Objects.equals(address(), other.address()) && Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(companyName(), other.companyName()) && Objects.equals(duns(), other.duns())
                && Objects.equals(industryAsString(), other.industryAsString())
                && Objects.equals(otherIndustry(), other.otherIndustry()) && Objects.equals(websiteUrl(), other.websiteUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Account").add("Address", address())
                .add("AwsAccountId", awsAccountId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CompanyName", companyName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Duns", duns() == null ? null : "*** Sensitive Data Redacted ***").add("Industry", industryAsString())
                .add("OtherIndustry", otherIndustry())
                .add("WebsiteUrl", websiteUrl() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "CompanyName":
            return Optional.ofNullable(clazz.cast(companyName()));
        case "Duns":
            return Optional.ofNullable(clazz.cast(duns()));
        case "Industry":
            return Optional.ofNullable(clazz.cast(industryAsString()));
        case "OtherIndustry":
            return Optional.ofNullable(clazz.cast(otherIndustry()));
        case "WebsiteUrl":
            return Optional.ofNullable(clazz.cast(websiteUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Address", ADDRESS_FIELD);
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("CompanyName", COMPANY_NAME_FIELD);
        map.put("Duns", DUNS_FIELD);
        map.put("Industry", INDUSTRY_FIELD);
        map.put("OtherIndustry", OTHER_INDUSTRY_FIELD);
        map.put("WebsiteUrl", WEBSITE_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Account, T> g) {
        return obj -> g.apply((Account) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Account> {
        /**
         * <p>
         * Specifies the end <code>Customer</code>'s address details associated with the <code>Opportunity</code>.
         * </p>
         * 
         * @param address
         *        Specifies the end <code>Customer</code>'s address details associated with the <code>Opportunity</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(Address address);

        /**
         * <p>
         * Specifies the end <code>Customer</code>'s address details associated with the <code>Opportunity</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Address.Builder} avoiding the need to
         * create one manually via {@link Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Address.Builder#build()} is called immediately and its result is
         * passed to {@link #address(Address)}.
         * 
         * @param address
         *        a consumer that will call methods on {@link Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #address(Address)
         */
        default Builder address(Consumer<Address.Builder> address) {
            return address(Address.builder().applyMutation(address).build());
        }

        /**
         * <p>
         * Specifies the <code>Customer</code> Amazon Web Services account ID associated with the
         * <code>Opportunity</code>.
         * </p>
         * 
         * @param awsAccountId
         *        Specifies the <code>Customer</code> Amazon Web Services account ID associated with the
         *        <code>Opportunity</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * Specifies the end <code>Customer</code>'s company name associated with the <code>Opportunity</code>.
         * </p>
         * 
         * @param companyName
         *        Specifies the end <code>Customer</code>'s company name associated with the <code>Opportunity</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder companyName(String companyName);

        /**
         * <p>
         * Indicates the <code>Customer</code> DUNS number, if available.
         * </p>
         * 
         * @param duns
         *        Indicates the <code>Customer</code> DUNS number, if available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duns(String duns);

        /**
         * <p>
         * Specifies the industry the end <code>Customer</code> belongs to that's associated with the
         * <code>Opportunity</code>. It refers to the category or sector where the customer's business operates. This is
         * a required field.
         * </p>
         * 
         * @param industry
         *        Specifies the industry the end <code>Customer</code> belongs to that's associated with the
         *        <code>Opportunity</code>. It refers to the category or sector where the customer's business operates.
         *        This is a required field.
         * @see Industry
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Industry
         */
        Builder industry(String industry);

        /**
         * <p>
         * Specifies the industry the end <code>Customer</code> belongs to that's associated with the
         * <code>Opportunity</code>. It refers to the category or sector where the customer's business operates. This is
         * a required field.
         * </p>
         * 
         * @param industry
         *        Specifies the industry the end <code>Customer</code> belongs to that's associated with the
         *        <code>Opportunity</code>. It refers to the category or sector where the customer's business operates.
         *        This is a required field.
         * @see Industry
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Industry
         */
        Builder industry(Industry industry);

        /**
         * <p>
         * Specifies the end <code>Customer</code>'s industry associated with the <code>Opportunity</code>, when the
         * selected value in the <code>Industry</code> field is <code>Other</code>.
         * </p>
         * 
         * @param otherIndustry
         *        Specifies the end <code>Customer</code>'s industry associated with the <code>Opportunity</code>, when
         *        the selected value in the <code>Industry</code> field is <code>Other</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otherIndustry(String otherIndustry);

        /**
         * <p>
         * Specifies the end customer's company website URL associated with the <code>Opportunity</code>. This value is
         * crucial to map the customer within the Amazon Web Services CRM system. This field is required in all cases
         * except when the opportunity is related to national security.
         * </p>
         * 
         * @param websiteUrl
         *        Specifies the end customer's company website URL associated with the <code>Opportunity</code>. This
         *        value is crucial to map the customer within the Amazon Web Services CRM system. This field is required
         *        in all cases except when the opportunity is related to national security.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder websiteUrl(String websiteUrl);
    }

    static final class BuilderImpl implements Builder {
        private Address address;

        private String awsAccountId;

        private String companyName;

        private String duns;

        private String industry;

        private String otherIndustry;

        private String websiteUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(Account model) {
            address(model.address);
            awsAccountId(model.awsAccountId);
            companyName(model.companyName);
            duns(model.duns);
            industry(model.industry);
            otherIndustry(model.otherIndustry);
            websiteUrl(model.websiteUrl);
        }

        public final Address.Builder getAddress() {
            return address != null ? address.toBuilder() : null;
        }

        public final void setAddress(Address.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(Address address) {
            this.address = address;
            return this;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getCompanyName() {
            return companyName;
        }

        public final void setCompanyName(String companyName) {
            this.companyName = companyName;
        }

        @Override
        public final Builder companyName(String companyName) {
            this.companyName = companyName;
            return this;
        }

        public final String getDuns() {
            return duns;
        }

        public final void setDuns(String duns) {
            this.duns = duns;
        }

        @Override
        public final Builder duns(String duns) {
            this.duns = duns;
            return this;
        }

        public final String getIndustry() {
            return industry;
        }

        public final void setIndustry(String industry) {
            this.industry = industry;
        }

        @Override
        public final Builder industry(String industry) {
            this.industry = industry;
            return this;
        }

        @Override
        public final Builder industry(Industry industry) {
            this.industry(industry == null ? null : industry.toString());
            return this;
        }

        public final String getOtherIndustry() {
            return otherIndustry;
        }

        public final void setOtherIndustry(String otherIndustry) {
            this.otherIndustry = otherIndustry;
        }

        @Override
        public final Builder otherIndustry(String otherIndustry) {
            this.otherIndustry = otherIndustry;
            return this;
        }

        public final String getWebsiteUrl() {
            return websiteUrl;
        }

        public final void setWebsiteUrl(String websiteUrl) {
            this.websiteUrl = websiteUrl;
        }

        @Override
        public final Builder websiteUrl(String websiteUrl) {
            this.websiteUrl = websiteUrl;
            return this;
        }

        @Override
        public Account build() {
            return new Account(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
