/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the account details of the partner who received the Engagement Invitation, including the AWS account ID and
 * company name.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountReceiver implements SdkPojo, Serializable, ToCopyableBuilder<AccountReceiver.Builder, AccountReceiver> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Alias")
            .getter(getter(AccountReceiver::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(AccountReceiver::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD,
            AWS_ACCOUNT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String alias;

    private final String awsAccountId;

    private AccountReceiver(BuilderImpl builder) {
        this.alias = builder.alias;
        this.awsAccountId = builder.awsAccountId;
    }

    /**
     * <p>
     * Represents the alias of the partner account receiving the Engagement Invitation, making it easier to identify and
     * track the recipient in reports or logs.
     * </p>
     * 
     * @return Represents the alias of the partner account receiving the Engagement Invitation, making it easier to
     *         identify and track the recipient in reports or logs.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * Indicates the AWS account ID of the partner who received the Engagement Invitation. This is a unique identifier
     * for managing engagements with specific AWS accounts.
     * </p>
     * 
     * @return Indicates the AWS account ID of the partner who received the Engagement Invitation. This is a unique
     *         identifier for managing engagements with specific AWS accounts.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountReceiver)) {
            return false;
        }
        AccountReceiver other = (AccountReceiver) obj;
        return Objects.equals(alias(), other.alias()) && Objects.equals(awsAccountId(), other.awsAccountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountReceiver").add("Alias", alias())
                .add("AwsAccountId", awsAccountId() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Alias", ALIAS_FIELD);
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountReceiver, T> g) {
        return obj -> g.apply((AccountReceiver) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountReceiver> {
        /**
         * <p>
         * Represents the alias of the partner account receiving the Engagement Invitation, making it easier to identify
         * and track the recipient in reports or logs.
         * </p>
         * 
         * @param alias
         *        Represents the alias of the partner account receiving the Engagement Invitation, making it easier to
         *        identify and track the recipient in reports or logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * Indicates the AWS account ID of the partner who received the Engagement Invitation. This is a unique
         * identifier for managing engagements with specific AWS accounts.
         * </p>
         * 
         * @param awsAccountId
         *        Indicates the AWS account ID of the partner who received the Engagement Invitation. This is a unique
         *        identifier for managing engagements with specific AWS accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);
    }

    static final class BuilderImpl implements Builder {
        private String alias;

        private String awsAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountReceiver model) {
            alias(model.alias);
            awsAccountId(model.awsAccountId);
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        @Override
        public AccountReceiver build() {
            return new AccountReceiver(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
