/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum AwsClosedLostReason {
    ADMINISTRATIVE("Administrative"),

    BUSINESS_ASSOCIATE_AGREEMENT("Business Associate Agreement"),

    COMPANY_ACQUIRED_DISSOLVED("Company Acquired/Dissolved"),

    COMPETITIVE_OFFERING("Competitive Offering"),

    CUSTOMER_DATA_REQUIREMENT("Customer Data Requirement"),

    CUSTOMER_DEFICIENCY("Customer Deficiency"),

    CUSTOMER_EXPERIENCE("Customer Experience"),

    DELAY_CANCELLATION_OF_PROJECT("Delay / Cancellation of Project"),

    DUPLICATE("Duplicate"),

    DUPLICATE_OPPORTUNITY("Duplicate Opportunity"),

    EXECUTIVE_BLOCKER("Executive Blocker"),

    FAILED_VETTING("Failed Vetting"),

    FEATURE_LIMITATION("Feature Limitation"),

    FINANCIAL_COMMERCIAL("Financial/Commercial"),

    INSUFFICIENT_AMAZON_VALUE("Insufficient Amazon Value"),

    INSUFFICIENT_AWS_VALUE("Insufficient AWS Value"),

    INTERNATIONAL_CONSTRAINTS("International Constraints"),

    LEGAL_TAX_REGULATORY("Legal / Tax / Regulatory"),

    LEGAL_TERMS_AND_CONDITIONS("Legal Terms and Conditions"),

    LOST_TO_COMPETITOR("Lost to Competitor"),

    LOST_TO_COMPETITOR_GOOGLE("Lost to Competitor - Google"),

    LOST_TO_COMPETITOR_MICROSOFT("Lost to Competitor - Microsoft"),

    LOST_TO_COMPETITOR_OTHER("Lost to Competitor - Other"),

    LOST_TO_COMPETITOR_RACKSPACE("Lost to Competitor - Rackspace"),

    LOST_TO_COMPETITOR_SOFT_LAYER("Lost to Competitor - SoftLayer"),

    LOST_TO_COMPETITOR_VM_WARE("Lost to Competitor - VMWare"),

    NO_CUSTOMER_REFERENCE("No Customer Reference"),

    NO_INTEGRATION_RESOURCES("No Integration Resources"),

    NO_OPPORTUNITY("No Opportunity"),

    NO_PERCEIVED_VALUE_OF_MP("No Perceived Value of MP"),

    NO_RESPONSE("No Response"),

    NOT_COMMITTED_TO_AWS("Not Committed to AWS"),

    NO_UPDATE("No Update"),

    ON_PREMISES_DEPLOYMENT("On Premises Deployment"),

    OTHER("Other"),

    OTHER_DETAILS_IN_DESCRIPTION("Other (Details in Description)"),

    PARTNER_GAP("Partner Gap"),

    PAST_DUE("Past Due"),

    PEOPLE_RELATIONSHIP_GOVERNANCE("People/Relationship/Governance"),

    PLATFORM_TECHNOLOGY_LIMITATION("Platform Technology Limitation"),

    PREFERENCE_FOR_COMPETITOR("Preference for Competitor"),

    PRICE("Price"),

    PRODUCT_TECHNOLOGY("Product/Technology"),

    PRODUCT_NOT_ON_AWS("Product Not on AWS"),

    SECURITY_COMPLIANCE("Security / Compliance"),

    SELF_SERVICE("Self-Service"),

    TECHNICAL_LIMITATIONS("Technical Limitations"),

    TERM_SHEET_IMPASSE("Term Sheet Impasse"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AwsClosedLostReason> VALUE_MAP = EnumUtils.uniqueIndex(AwsClosedLostReason.class,
            AwsClosedLostReason::toString);

    private final String value;

    private AwsClosedLostReason(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return AwsClosedLostReason corresponding to the value
     */
    public static AwsClosedLostReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link AwsClosedLostReason}s
     */
    public static Set<AwsClosedLostReason> knownValues() {
        Set<AwsClosedLostReason> knownValues = EnumSet.allOf(AwsClosedLostReason.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
