/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains insights provided by AWS for the opportunity, offering recommendations and analysis that can help the
 * partner optimize their engagement and strategy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsOpportunityInsights implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsOpportunityInsights.Builder, AwsOpportunityInsights> {
    private static final SdkField<String> ENGAGEMENT_SCORE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngagementScore").getter(getter(AwsOpportunityInsights::engagementScoreAsString))
            .setter(setter(Builder::engagementScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementScore").build()).build();

    private static final SdkField<String> NEXT_BEST_ACTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextBestActions").getter(getter(AwsOpportunityInsights::nextBestActions))
            .setter(setter(Builder::nextBestActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextBestActions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGAGEMENT_SCORE_FIELD,
            NEXT_BEST_ACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String engagementScore;

    private final String nextBestActions;

    private AwsOpportunityInsights(BuilderImpl builder) {
        this.engagementScore = builder.engagementScore;
        this.nextBestActions = builder.nextBestActions;
    }

    /**
     * <p>
     * Represents a score assigned by AWS to indicate the level of engagement and potential success for the opportunity.
     * This score helps partners prioritize their efforts.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engagementScore}
     * will return {@link EngagementScore#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #engagementScoreAsString}.
     * </p>
     * 
     * @return Represents a score assigned by AWS to indicate the level of engagement and potential success for the
     *         opportunity. This score helps partners prioritize their efforts.
     * @see EngagementScore
     */
    public final EngagementScore engagementScore() {
        return EngagementScore.fromValue(engagementScore);
    }

    /**
     * <p>
     * Represents a score assigned by AWS to indicate the level of engagement and potential success for the opportunity.
     * This score helps partners prioritize their efforts.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engagementScore}
     * will return {@link EngagementScore#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #engagementScoreAsString}.
     * </p>
     * 
     * @return Represents a score assigned by AWS to indicate the level of engagement and potential success for the
     *         opportunity. This score helps partners prioritize their efforts.
     * @see EngagementScore
     */
    public final String engagementScoreAsString() {
        return engagementScore;
    }

    /**
     * <p>
     * Provides recommendations from AWS on the next best actions to take in order to move the opportunity forward and
     * increase the likelihood of success.
     * </p>
     * 
     * @return Provides recommendations from AWS on the next best actions to take in order to move the opportunity
     *         forward and increase the likelihood of success.
     */
    public final String nextBestActions() {
        return nextBestActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(engagementScoreAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextBestActions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsOpportunityInsights)) {
            return false;
        }
        AwsOpportunityInsights other = (AwsOpportunityInsights) obj;
        return Objects.equals(engagementScoreAsString(), other.engagementScoreAsString())
                && Objects.equals(nextBestActions(), other.nextBestActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsOpportunityInsights").add("EngagementScore", engagementScoreAsString())
                .add("NextBestActions", nextBestActions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EngagementScore":
            return Optional.ofNullable(clazz.cast(engagementScoreAsString()));
        case "NextBestActions":
            return Optional.ofNullable(clazz.cast(nextBestActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EngagementScore", ENGAGEMENT_SCORE_FIELD);
        map.put("NextBestActions", NEXT_BEST_ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsOpportunityInsights, T> g) {
        return obj -> g.apply((AwsOpportunityInsights) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsOpportunityInsights> {
        /**
         * <p>
         * Represents a score assigned by AWS to indicate the level of engagement and potential success for the
         * opportunity. This score helps partners prioritize their efforts.
         * </p>
         * 
         * @param engagementScore
         *        Represents a score assigned by AWS to indicate the level of engagement and potential success for the
         *        opportunity. This score helps partners prioritize their efforts.
         * @see EngagementScore
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngagementScore
         */
        Builder engagementScore(String engagementScore);

        /**
         * <p>
         * Represents a score assigned by AWS to indicate the level of engagement and potential success for the
         * opportunity. This score helps partners prioritize their efforts.
         * </p>
         * 
         * @param engagementScore
         *        Represents a score assigned by AWS to indicate the level of engagement and potential success for the
         *        opportunity. This score helps partners prioritize their efforts.
         * @see EngagementScore
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngagementScore
         */
        Builder engagementScore(EngagementScore engagementScore);

        /**
         * <p>
         * Provides recommendations from AWS on the next best actions to take in order to move the opportunity forward
         * and increase the likelihood of success.
         * </p>
         * 
         * @param nextBestActions
         *        Provides recommendations from AWS on the next best actions to take in order to move the opportunity
         *        forward and increase the likelihood of success.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextBestActions(String nextBestActions);
    }

    static final class BuilderImpl implements Builder {
        private String engagementScore;

        private String nextBestActions;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsOpportunityInsights model) {
            engagementScore(model.engagementScore);
            nextBestActions(model.nextBestActions);
        }

        public final String getEngagementScore() {
            return engagementScore;
        }

        public final void setEngagementScore(String engagementScore) {
            this.engagementScore = engagementScore;
        }

        @Override
        public final Builder engagementScore(String engagementScore) {
            this.engagementScore = engagementScore;
            return this;
        }

        @Override
        public final Builder engagementScore(EngagementScore engagementScore) {
            this.engagementScore(engagementScore == null ? null : engagementScore.toString());
            return this;
        }

        public final String getNextBestActions() {
            return nextBestActions;
        }

        public final void setNextBestActions(String nextBestActions) {
            this.nextBestActions = nextBestActions;
        }

        @Override
        public final Builder nextBestActions(String nextBestActions) {
            this.nextBestActions = nextBestActions;
            return this;
        }

        @Override
        public AwsOpportunityInsights build() {
            return new AwsOpportunityInsights(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
