/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Captures details about the project associated with the opportunity, including objectives, scope, and customer
 * requirements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsOpportunityProject implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsOpportunityProject.Builder, AwsOpportunityProject> {
    private static final SdkField<List<ExpectedCustomerSpend>> EXPECTED_CUSTOMER_SPEND_FIELD = SdkField
            .<List<ExpectedCustomerSpend>> builder(MarshallingType.LIST)
            .memberName("ExpectedCustomerSpend")
            .getter(getter(AwsOpportunityProject::expectedCustomerSpend))
            .setter(setter(Builder::expectedCustomerSpend))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedCustomerSpend").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExpectedCustomerSpend> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExpectedCustomerSpend::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(EXPECTED_CUSTOMER_SPEND_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ExpectedCustomerSpend> expectedCustomerSpend;

    private AwsOpportunityProject(BuilderImpl builder) {
        this.expectedCustomerSpend = builder.expectedCustomerSpend;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExpectedCustomerSpend property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExpectedCustomerSpend() {
        return expectedCustomerSpend != null && !(expectedCustomerSpend instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates the expected spending by the customer over the course of the project. This value helps partners and AWS
     * estimate the financial impact of the opportunity. Use the <a href="https://calculator.aws/#/">AWS Pricing
     * Calculator</a> to create an estimate of the customer’s total spend. If only annual recurring revenue (ARR) is
     * available, distribute it across 12 months to provide an average monthly value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExpectedCustomerSpend} method.
     * </p>
     * 
     * @return Indicates the expected spending by the customer over the course of the project. This value helps partners
     *         and AWS estimate the financial impact of the opportunity. Use the <a href="https://calculator.aws/#/">AWS
     *         Pricing Calculator</a> to create an estimate of the customer’s total spend. If only annual recurring
     *         revenue (ARR) is available, distribute it across 12 months to provide an average monthly value.
     */
    public final List<ExpectedCustomerSpend> expectedCustomerSpend() {
        return expectedCustomerSpend;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasExpectedCustomerSpend() ? expectedCustomerSpend() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsOpportunityProject)) {
            return false;
        }
        AwsOpportunityProject other = (AwsOpportunityProject) obj;
        return hasExpectedCustomerSpend() == other.hasExpectedCustomerSpend()
                && Objects.equals(expectedCustomerSpend(), other.expectedCustomerSpend());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsOpportunityProject")
                .add("ExpectedCustomerSpend", hasExpectedCustomerSpend() ? expectedCustomerSpend() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExpectedCustomerSpend":
            return Optional.ofNullable(clazz.cast(expectedCustomerSpend()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExpectedCustomerSpend", EXPECTED_CUSTOMER_SPEND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsOpportunityProject, T> g) {
        return obj -> g.apply((AwsOpportunityProject) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsOpportunityProject> {
        /**
         * <p>
         * Indicates the expected spending by the customer over the course of the project. This value helps partners and
         * AWS estimate the financial impact of the opportunity. Use the <a href="https://calculator.aws/#/">AWS Pricing
         * Calculator</a> to create an estimate of the customer’s total spend. If only annual recurring revenue (ARR) is
         * available, distribute it across 12 months to provide an average monthly value.
         * </p>
         * 
         * @param expectedCustomerSpend
         *        Indicates the expected spending by the customer over the course of the project. This value helps
         *        partners and AWS estimate the financial impact of the opportunity. Use the <a
         *        href="https://calculator.aws/#/">AWS Pricing Calculator</a> to create an estimate of the customer’s
         *        total spend. If only annual recurring revenue (ARR) is available, distribute it across 12 months to
         *        provide an average monthly value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedCustomerSpend(Collection<ExpectedCustomerSpend> expectedCustomerSpend);

        /**
         * <p>
         * Indicates the expected spending by the customer over the course of the project. This value helps partners and
         * AWS estimate the financial impact of the opportunity. Use the <a href="https://calculator.aws/#/">AWS Pricing
         * Calculator</a> to create an estimate of the customer’s total spend. If only annual recurring revenue (ARR) is
         * available, distribute it across 12 months to provide an average monthly value.
         * </p>
         * 
         * @param expectedCustomerSpend
         *        Indicates the expected spending by the customer over the course of the project. This value helps
         *        partners and AWS estimate the financial impact of the opportunity. Use the <a
         *        href="https://calculator.aws/#/">AWS Pricing Calculator</a> to create an estimate of the customer’s
         *        total spend. If only annual recurring revenue (ARR) is available, distribute it across 12 months to
         *        provide an average monthly value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedCustomerSpend(ExpectedCustomerSpend... expectedCustomerSpend);

        /**
         * <p>
         * Indicates the expected spending by the customer over the course of the project. This value helps partners and
         * AWS estimate the financial impact of the opportunity. Use the <a href="https://calculator.aws/#/">AWS Pricing
         * Calculator</a> to create an estimate of the customer’s total spend. If only annual recurring revenue (ARR) is
         * available, distribute it across 12 months to provide an average monthly value.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ExpectedCustomerSpend.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ExpectedCustomerSpend#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ExpectedCustomerSpend.Builder#build()} is
         * called immediately and its result is passed to {@link #expectedCustomerSpend(List<ExpectedCustomerSpend>)}.
         * 
         * @param expectedCustomerSpend
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.ExpectedCustomerSpend.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expectedCustomerSpend(java.util.Collection<ExpectedCustomerSpend>)
         */
        Builder expectedCustomerSpend(Consumer<ExpectedCustomerSpend.Builder>... expectedCustomerSpend);
    }

    static final class BuilderImpl implements Builder {
        private List<ExpectedCustomerSpend> expectedCustomerSpend = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsOpportunityProject model) {
            expectedCustomerSpend(model.expectedCustomerSpend);
        }

        public final List<ExpectedCustomerSpend.Builder> getExpectedCustomerSpend() {
            List<ExpectedCustomerSpend.Builder> result = ExpectedCustomerSpendListCopier
                    .copyToBuilder(this.expectedCustomerSpend);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExpectedCustomerSpend(Collection<ExpectedCustomerSpend.BuilderImpl> expectedCustomerSpend) {
            this.expectedCustomerSpend = ExpectedCustomerSpendListCopier.copyFromBuilder(expectedCustomerSpend);
        }

        @Override
        public final Builder expectedCustomerSpend(Collection<ExpectedCustomerSpend> expectedCustomerSpend) {
            this.expectedCustomerSpend = ExpectedCustomerSpendListCopier.copy(expectedCustomerSpend);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedCustomerSpend(ExpectedCustomerSpend... expectedCustomerSpend) {
            expectedCustomerSpend(Arrays.asList(expectedCustomerSpend));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedCustomerSpend(Consumer<ExpectedCustomerSpend.Builder>... expectedCustomerSpend) {
            expectedCustomerSpend(Stream.of(expectedCustomerSpend)
                    .map(c -> ExpectedCustomerSpend.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsOpportunityProject build() {
            return new AwsOpportunityProject(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
