/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents other entities related to the AWS opportunity, such as AWS products, partner solutions, and marketplace
 * offers. These associations help build a complete picture of the solution being sold.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsOpportunityRelatedEntities implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsOpportunityRelatedEntities.Builder, AwsOpportunityRelatedEntities> {
    private static final SdkField<List<String>> AWS_PRODUCTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AwsProducts")
            .getter(getter(AwsOpportunityRelatedEntities::awsProducts))
            .setter(setter(Builder::awsProducts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsProducts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SOLUTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Solutions")
            .getter(getter(AwsOpportunityRelatedEntities::solutions))
            .setter(setter(Builder::solutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Solutions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_PRODUCTS_FIELD,
            SOLUTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> awsProducts;

    private final List<String> solutions;

    private AwsOpportunityRelatedEntities(BuilderImpl builder) {
        this.awsProducts = builder.awsProducts;
        this.solutions = builder.solutions;
    }

    /**
     * For responses, this returns true if the service returned a value for the AwsProducts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAwsProducts() {
        return awsProducts != null && !(awsProducts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the AWS products associated with the opportunity. This field helps track the specific products that are
     * part of the proposed solution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAwsProducts} method.
     * </p>
     * 
     * @return Specifies the AWS products associated with the opportunity. This field helps track the specific products
     *         that are part of the proposed solution.
     */
    public final List<String> awsProducts() {
        return awsProducts;
    }

    /**
     * For responses, this returns true if the service returned a value for the Solutions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSolutions() {
        return solutions != null && !(solutions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the partner solutions related to the opportunity. These solutions represent the partner's offerings
     * that are being positioned as part of the overall AWS opportunity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSolutions} method.
     * </p>
     * 
     * @return Specifies the partner solutions related to the opportunity. These solutions represent the partner's
     *         offerings that are being positioned as part of the overall AWS opportunity.
     */
    public final List<String> solutions() {
        return solutions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAwsProducts() ? awsProducts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSolutions() ? solutions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsOpportunityRelatedEntities)) {
            return false;
        }
        AwsOpportunityRelatedEntities other = (AwsOpportunityRelatedEntities) obj;
        return hasAwsProducts() == other.hasAwsProducts() && Objects.equals(awsProducts(), other.awsProducts())
                && hasSolutions() == other.hasSolutions() && Objects.equals(solutions(), other.solutions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsOpportunityRelatedEntities").add("AwsProducts", hasAwsProducts() ? awsProducts() : null)
                .add("Solutions", hasSolutions() ? solutions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsProducts":
            return Optional.ofNullable(clazz.cast(awsProducts()));
        case "Solutions":
            return Optional.ofNullable(clazz.cast(solutions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsProducts", AWS_PRODUCTS_FIELD);
        map.put("Solutions", SOLUTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsOpportunityRelatedEntities, T> g) {
        return obj -> g.apply((AwsOpportunityRelatedEntities) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsOpportunityRelatedEntities> {
        /**
         * <p>
         * Specifies the AWS products associated with the opportunity. This field helps track the specific products that
         * are part of the proposed solution.
         * </p>
         * 
         * @param awsProducts
         *        Specifies the AWS products associated with the opportunity. This field helps track the specific
         *        products that are part of the proposed solution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsProducts(Collection<String> awsProducts);

        /**
         * <p>
         * Specifies the AWS products associated with the opportunity. This field helps track the specific products that
         * are part of the proposed solution.
         * </p>
         * 
         * @param awsProducts
         *        Specifies the AWS products associated with the opportunity. This field helps track the specific
         *        products that are part of the proposed solution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsProducts(String... awsProducts);

        /**
         * <p>
         * Specifies the partner solutions related to the opportunity. These solutions represent the partner's offerings
         * that are being positioned as part of the overall AWS opportunity.
         * </p>
         * 
         * @param solutions
         *        Specifies the partner solutions related to the opportunity. These solutions represent the partner's
         *        offerings that are being positioned as part of the overall AWS opportunity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutions(Collection<String> solutions);

        /**
         * <p>
         * Specifies the partner solutions related to the opportunity. These solutions represent the partner's offerings
         * that are being positioned as part of the overall AWS opportunity.
         * </p>
         * 
         * @param solutions
         *        Specifies the partner solutions related to the opportunity. These solutions represent the partner's
         *        offerings that are being positioned as part of the overall AWS opportunity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutions(String... solutions);
    }

    static final class BuilderImpl implements Builder {
        private List<String> awsProducts = DefaultSdkAutoConstructList.getInstance();

        private List<String> solutions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsOpportunityRelatedEntities model) {
            awsProducts(model.awsProducts);
            solutions(model.solutions);
        }

        public final Collection<String> getAwsProducts() {
            if (awsProducts instanceof SdkAutoConstructList) {
                return null;
            }
            return awsProducts;
        }

        public final void setAwsProducts(Collection<String> awsProducts) {
            this.awsProducts = AwsProductIdentifiersCopier.copy(awsProducts);
        }

        @Override
        public final Builder awsProducts(Collection<String> awsProducts) {
            this.awsProducts = AwsProductIdentifiersCopier.copy(awsProducts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsProducts(String... awsProducts) {
            awsProducts(Arrays.asList(awsProducts));
            return this;
        }

        public final Collection<String> getSolutions() {
            if (solutions instanceof SdkAutoConstructList) {
                return null;
            }
            return solutions;
        }

        public final void setSolutions(Collection<String> solutions) {
            this.solutions = SolutionIdentifiersCopier.copy(solutions);
        }

        @Override
        public final Builder solutions(Collection<String> solutions) {
            this.solutions = SolutionIdentifiersCopier.copy(solutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder solutions(String... solutions) {
            solutions(Arrays.asList(solutions));
            return this;
        }

        @Override
        public AwsOpportunityRelatedEntities build() {
            return new AwsOpportunityRelatedEntities(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
