/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates the level of AWS involvement in the opportunity. This field helps track AWS participation throughout the
 * engagement, such as providing technical support, deal assistance, and sales support.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsSubmission implements SdkPojo, Serializable, ToCopyableBuilder<AwsSubmission.Builder, AwsSubmission> {
    private static final SdkField<String> INVOLVEMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvolvementType").getter(getter(AwsSubmission::involvementTypeAsString))
            .setter(setter(Builder::involvementType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvolvementType").build()).build();

    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(AwsSubmission::visibilityAsString)).setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOLVEMENT_TYPE_FIELD,
            VISIBILITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String involvementType;

    private final String visibility;

    private AwsSubmission(BuilderImpl builder) {
        this.involvementType = builder.involvementType;
        this.visibility = builder.visibility;
    }

    /**
     * <p>
     * Specifies the type of AWS involvement in the opportunity, such as coselling, deal support, or technical
     * consultation. This helps categorize the nature of AWS participation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #involvementType}
     * will return {@link SalesInvolvementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #involvementTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of AWS involvement in the opportunity, such as coselling, deal support, or technical
     *         consultation. This helps categorize the nature of AWS participation.
     * @see SalesInvolvementType
     */
    public final SalesInvolvementType involvementType() {
        return SalesInvolvementType.fromValue(involvementType);
    }

    /**
     * <p>
     * Specifies the type of AWS involvement in the opportunity, such as coselling, deal support, or technical
     * consultation. This helps categorize the nature of AWS participation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #involvementType}
     * will return {@link SalesInvolvementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #involvementTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of AWS involvement in the opportunity, such as coselling, deal support, or technical
     *         consultation. This helps categorize the nature of AWS participation.
     * @see SalesInvolvementType
     */
    public final String involvementTypeAsString() {
        return involvementType;
    }

    /**
     * <p>
     * Determines who can view AWS involvement in the opportunity. Typically, this field is set to <code>Full</code> for
     * most cases, but it may be restricted based on special program requirements or confidentiality needs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return Determines who can view AWS involvement in the opportunity. Typically, this field is set to
     *         <code>Full</code> for most cases, but it may be restricted based on special program requirements or
     *         confidentiality needs.
     * @see Visibility
     */
    public final Visibility visibility() {
        return Visibility.fromValue(visibility);
    }

    /**
     * <p>
     * Determines who can view AWS involvement in the opportunity. Typically, this field is set to <code>Full</code> for
     * most cases, but it may be restricted based on special program requirements or confidentiality needs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return Determines who can view AWS involvement in the opportunity. Typically, this field is set to
     *         <code>Full</code> for most cases, but it may be restricted based on special program requirements or
     *         confidentiality needs.
     * @see Visibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(involvementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsSubmission)) {
            return false;
        }
        AwsSubmission other = (AwsSubmission) obj;
        return Objects.equals(involvementTypeAsString(), other.involvementTypeAsString())
                && Objects.equals(visibilityAsString(), other.visibilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsSubmission").add("InvolvementType", involvementTypeAsString())
                .add("Visibility", visibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InvolvementType":
            return Optional.ofNullable(clazz.cast(involvementTypeAsString()));
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InvolvementType", INVOLVEMENT_TYPE_FIELD);
        map.put("Visibility", VISIBILITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsSubmission, T> g) {
        return obj -> g.apply((AwsSubmission) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsSubmission> {
        /**
         * <p>
         * Specifies the type of AWS involvement in the opportunity, such as coselling, deal support, or technical
         * consultation. This helps categorize the nature of AWS participation.
         * </p>
         * 
         * @param involvementType
         *        Specifies the type of AWS involvement in the opportunity, such as coselling, deal support, or
         *        technical consultation. This helps categorize the nature of AWS participation.
         * @see SalesInvolvementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SalesInvolvementType
         */
        Builder involvementType(String involvementType);

        /**
         * <p>
         * Specifies the type of AWS involvement in the opportunity, such as coselling, deal support, or technical
         * consultation. This helps categorize the nature of AWS participation.
         * </p>
         * 
         * @param involvementType
         *        Specifies the type of AWS involvement in the opportunity, such as coselling, deal support, or
         *        technical consultation. This helps categorize the nature of AWS participation.
         * @see SalesInvolvementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SalesInvolvementType
         */
        Builder involvementType(SalesInvolvementType involvementType);

        /**
         * <p>
         * Determines who can view AWS involvement in the opportunity. Typically, this field is set to <code>Full</code>
         * for most cases, but it may be restricted based on special program requirements or confidentiality needs.
         * </p>
         * 
         * @param visibility
         *        Determines who can view AWS involvement in the opportunity. Typically, this field is set to
         *        <code>Full</code> for most cases, but it may be restricted based on special program requirements or
         *        confidentiality needs.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * Determines who can view AWS involvement in the opportunity. Typically, this field is set to <code>Full</code>
         * for most cases, but it may be restricted based on special program requirements or confidentiality needs.
         * </p>
         * 
         * @param visibility
         *        Determines who can view AWS involvement in the opportunity. Typically, this field is set to
         *        <code>Full</code> for most cases, but it may be restricted based on special program requirements or
         *        confidentiality needs.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(Visibility visibility);
    }

    static final class BuilderImpl implements Builder {
        private String involvementType;

        private String visibility;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsSubmission model) {
            involvementType(model.involvementType);
            visibility(model.visibility);
        }

        public final String getInvolvementType() {
            return involvementType;
        }

        public final void setInvolvementType(String involvementType) {
            this.involvementType = involvementType;
        }

        @Override
        public final Builder involvementType(String involvementType) {
            this.involvementType = involvementType;
            return this;
        }

        @Override
        public final Builder involvementType(SalesInvolvementType involvementType) {
            this.involvementType(involvementType == null ? null : involvementType.toString());
            return this;
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        @Override
        public AwsSubmission build() {
            return new AwsSubmission(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
