/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum CompetitorName {
    ORACLE_CLOUD("Oracle Cloud"),

    ON_PREM("On-Prem"),

    CO_LOCATION("Co-location"),

    AKAMAI("Akamai"),

    ALI_CLOUD("AliCloud"),

    GOOGLE_CLOUD_PLATFORM("Google Cloud Platform"),

    IBM_SOFTLAYER("IBM Softlayer"),

    MICROSOFT_AZURE("Microsoft Azure"),

    OTHER_COST_OPTIMIZATION("Other- Cost Optimization"),

    NO_COMPETITION("No Competition"),

    OTHER("*Other"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CompetitorName> VALUE_MAP = EnumUtils.uniqueIndex(CompetitorName.class,
            CompetitorName::toString);

    private final String value;

    private CompetitorName(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return CompetitorName corresponding to the value
     */
    public static CompetitorName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link CompetitorName}s
     */
    public static Set<CompetitorName> knownValues() {
        Set<CompetitorName> knownValues = EnumSet.allOf(CompetitorName.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
