/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEngagementInvitationRequest extends PartnerCentralSellingRequest implements
        ToCopyableBuilder<CreateEngagementInvitationRequest.Builder, CreateEngagementInvitationRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(CreateEngagementInvitationRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateEngagementInvitationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ENGAGEMENT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngagementIdentifier").getter(getter(CreateEngagementInvitationRequest::engagementIdentifier))
            .setter(setter(Builder::engagementIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementIdentifier").build())
            .build();

    private static final SdkField<Invitation> INVITATION_FIELD = SdkField.<Invitation> builder(MarshallingType.SDK_POJO)
            .memberName("Invitation").getter(getter(CreateEngagementInvitationRequest::invitation))
            .setter(setter(Builder::invitation)).constructor(Invitation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Invitation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            CLIENT_TOKEN_FIELD, ENGAGEMENT_IDENTIFIER_FIELD, INVITATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final String clientToken;

    private final String engagementIdentifier;

    private final Invitation invitation;

    private CreateEngagementInvitationRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.clientToken = builder.clientToken;
        this.engagementIdentifier = builder.engagementIdentifier;
        this.invitation = builder.invitation;
    }

    /**
     * <p>
     * Specifies the catalog related to the engagement. Accepted values are <code>AWS</code> and <code>Sandbox</code>,
     * which determine the environment in which the engagement is managed.
     * </p>
     * 
     * @return Specifies the catalog related to the engagement. Accepted values are <code>AWS</code> and
     *         <code>Sandbox</code>, which determine the environment in which the engagement is managed.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * Specifies a unique, client-generated UUID to ensure that the request is handled exactly once. This token helps
     * prevent duplicate invitation creations.
     * </p>
     * 
     * @return Specifies a unique, client-generated UUID to ensure that the request is handled exactly once. This token
     *         helps prevent duplicate invitation creations.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The unique identifier of the <code>Engagement</code> associated with the invitation. This parameter ensures the
     * invitation is created within the correct <code>Engagement</code> context.
     * </p>
     * 
     * @return The unique identifier of the <code>Engagement</code> associated with the invitation. This parameter
     *         ensures the invitation is created within the correct <code>Engagement</code> context.
     */
    public final String engagementIdentifier() {
        return engagementIdentifier;
    }

    /**
     * <p>
     * The <code>Invitation</code> object all information necessary to initiate an engagement invitation to a partner.
     * It contains a personalized message from the sender, the invitation's receiver, and a payload. The
     * <code>Payload</code> can be the <code>OpportunityInvitation</code>, which includes detailed structures for sender
     * contacts, partner responsibilities, customer information, and project details.
     * </p>
     * 
     * @return The <code>Invitation</code> object all information necessary to initiate an engagement invitation to a
     *         partner. It contains a personalized message from the sender, the invitation's receiver, and a payload.
     *         The <code>Payload</code> can be the <code>OpportunityInvitation</code>, which includes detailed
     *         structures for sender contacts, partner responsibilities, customer information, and project details.
     */
    public final Invitation invitation() {
        return invitation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(engagementIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(invitation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEngagementInvitationRequest)) {
            return false;
        }
        CreateEngagementInvitationRequest other = (CreateEngagementInvitationRequest) obj;
        return Objects.equals(catalog(), other.catalog()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(engagementIdentifier(), other.engagementIdentifier())
                && Objects.equals(invitation(), other.invitation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEngagementInvitationRequest").add("Catalog", catalog()).add("ClientToken", clientToken())
                .add("EngagementIdentifier", engagementIdentifier()).add("Invitation", invitation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "EngagementIdentifier":
            return Optional.ofNullable(clazz.cast(engagementIdentifier()));
        case "Invitation":
            return Optional.ofNullable(clazz.cast(invitation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("EngagementIdentifier", ENGAGEMENT_IDENTIFIER_FIELD);
        map.put("Invitation", INVITATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEngagementInvitationRequest, T> g) {
        return obj -> g.apply((CreateEngagementInvitationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PartnerCentralSellingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateEngagementInvitationRequest> {
        /**
         * <p>
         * Specifies the catalog related to the engagement. Accepted values are <code>AWS</code> and
         * <code>Sandbox</code>, which determine the environment in which the engagement is managed.
         * </p>
         * 
         * @param catalog
         *        Specifies the catalog related to the engagement. Accepted values are <code>AWS</code> and
         *        <code>Sandbox</code>, which determine the environment in which the engagement is managed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * Specifies a unique, client-generated UUID to ensure that the request is handled exactly once. This token
         * helps prevent duplicate invitation creations.
         * </p>
         * 
         * @param clientToken
         *        Specifies a unique, client-generated UUID to ensure that the request is handled exactly once. This
         *        token helps prevent duplicate invitation creations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The unique identifier of the <code>Engagement</code> associated with the invitation. This parameter ensures
         * the invitation is created within the correct <code>Engagement</code> context.
         * </p>
         * 
         * @param engagementIdentifier
         *        The unique identifier of the <code>Engagement</code> associated with the invitation. This parameter
         *        ensures the invitation is created within the correct <code>Engagement</code> context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementIdentifier(String engagementIdentifier);

        /**
         * <p>
         * The <code>Invitation</code> object all information necessary to initiate an engagement invitation to a
         * partner. It contains a personalized message from the sender, the invitation's receiver, and a payload. The
         * <code>Payload</code> can be the <code>OpportunityInvitation</code>, which includes detailed structures for
         * sender contacts, partner responsibilities, customer information, and project details.
         * </p>
         * 
         * @param invitation
         *        The <code>Invitation</code> object all information necessary to initiate an engagement invitation to a
         *        partner. It contains a personalized message from the sender, the invitation's receiver, and a payload.
         *        The <code>Payload</code> can be the <code>OpportunityInvitation</code>, which includes detailed
         *        structures for sender contacts, partner responsibilities, customer information, and project details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invitation(Invitation invitation);

        /**
         * <p>
         * The <code>Invitation</code> object all information necessary to initiate an engagement invitation to a
         * partner. It contains a personalized message from the sender, the invitation's receiver, and a payload. The
         * <code>Payload</code> can be the <code>OpportunityInvitation</code>, which includes detailed structures for
         * sender contacts, partner responsibilities, customer information, and project details.
         * </p>
         * This is a convenience method that creates an instance of the {@link Invitation.Builder} avoiding the need to
         * create one manually via {@link Invitation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Invitation.Builder#build()} is called immediately and its result
         * is passed to {@link #invitation(Invitation)}.
         * 
         * @param invitation
         *        a consumer that will call methods on {@link Invitation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invitation(Invitation)
         */
        default Builder invitation(Consumer<Invitation.Builder> invitation) {
            return invitation(Invitation.builder().applyMutation(invitation).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralSellingRequest.BuilderImpl implements Builder {
        private String catalog;

        private String clientToken;

        private String engagementIdentifier;

        private Invitation invitation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEngagementInvitationRequest model) {
            super(model);
            catalog(model.catalog);
            clientToken(model.clientToken);
            engagementIdentifier(model.engagementIdentifier);
            invitation(model.invitation);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getEngagementIdentifier() {
            return engagementIdentifier;
        }

        public final void setEngagementIdentifier(String engagementIdentifier) {
            this.engagementIdentifier = engagementIdentifier;
        }

        @Override
        public final Builder engagementIdentifier(String engagementIdentifier) {
            this.engagementIdentifier = engagementIdentifier;
            return this;
        }

        public final Invitation.Builder getInvitation() {
            return invitation != null ? invitation.toBuilder() : null;
        }

        public final void setInvitation(Invitation.BuilderImpl invitation) {
            this.invitation = invitation != null ? invitation.build() : null;
        }

        @Override
        public final Builder invitation(Invitation invitation) {
            this.invitation = invitation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEngagementInvitationRequest build() {
            return new CreateEngagementInvitationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
