/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEngagementRequest extends PartnerCentralSellingRequest implements
        ToCopyableBuilder<CreateEngagementRequest.Builder, CreateEngagementRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(CreateEngagementRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateEngagementRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<EngagementContextDetails>> CONTEXTS_FIELD = SdkField
            .<List<EngagementContextDetails>> builder(MarshallingType.LIST)
            .memberName("Contexts")
            .getter(getter(CreateEngagementRequest::contexts))
            .setter(setter(Builder::contexts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contexts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EngagementContextDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(EngagementContextDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateEngagementRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(CreateEngagementRequest::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            CLIENT_TOKEN_FIELD, CONTEXTS_FIELD, DESCRIPTION_FIELD, TITLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final String clientToken;

    private final List<EngagementContextDetails> contexts;

    private final String description;

    private final String title;

    private CreateEngagementRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.clientToken = builder.clientToken;
        this.contexts = builder.contexts;
        this.description = builder.description;
        this.title = builder.title;
    }

    /**
     * <p>
     * The <code>CreateEngagementRequest$Catalog</code> parameter specifies the catalog related to the engagement.
     * Accepted values are <code>AWS</code> and <code>Sandbox</code>, which determine the environment in which the
     * engagement is managed.
     * </p>
     * 
     * @return The <code>CreateEngagementRequest$Catalog</code> parameter specifies the catalog related to the
     *         engagement. Accepted values are <code>AWS</code> and <code>Sandbox</code>, which determine the
     *         environment in which the engagement is managed.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The <code>CreateEngagementRequest$ClientToken</code> parameter specifies a unique, case-sensitive identifier to
     * ensure that the request is handled exactly once. The value must not exceed sixty-four alphanumeric characters.
     * </p>
     * 
     * @return The <code>CreateEngagementRequest$ClientToken</code> parameter specifies a unique, case-sensitive
     *         identifier to ensure that the request is handled exactly once. The value must not exceed sixty-four
     *         alphanumeric characters.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Contexts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContexts() {
        return contexts != null && !(contexts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <code>Contexts</code> field is a required array of objects, with a maximum of 5 contexts allowed, specifying
     * detailed information about customer projects associated with the Engagement. Each context object contains a
     * <code>Type</code> field indicating the context type, which must be <code>CustomerProject</code> in this version,
     * and a <code>Payload</code> field containing the <code>CustomerProject</code> details. The
     * <code>CustomerProject</code> object is composed of two main components: <code>Customer</code> and
     * <code>Project</code>. The <code>Customer</code> object includes information such as <code>CompanyName</code>,
     * <code>WebsiteUrl</code>, <code>Industry</code>, and <code>CountryCode</code>, providing essential details about
     * the customer. The <code>Project</code> object contains <code>Title</code>, <code>BusinessProblem</code>, and
     * <code>TargetCompletionDate</code>, offering insights into the specific project associated with the customer. This
     * structure allows comprehensive context to be included within the Engagement, facilitating effective collaboration
     * between parties by providing relevant customer and project information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContexts} method.
     * </p>
     * 
     * @return The <code>Contexts</code> field is a required array of objects, with a maximum of 5 contexts allowed,
     *         specifying detailed information about customer projects associated with the Engagement. Each context
     *         object contains a <code>Type</code> field indicating the context type, which must be
     *         <code>CustomerProject</code> in this version, and a <code>Payload</code> field containing the
     *         <code>CustomerProject</code> details. The <code>CustomerProject</code> object is composed of two main
     *         components: <code>Customer</code> and <code>Project</code>. The <code>Customer</code> object includes
     *         information such as <code>CompanyName</code>, <code>WebsiteUrl</code>, <code>Industry</code>, and
     *         <code>CountryCode</code>, providing essential details about the customer. The <code>Project</code> object
     *         contains <code>Title</code>, <code>BusinessProblem</code>, and <code>TargetCompletionDate</code>,
     *         offering insights into the specific project associated with the customer. This structure allows
     *         comprehensive context to be included within the Engagement, facilitating effective collaboration between
     *         parties by providing relevant customer and project information.
     */
    public final List<EngagementContextDetails> contexts() {
        return contexts;
    }

    /**
     * <p>
     * Provides a description of the <code>Engagement</code>.
     * </p>
     * 
     * @return Provides a description of the <code>Engagement</code>.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies the title of the <code>Engagement</code>.
     * </p>
     * 
     * @return Specifies the title of the <code>Engagement</code>.
     */
    public final String title() {
        return title;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasContexts() ? contexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEngagementRequest)) {
            return false;
        }
        CreateEngagementRequest other = (CreateEngagementRequest) obj;
        return Objects.equals(catalog(), other.catalog()) && Objects.equals(clientToken(), other.clientToken())
                && hasContexts() == other.hasContexts() && Objects.equals(contexts(), other.contexts())
                && Objects.equals(description(), other.description()) && Objects.equals(title(), other.title());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEngagementRequest").add("Catalog", catalog()).add("ClientToken", clientToken())
                .add("Contexts", hasContexts() ? contexts() : null).add("Description", description()).add("Title", title())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Contexts":
            return Optional.ofNullable(clazz.cast(contexts()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Contexts", CONTEXTS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Title", TITLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEngagementRequest, T> g) {
        return obj -> g.apply((CreateEngagementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PartnerCentralSellingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateEngagementRequest> {
        /**
         * <p>
         * The <code>CreateEngagementRequest$Catalog</code> parameter specifies the catalog related to the engagement.
         * Accepted values are <code>AWS</code> and <code>Sandbox</code>, which determine the environment in which the
         * engagement is managed.
         * </p>
         * 
         * @param catalog
         *        The <code>CreateEngagementRequest$Catalog</code> parameter specifies the catalog related to the
         *        engagement. Accepted values are <code>AWS</code> and <code>Sandbox</code>, which determine the
         *        environment in which the engagement is managed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The <code>CreateEngagementRequest$ClientToken</code> parameter specifies a unique, case-sensitive identifier
         * to ensure that the request is handled exactly once. The value must not exceed sixty-four alphanumeric
         * characters.
         * </p>
         * 
         * @param clientToken
         *        The <code>CreateEngagementRequest$ClientToken</code> parameter specifies a unique, case-sensitive
         *        identifier to ensure that the request is handled exactly once. The value must not exceed sixty-four
         *        alphanumeric characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The <code>Contexts</code> field is a required array of objects, with a maximum of 5 contexts allowed,
         * specifying detailed information about customer projects associated with the Engagement. Each context object
         * contains a <code>Type</code> field indicating the context type, which must be <code>CustomerProject</code> in
         * this version, and a <code>Payload</code> field containing the <code>CustomerProject</code> details. The
         * <code>CustomerProject</code> object is composed of two main components: <code>Customer</code> and
         * <code>Project</code>. The <code>Customer</code> object includes information such as <code>CompanyName</code>,
         * <code>WebsiteUrl</code>, <code>Industry</code>, and <code>CountryCode</code>, providing essential details
         * about the customer. The <code>Project</code> object contains <code>Title</code>, <code>BusinessProblem</code>
         * , and <code>TargetCompletionDate</code>, offering insights into the specific project associated with the
         * customer. This structure allows comprehensive context to be included within the Engagement, facilitating
         * effective collaboration between parties by providing relevant customer and project information.
         * </p>
         * 
         * @param contexts
         *        The <code>Contexts</code> field is a required array of objects, with a maximum of 5 contexts allowed,
         *        specifying detailed information about customer projects associated with the Engagement. Each context
         *        object contains a <code>Type</code> field indicating the context type, which must be
         *        <code>CustomerProject</code> in this version, and a <code>Payload</code> field containing the
         *        <code>CustomerProject</code> details. The <code>CustomerProject</code> object is composed of two main
         *        components: <code>Customer</code> and <code>Project</code>. The <code>Customer</code> object includes
         *        information such as <code>CompanyName</code>, <code>WebsiteUrl</code>, <code>Industry</code>, and
         *        <code>CountryCode</code>, providing essential details about the customer. The <code>Project</code>
         *        object contains <code>Title</code>, <code>BusinessProblem</code>, and
         *        <code>TargetCompletionDate</code>, offering insights into the specific project associated with the
         *        customer. This structure allows comprehensive context to be included within the Engagement,
         *        facilitating effective collaboration between parties by providing relevant customer and project
         *        information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contexts(Collection<EngagementContextDetails> contexts);

        /**
         * <p>
         * The <code>Contexts</code> field is a required array of objects, with a maximum of 5 contexts allowed,
         * specifying detailed information about customer projects associated with the Engagement. Each context object
         * contains a <code>Type</code> field indicating the context type, which must be <code>CustomerProject</code> in
         * this version, and a <code>Payload</code> field containing the <code>CustomerProject</code> details. The
         * <code>CustomerProject</code> object is composed of two main components: <code>Customer</code> and
         * <code>Project</code>. The <code>Customer</code> object includes information such as <code>CompanyName</code>,
         * <code>WebsiteUrl</code>, <code>Industry</code>, and <code>CountryCode</code>, providing essential details
         * about the customer. The <code>Project</code> object contains <code>Title</code>, <code>BusinessProblem</code>
         * , and <code>TargetCompletionDate</code>, offering insights into the specific project associated with the
         * customer. This structure allows comprehensive context to be included within the Engagement, facilitating
         * effective collaboration between parties by providing relevant customer and project information.
         * </p>
         * 
         * @param contexts
         *        The <code>Contexts</code> field is a required array of objects, with a maximum of 5 contexts allowed,
         *        specifying detailed information about customer projects associated with the Engagement. Each context
         *        object contains a <code>Type</code> field indicating the context type, which must be
         *        <code>CustomerProject</code> in this version, and a <code>Payload</code> field containing the
         *        <code>CustomerProject</code> details. The <code>CustomerProject</code> object is composed of two main
         *        components: <code>Customer</code> and <code>Project</code>. The <code>Customer</code> object includes
         *        information such as <code>CompanyName</code>, <code>WebsiteUrl</code>, <code>Industry</code>, and
         *        <code>CountryCode</code>, providing essential details about the customer. The <code>Project</code>
         *        object contains <code>Title</code>, <code>BusinessProblem</code>, and
         *        <code>TargetCompletionDate</code>, offering insights into the specific project associated with the
         *        customer. This structure allows comprehensive context to be included within the Engagement,
         *        facilitating effective collaboration between parties by providing relevant customer and project
         *        information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contexts(EngagementContextDetails... contexts);

        /**
         * <p>
         * The <code>Contexts</code> field is a required array of objects, with a maximum of 5 contexts allowed,
         * specifying detailed information about customer projects associated with the Engagement. Each context object
         * contains a <code>Type</code> field indicating the context type, which must be <code>CustomerProject</code> in
         * this version, and a <code>Payload</code> field containing the <code>CustomerProject</code> details. The
         * <code>CustomerProject</code> object is composed of two main components: <code>Customer</code> and
         * <code>Project</code>. The <code>Customer</code> object includes information such as <code>CompanyName</code>,
         * <code>WebsiteUrl</code>, <code>Industry</code>, and <code>CountryCode</code>, providing essential details
         * about the customer. The <code>Project</code> object contains <code>Title</code>, <code>BusinessProblem</code>
         * , and <code>TargetCompletionDate</code>, offering insights into the specific project associated with the
         * customer. This structure allows comprehensive context to be included within the Engagement, facilitating
         * effective collaboration between parties by providing relevant customer and project information.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.EngagementContextDetails.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.partnercentralselling.model.EngagementContextDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.EngagementContextDetails.Builder#build()}
         * is called immediately and its result is passed to {@link #contexts(List<EngagementContextDetails>)}.
         * 
         * @param contexts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.EngagementContextDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contexts(java.util.Collection<EngagementContextDetails>)
         */
        Builder contexts(Consumer<EngagementContextDetails.Builder>... contexts);

        /**
         * <p>
         * Provides a description of the <code>Engagement</code>.
         * </p>
         * 
         * @param description
         *        Provides a description of the <code>Engagement</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies the title of the <code>Engagement</code>.
         * </p>
         * 
         * @param title
         *        Specifies the title of the <code>Engagement</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralSellingRequest.BuilderImpl implements Builder {
        private String catalog;

        private String clientToken;

        private List<EngagementContextDetails> contexts = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String title;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEngagementRequest model) {
            super(model);
            catalog(model.catalog);
            clientToken(model.clientToken);
            contexts(model.contexts);
            description(model.description);
            title(model.title);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<EngagementContextDetails.Builder> getContexts() {
            List<EngagementContextDetails.Builder> result = EngagementContextsCopier.copyToBuilder(this.contexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContexts(Collection<EngagementContextDetails.BuilderImpl> contexts) {
            this.contexts = EngagementContextsCopier.copyFromBuilder(contexts);
        }

        @Override
        public final Builder contexts(Collection<EngagementContextDetails> contexts) {
            this.contexts = EngagementContextsCopier.copy(contexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contexts(EngagementContextDetails... contexts) {
            contexts(Arrays.asList(contexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contexts(Consumer<EngagementContextDetails.Builder>... contexts) {
            contexts(Stream.of(contexts).map(c -> EngagementContextDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEngagementRequest build() {
            return new CreateEngagementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
