/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOpportunityResponse extends PartnerCentralSellingResponse implements
        ToCopyableBuilder<CreateOpportunityResponse.Builder, CreateOpportunityResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(CreateOpportunityResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedDate")
            .getter(getter(CreateOpportunityResponse::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> PARTNER_OPPORTUNITY_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PartnerOpportunityIdentifier")
            .getter(getter(CreateOpportunityResponse::partnerOpportunityIdentifier))
            .setter(setter(Builder::partnerOpportunityIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerOpportunityIdentifier")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            LAST_MODIFIED_DATE_FIELD, PARTNER_OPPORTUNITY_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final Instant lastModifiedDate;

    private final String partnerOpportunityIdentifier;

    private CreateOpportunityResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.partnerOpportunityIdentifier = builder.partnerOpportunityIdentifier;
    }

    /**
     * <p>
     * Read-only, system-generated <code>Opportunity</code> unique identifier. Amazon Web Services creates this
     * identifier, and it's used for all subsequent opportunity actions, such as updates, associations, and submissions.
     * It helps to ensure that each opportunity is accurately tracked and managed.
     * </p>
     * 
     * @return Read-only, system-generated <code>Opportunity</code> unique identifier. Amazon Web Services creates this
     *         identifier, and it's used for all subsequent opportunity actions, such as updates, associations, and
     *         submissions. It helps to ensure that each opportunity is accurately tracked and managed.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * <code>DateTime</code> when the opportunity was last modified. When the <code>Opportunity</code> is created, its
     * value is <code>CreatedDate</code>.
     * </p>
     * 
     * @return <code>DateTime</code> when the opportunity was last modified. When the <code>Opportunity</code> is
     *         created, its value is <code>CreatedDate</code>.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * Specifies the opportunity's unique identifier in the partner's CRM system. This value is essential to track and
     * reconcile because it's included in the outbound payload sent back to the partner.
     * </p>
     * 
     * @return Specifies the opportunity's unique identifier in the partner's CRM system. This value is essential to
     *         track and reconcile because it's included in the outbound payload sent back to the partner.
     */
    public final String partnerOpportunityIdentifier() {
        return partnerOpportunityIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(partnerOpportunityIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOpportunityResponse)) {
            return false;
        }
        CreateOpportunityResponse other = (CreateOpportunityResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(partnerOpportunityIdentifier(), other.partnerOpportunityIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateOpportunityResponse").add("Id", id()).add("LastModifiedDate", lastModifiedDate())
                .add("PartnerOpportunityIdentifier", partnerOpportunityIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "PartnerOpportunityIdentifier":
            return Optional.ofNullable(clazz.cast(partnerOpportunityIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("PartnerOpportunityIdentifier", PARTNER_OPPORTUNITY_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateOpportunityResponse, T> g) {
        return obj -> g.apply((CreateOpportunityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PartnerCentralSellingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateOpportunityResponse> {
        /**
         * <p>
         * Read-only, system-generated <code>Opportunity</code> unique identifier. Amazon Web Services creates this
         * identifier, and it's used for all subsequent opportunity actions, such as updates, associations, and
         * submissions. It helps to ensure that each opportunity is accurately tracked and managed.
         * </p>
         * 
         * @param id
         *        Read-only, system-generated <code>Opportunity</code> unique identifier. Amazon Web Services creates
         *        this identifier, and it's used for all subsequent opportunity actions, such as updates, associations,
         *        and submissions. It helps to ensure that each opportunity is accurately tracked and managed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * <code>DateTime</code> when the opportunity was last modified. When the <code>Opportunity</code> is created,
         * its value is <code>CreatedDate</code>.
         * </p>
         * 
         * @param lastModifiedDate
         *        <code>DateTime</code> when the opportunity was last modified. When the <code>Opportunity</code> is
         *        created, its value is <code>CreatedDate</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * Specifies the opportunity's unique identifier in the partner's CRM system. This value is essential to track
         * and reconcile because it's included in the outbound payload sent back to the partner.
         * </p>
         * 
         * @param partnerOpportunityIdentifier
         *        Specifies the opportunity's unique identifier in the partner's CRM system. This value is essential to
         *        track and reconcile because it's included in the outbound payload sent back to the partner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnerOpportunityIdentifier(String partnerOpportunityIdentifier);
    }

    static final class BuilderImpl extends PartnerCentralSellingResponse.BuilderImpl implements Builder {
        private String id;

        private Instant lastModifiedDate;

        private String partnerOpportunityIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOpportunityResponse model) {
            super(model);
            id(model.id);
            lastModifiedDate(model.lastModifiedDate);
            partnerOpportunityIdentifier(model.partnerOpportunityIdentifier);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getPartnerOpportunityIdentifier() {
            return partnerOpportunityIdentifier;
        }

        public final void setPartnerOpportunityIdentifier(String partnerOpportunityIdentifier) {
            this.partnerOpportunityIdentifier = partnerOpportunityIdentifier;
        }

        @Override
        public final Builder partnerOpportunityIdentifier(String partnerOpportunityIdentifier) {
            this.partnerOpportunityIdentifier = partnerOpportunityIdentifier;
            return this;
        }

        @Override
        public CreateOpportunityResponse build() {
            return new CreateOpportunityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
