/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResourceSnapshotJobRequest extends PartnerCentralSellingRequest implements
        ToCopyableBuilder<CreateResourceSnapshotJobRequest.Builder, CreateResourceSnapshotJobRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(CreateResourceSnapshotJobRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateResourceSnapshotJobRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ENGAGEMENT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngagementIdentifier").getter(getter(CreateResourceSnapshotJobRequest::engagementIdentifier))
            .setter(setter(Builder::engagementIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementIdentifier").build())
            .build();

    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceIdentifier").getter(getter(CreateResourceSnapshotJobRequest::resourceIdentifier))
            .setter(setter(Builder::resourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build())
            .build();

    private static final SdkField<String> RESOURCE_SNAPSHOT_TEMPLATE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceSnapshotTemplateIdentifier")
            .getter(getter(CreateResourceSnapshotJobRequest::resourceSnapshotTemplateIdentifier))
            .setter(setter(Builder::resourceSnapshotTemplateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSnapshotTemplateIdentifier")
                    .build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(CreateResourceSnapshotJobRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateResourceSnapshotJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            CLIENT_TOKEN_FIELD, ENGAGEMENT_IDENTIFIER_FIELD, RESOURCE_IDENTIFIER_FIELD,
            RESOURCE_SNAPSHOT_TEMPLATE_IDENTIFIER_FIELD, RESOURCE_TYPE_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final String clientToken;

    private final String engagementIdentifier;

    private final String resourceIdentifier;

    private final String resourceSnapshotTemplateIdentifier;

    private final String resourceType;

    private final List<Tag> tags;

    private CreateResourceSnapshotJobRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.clientToken = builder.clientToken;
        this.engagementIdentifier = builder.engagementIdentifier;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.resourceSnapshotTemplateIdentifier = builder.resourceSnapshotTemplateIdentifier;
        this.resourceType = builder.resourceType;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Specifies the catalog in which to create the snapshot job. Valid values are <code>AWS</code> and
     * <code> Sandbox</code>.
     * </p>
     * 
     * @return Specifies the catalog in which to create the snapshot job. Valid values are <code>AWS</code> and
     *         <code> Sandbox</code>.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * A client-generated UUID used for idempotency check. The token helps prevent duplicate job creations.
     * </p>
     * 
     * @return A client-generated UUID used for idempotency check. The token helps prevent duplicate job creations.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Specifies the identifier of the engagement associated with the resource to be snapshotted.
     * </p>
     * 
     * @return Specifies the identifier of the engagement associated with the resource to be snapshotted.
     */
    public final String engagementIdentifier() {
        return engagementIdentifier;
    }

    /**
     * <p>
     * Specifies the identifier of the specific resource to be snapshotted. The format depends on the
     * <code> ResourceType</code>.
     * </p>
     * 
     * @return Specifies the identifier of the specific resource to be snapshotted. The format depends on the
     *         <code> ResourceType</code>.
     */
    public final String resourceIdentifier() {
        return resourceIdentifier;
    }

    /**
     * <p>
     * Specifies the name of the template that defines the schema for the snapshot.
     * </p>
     * 
     * @return Specifies the name of the template that defines the schema for the snapshot.
     */
    public final String resourceSnapshotTemplateIdentifier() {
        return resourceSnapshotTemplateIdentifier;
    }

    /**
     * <p>
     * The type of resource for which the snapshot job is being created. Must be one of the supported resource types
     * i.e. <code>Opportunity</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource for which the snapshot job is being created. Must be one of the supported resource
     *         types i.e. <code>Opportunity</code>
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource for which the snapshot job is being created. Must be one of the supported resource types
     * i.e. <code>Opportunity</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource for which the snapshot job is being created. Must be one of the supported resource
     *         types i.e. <code>Opportunity</code>
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects specifying each tag name and value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of objects specifying each tag name and value.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(engagementIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(resourceSnapshotTemplateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceSnapshotJobRequest)) {
            return false;
        }
        CreateResourceSnapshotJobRequest other = (CreateResourceSnapshotJobRequest) obj;
        return Objects.equals(catalog(), other.catalog()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(engagementIdentifier(), other.engagementIdentifier())
                && Objects.equals(resourceIdentifier(), other.resourceIdentifier())
                && Objects.equals(resourceSnapshotTemplateIdentifier(), other.resourceSnapshotTemplateIdentifier())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateResourceSnapshotJobRequest").add("Catalog", catalog()).add("ClientToken", clientToken())
                .add("EngagementIdentifier", engagementIdentifier()).add("ResourceIdentifier", resourceIdentifier())
                .add("ResourceSnapshotTemplateIdentifier", resourceSnapshotTemplateIdentifier())
                .add("ResourceType", resourceTypeAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "EngagementIdentifier":
            return Optional.ofNullable(clazz.cast(engagementIdentifier()));
        case "ResourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        case "ResourceSnapshotTemplateIdentifier":
            return Optional.ofNullable(clazz.cast(resourceSnapshotTemplateIdentifier()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("EngagementIdentifier", ENGAGEMENT_IDENTIFIER_FIELD);
        map.put("ResourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        map.put("ResourceSnapshotTemplateIdentifier", RESOURCE_SNAPSHOT_TEMPLATE_IDENTIFIER_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceSnapshotJobRequest, T> g) {
        return obj -> g.apply((CreateResourceSnapshotJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PartnerCentralSellingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateResourceSnapshotJobRequest> {
        /**
         * <p>
         * Specifies the catalog in which to create the snapshot job. Valid values are <code>AWS</code> and
         * <code> Sandbox</code>.
         * </p>
         * 
         * @param catalog
         *        Specifies the catalog in which to create the snapshot job. Valid values are <code>AWS</code> and
         *        <code> Sandbox</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * A client-generated UUID used for idempotency check. The token helps prevent duplicate job creations.
         * </p>
         * 
         * @param clientToken
         *        A client-generated UUID used for idempotency check. The token helps prevent duplicate job creations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Specifies the identifier of the engagement associated with the resource to be snapshotted.
         * </p>
         * 
         * @param engagementIdentifier
         *        Specifies the identifier of the engagement associated with the resource to be snapshotted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementIdentifier(String engagementIdentifier);

        /**
         * <p>
         * Specifies the identifier of the specific resource to be snapshotted. The format depends on the
         * <code> ResourceType</code>.
         * </p>
         * 
         * @param resourceIdentifier
         *        Specifies the identifier of the specific resource to be snapshotted. The format depends on the
         *        <code> ResourceType</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);

        /**
         * <p>
         * Specifies the name of the template that defines the schema for the snapshot.
         * </p>
         * 
         * @param resourceSnapshotTemplateIdentifier
         *        Specifies the name of the template that defines the schema for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSnapshotTemplateIdentifier(String resourceSnapshotTemplateIdentifier);

        /**
         * <p>
         * The type of resource for which the snapshot job is being created. Must be one of the supported resource types
         * i.e. <code>Opportunity</code>
         * </p>
         * 
         * @param resourceType
         *        The type of resource for which the snapshot job is being created. Must be one of the supported
         *        resource types i.e. <code>Opportunity</code>
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource for which the snapshot job is being created. Must be one of the supported resource types
         * i.e. <code>Opportunity</code>
         * </p>
         * 
         * @param resourceType
         *        The type of resource for which the snapshot job is being created. Must be one of the supported
         *        resource types i.e. <code>Opportunity</code>
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * A list of objects specifying each tag name and value.
         * </p>
         * 
         * @param tags
         *        A list of objects specifying each tag name and value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of objects specifying each tag name and value.
         * </p>
         * 
         * @param tags
         *        A list of objects specifying each tag name and value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of objects specifying each tag name and value.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.Tag.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.partnercentralselling.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.Tag.Builder#build()} is called immediately
         * and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralSellingRequest.BuilderImpl implements Builder {
        private String catalog;

        private String clientToken;

        private String engagementIdentifier;

        private String resourceIdentifier;

        private String resourceSnapshotTemplateIdentifier;

        private String resourceType;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceSnapshotJobRequest model) {
            super(model);
            catalog(model.catalog);
            clientToken(model.clientToken);
            engagementIdentifier(model.engagementIdentifier);
            resourceIdentifier(model.resourceIdentifier);
            resourceSnapshotTemplateIdentifier(model.resourceSnapshotTemplateIdentifier);
            resourceType(model.resourceType);
            tags(model.tags);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getEngagementIdentifier() {
            return engagementIdentifier;
        }

        public final void setEngagementIdentifier(String engagementIdentifier) {
            this.engagementIdentifier = engagementIdentifier;
        }

        @Override
        public final Builder engagementIdentifier(String engagementIdentifier) {
            this.engagementIdentifier = engagementIdentifier;
            return this;
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getResourceSnapshotTemplateIdentifier() {
            return resourceSnapshotTemplateIdentifier;
        }

        public final void setResourceSnapshotTemplateIdentifier(String resourceSnapshotTemplateIdentifier) {
            this.resourceSnapshotTemplateIdentifier = resourceSnapshotTemplateIdentifier;
        }

        @Override
        public final Builder resourceSnapshotTemplateIdentifier(String resourceSnapshotTemplateIdentifier) {
            this.resourceSnapshotTemplateIdentifier = resourceSnapshotTemplateIdentifier;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourceSnapshotJobRequest build() {
            return new CreateResourceSnapshotJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
