/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResourceSnapshotRequest extends PartnerCentralSellingRequest implements
        ToCopyableBuilder<CreateResourceSnapshotRequest.Builder, CreateResourceSnapshotRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(CreateResourceSnapshotRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateResourceSnapshotRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ENGAGEMENT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngagementIdentifier").getter(getter(CreateResourceSnapshotRequest::engagementIdentifier))
            .setter(setter(Builder::engagementIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementIdentifier").build())
            .build();

    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceIdentifier").getter(getter(CreateResourceSnapshotRequest::resourceIdentifier))
            .setter(setter(Builder::resourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build())
            .build();

    private static final SdkField<String> RESOURCE_SNAPSHOT_TEMPLATE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceSnapshotTemplateIdentifier")
            .getter(getter(CreateResourceSnapshotRequest::resourceSnapshotTemplateIdentifier))
            .setter(setter(Builder::resourceSnapshotTemplateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSnapshotTemplateIdentifier")
                    .build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(CreateResourceSnapshotRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            CLIENT_TOKEN_FIELD, ENGAGEMENT_IDENTIFIER_FIELD, RESOURCE_IDENTIFIER_FIELD,
            RESOURCE_SNAPSHOT_TEMPLATE_IDENTIFIER_FIELD, RESOURCE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final String clientToken;

    private final String engagementIdentifier;

    private final String resourceIdentifier;

    private final String resourceSnapshotTemplateIdentifier;

    private final String resourceType;

    private CreateResourceSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.clientToken = builder.clientToken;
        this.engagementIdentifier = builder.engagementIdentifier;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.resourceSnapshotTemplateIdentifier = builder.resourceSnapshotTemplateIdentifier;
        this.resourceType = builder.resourceType;
    }

    /**
     * <p>
     * Specifies the catalog where the snapshot is created. Valid values are <code>AWS</code> and <code>Sandbox</code>.
     * </p>
     * 
     * @return Specifies the catalog where the snapshot is created. Valid values are <code>AWS</code> and
     *         <code>Sandbox</code>.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * Specifies a unique, client-generated UUID to ensure that the request is handled exactly once. This token helps
     * prevent duplicate snapshot creations.
     * </p>
     * 
     * @return Specifies a unique, client-generated UUID to ensure that the request is handled exactly once. This token
     *         helps prevent duplicate snapshot creations.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The unique identifier of the engagement associated with this snapshot. This field links the snapshot to a
     * specific engagement context.
     * </p>
     * 
     * @return The unique identifier of the engagement associated with this snapshot. This field links the snapshot to a
     *         specific engagement context.
     */
    public final String engagementIdentifier() {
        return engagementIdentifier;
    }

    /**
     * <p>
     * The unique identifier of the specific resource to be snapshotted. The format and constraints of this identifier
     * depend on the <code>ResourceType</code> specified. For example: For <code>Opportunity</code> type, it will be an
     * opportunity ID.
     * </p>
     * 
     * @return The unique identifier of the specific resource to be snapshotted. The format and constraints of this
     *         identifier depend on the <code>ResourceType</code> specified. For example: For <code>Opportunity</code>
     *         type, it will be an opportunity ID.
     */
    public final String resourceIdentifier() {
        return resourceIdentifier;
    }

    /**
     * <p>
     * The name of the template that defines the schema for the snapshot. This template determines which subset of the
     * resource data will be included in the snapshot. Must correspond to an existing and valid template for the
     * specified <code>ResourceType</code>.
     * </p>
     * 
     * @return The name of the template that defines the schema for the snapshot. This template determines which subset
     *         of the resource data will be included in the snapshot. Must correspond to an existing and valid template
     *         for the specified <code>ResourceType</code>.
     */
    public final String resourceSnapshotTemplateIdentifier() {
        return resourceSnapshotTemplateIdentifier;
    }

    /**
     * <p>
     * Specifies the type of resource for which the snapshot is being created. This field determines the structure and
     * content of the snapshot. Must be one of the supported resource types, such as: <code>Opportunity</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of resource for which the snapshot is being created. This field determines the
     *         structure and content of the snapshot. Must be one of the supported resource types, such as:
     *         <code>Opportunity</code>.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * Specifies the type of resource for which the snapshot is being created. This field determines the structure and
     * content of the snapshot. Must be one of the supported resource types, such as: <code>Opportunity</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of resource for which the snapshot is being created. This field determines the
     *         structure and content of the snapshot. Must be one of the supported resource types, such as:
     *         <code>Opportunity</code>.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(engagementIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(resourceSnapshotTemplateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceSnapshotRequest)) {
            return false;
        }
        CreateResourceSnapshotRequest other = (CreateResourceSnapshotRequest) obj;
        return Objects.equals(catalog(), other.catalog()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(engagementIdentifier(), other.engagementIdentifier())
                && Objects.equals(resourceIdentifier(), other.resourceIdentifier())
                && Objects.equals(resourceSnapshotTemplateIdentifier(), other.resourceSnapshotTemplateIdentifier())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateResourceSnapshotRequest").add("Catalog", catalog()).add("ClientToken", clientToken())
                .add("EngagementIdentifier", engagementIdentifier()).add("ResourceIdentifier", resourceIdentifier())
                .add("ResourceSnapshotTemplateIdentifier", resourceSnapshotTemplateIdentifier())
                .add("ResourceType", resourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "EngagementIdentifier":
            return Optional.ofNullable(clazz.cast(engagementIdentifier()));
        case "ResourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        case "ResourceSnapshotTemplateIdentifier":
            return Optional.ofNullable(clazz.cast(resourceSnapshotTemplateIdentifier()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("EngagementIdentifier", ENGAGEMENT_IDENTIFIER_FIELD);
        map.put("ResourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        map.put("ResourceSnapshotTemplateIdentifier", RESOURCE_SNAPSHOT_TEMPLATE_IDENTIFIER_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceSnapshotRequest, T> g) {
        return obj -> g.apply((CreateResourceSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PartnerCentralSellingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateResourceSnapshotRequest> {
        /**
         * <p>
         * Specifies the catalog where the snapshot is created. Valid values are <code>AWS</code> and
         * <code>Sandbox</code>.
         * </p>
         * 
         * @param catalog
         *        Specifies the catalog where the snapshot is created. Valid values are <code>AWS</code> and
         *        <code>Sandbox</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * Specifies a unique, client-generated UUID to ensure that the request is handled exactly once. This token
         * helps prevent duplicate snapshot creations.
         * </p>
         * 
         * @param clientToken
         *        Specifies a unique, client-generated UUID to ensure that the request is handled exactly once. This
         *        token helps prevent duplicate snapshot creations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The unique identifier of the engagement associated with this snapshot. This field links the snapshot to a
         * specific engagement context.
         * </p>
         * 
         * @param engagementIdentifier
         *        The unique identifier of the engagement associated with this snapshot. This field links the snapshot
         *        to a specific engagement context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementIdentifier(String engagementIdentifier);

        /**
         * <p>
         * The unique identifier of the specific resource to be snapshotted. The format and constraints of this
         * identifier depend on the <code>ResourceType</code> specified. For example: For <code>Opportunity</code> type,
         * it will be an opportunity ID.
         * </p>
         * 
         * @param resourceIdentifier
         *        The unique identifier of the specific resource to be snapshotted. The format and constraints of this
         *        identifier depend on the <code>ResourceType</code> specified. For example: For
         *        <code>Opportunity</code> type, it will be an opportunity ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);

        /**
         * <p>
         * The name of the template that defines the schema for the snapshot. This template determines which subset of
         * the resource data will be included in the snapshot. Must correspond to an existing and valid template for the
         * specified <code>ResourceType</code>.
         * </p>
         * 
         * @param resourceSnapshotTemplateIdentifier
         *        The name of the template that defines the schema for the snapshot. This template determines which
         *        subset of the resource data will be included in the snapshot. Must correspond to an existing and valid
         *        template for the specified <code>ResourceType</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSnapshotTemplateIdentifier(String resourceSnapshotTemplateIdentifier);

        /**
         * <p>
         * Specifies the type of resource for which the snapshot is being created. This field determines the structure
         * and content of the snapshot. Must be one of the supported resource types, such as: <code>Opportunity</code>.
         * </p>
         * 
         * @param resourceType
         *        Specifies the type of resource for which the snapshot is being created. This field determines the
         *        structure and content of the snapshot. Must be one of the supported resource types, such as:
         *        <code>Opportunity</code>.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Specifies the type of resource for which the snapshot is being created. This field determines the structure
         * and content of the snapshot. Must be one of the supported resource types, such as: <code>Opportunity</code>.
         * </p>
         * 
         * @param resourceType
         *        Specifies the type of resource for which the snapshot is being created. This field determines the
         *        structure and content of the snapshot. Must be one of the supported resource types, such as:
         *        <code>Opportunity</code>.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralSellingRequest.BuilderImpl implements Builder {
        private String catalog;

        private String clientToken;

        private String engagementIdentifier;

        private String resourceIdentifier;

        private String resourceSnapshotTemplateIdentifier;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceSnapshotRequest model) {
            super(model);
            catalog(model.catalog);
            clientToken(model.clientToken);
            engagementIdentifier(model.engagementIdentifier);
            resourceIdentifier(model.resourceIdentifier);
            resourceSnapshotTemplateIdentifier(model.resourceSnapshotTemplateIdentifier);
            resourceType(model.resourceType);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getEngagementIdentifier() {
            return engagementIdentifier;
        }

        public final void setEngagementIdentifier(String engagementIdentifier) {
            this.engagementIdentifier = engagementIdentifier;
        }

        @Override
        public final Builder engagementIdentifier(String engagementIdentifier) {
            this.engagementIdentifier = engagementIdentifier;
            return this;
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getResourceSnapshotTemplateIdentifier() {
            return resourceSnapshotTemplateIdentifier;
        }

        public final void setResourceSnapshotTemplateIdentifier(String resourceSnapshotTemplateIdentifier) {
            this.resourceSnapshotTemplateIdentifier = resourceSnapshotTemplateIdentifier;
        }

        @Override
        public final Builder resourceSnapshotTemplateIdentifier(String resourceSnapshotTemplateIdentifier) {
            this.resourceSnapshotTemplateIdentifier = resourceSnapshotTemplateIdentifier;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourceSnapshotRequest build() {
            return new CreateResourceSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
