/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum CurrencyCode {
    USD("USD"),

    EUR("EUR"),

    GBP("GBP"),

    AUD("AUD"),

    CAD("CAD"),

    CNY("CNY"),

    NZD("NZD"),

    INR("INR"),

    JPY("JPY"),

    CHF("CHF"),

    SEK("SEK"),

    AED("AED"),

    AFN("AFN"),

    ALL("ALL"),

    AMD("AMD"),

    ANG("ANG"),

    AOA("AOA"),

    ARS("ARS"),

    AWG("AWG"),

    AZN("AZN"),

    BAM("BAM"),

    BBD("BBD"),

    BDT("BDT"),

    BGN("BGN"),

    BHD("BHD"),

    BIF("BIF"),

    BMD("BMD"),

    BND("BND"),

    BOB("BOB"),

    BOV("BOV"),

    BRL("BRL"),

    BSD("BSD"),

    BTN("BTN"),

    BWP("BWP"),

    BYN("BYN"),

    BZD("BZD"),

    CDF("CDF"),

    CHE("CHE"),

    CHW("CHW"),

    CLF("CLF"),

    CLP("CLP"),

    COP("COP"),

    COU("COU"),

    CRC("CRC"),

    CUC("CUC"),

    CUP("CUP"),

    CVE("CVE"),

    CZK("CZK"),

    DJF("DJF"),

    DKK("DKK"),

    DOP("DOP"),

    DZD("DZD"),

    EGP("EGP"),

    ERN("ERN"),

    ETB("ETB"),

    FJD("FJD"),

    FKP("FKP"),

    GEL("GEL"),

    GHS("GHS"),

    GIP("GIP"),

    GMD("GMD"),

    GNF("GNF"),

    GTQ("GTQ"),

    GYD("GYD"),

    HKD("HKD"),

    HNL("HNL"),

    HRK("HRK"),

    HTG("HTG"),

    HUF("HUF"),

    IDR("IDR"),

    ILS("ILS"),

    IQD("IQD"),

    IRR("IRR"),

    ISK("ISK"),

    JMD("JMD"),

    JOD("JOD"),

    KES("KES"),

    KGS("KGS"),

    KHR("KHR"),

    KMF("KMF"),

    KPW("KPW"),

    KRW("KRW"),

    KWD("KWD"),

    KYD("KYD"),

    KZT("KZT"),

    LAK("LAK"),

    LBP("LBP"),

    LKR("LKR"),

    LRD("LRD"),

    LSL("LSL"),

    LYD("LYD"),

    MAD("MAD"),

    MDL("MDL"),

    MGA("MGA"),

    MKD("MKD"),

    MMK("MMK"),

    MNT("MNT"),

    MOP("MOP"),

    MRU("MRU"),

    MUR("MUR"),

    MVR("MVR"),

    MWK("MWK"),

    MXN("MXN"),

    MXV("MXV"),

    MYR("MYR"),

    MZN("MZN"),

    NAD("NAD"),

    NGN("NGN"),

    NIO("NIO"),

    NOK("NOK"),

    NPR("NPR"),

    OMR("OMR"),

    PAB("PAB"),

    PEN("PEN"),

    PGK("PGK"),

    PHP("PHP"),

    PKR("PKR"),

    PLN("PLN"),

    PYG("PYG"),

    QAR("QAR"),

    RON("RON"),

    RSD("RSD"),

    RUB("RUB"),

    RWF("RWF"),

    SAR("SAR"),

    SBD("SBD"),

    SCR("SCR"),

    SDG("SDG"),

    SGD("SGD"),

    SHP("SHP"),

    SLL("SLL"),

    SOS("SOS"),

    SRD("SRD"),

    SSP("SSP"),

    STN("STN"),

    SVC("SVC"),

    SYP("SYP"),

    SZL("SZL"),

    THB("THB"),

    TJS("TJS"),

    TMT("TMT"),

    TND("TND"),

    TOP("TOP"),

    TRY("TRY"),

    TTD("TTD"),

    TWD("TWD"),

    TZS("TZS"),

    UAH("UAH"),

    UGX("UGX"),

    USN("USN"),

    UYI("UYI"),

    UYU("UYU"),

    UZS("UZS"),

    VEF("VEF"),

    VND("VND"),

    VUV("VUV"),

    WST("WST"),

    XAF("XAF"),

    XCD("XCD"),

    XDR("XDR"),

    XOF("XOF"),

    XPF("XPF"),

    XSU("XSU"),

    XUA("XUA"),

    YER("YER"),

    ZAR("ZAR"),

    ZMW("ZMW"),

    ZWL("ZWL"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CurrencyCode> VALUE_MAP = EnumUtils.uniqueIndex(CurrencyCode.class, CurrencyCode::toString);

    private final String value;

    private CurrencyCode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return CurrencyCode corresponding to the value
     */
    public static CurrencyCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link CurrencyCode}s
     */
    public static Set<CurrencyCode> knownValues() {
        Set<CurrencyCode> knownValues = EnumSet.allOf(CurrencyCode.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
