/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the payload of an Engagement context. The structure of this payload varies based on the context type
 * specified in the EngagementContextDetails.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EngagementContextPayload implements SdkPojo, Serializable,
        ToCopyableBuilder<EngagementContextPayload.Builder, EngagementContextPayload> {
    private static final SdkField<CustomerProjectsContext> CUSTOMER_PROJECT_FIELD = SdkField
            .<CustomerProjectsContext> builder(MarshallingType.SDK_POJO).memberName("CustomerProject")
            .getter(getter(EngagementContextPayload::customerProject)).setter(setter(Builder::customerProject))
            .constructor(CustomerProjectsContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerProject").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_PROJECT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CustomerProjectsContext customerProject;

    private final Type type;

    private EngagementContextPayload(BuilderImpl builder) {
        this.customerProject = builder.customerProject;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains detailed information about a customer project when the context type is "CustomerProject". This field is
     * present only when the Type in EngagementContextDetails is set to "CustomerProject".
     * </p>
     * 
     * @return Contains detailed information about a customer project when the context type is "CustomerProject". This
     *         field is present only when the Type in EngagementContextDetails is set to "CustomerProject".
     */
    public final CustomerProjectsContext customerProject() {
        return customerProject;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customerProject());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngagementContextPayload)) {
            return false;
        }
        EngagementContextPayload other = (EngagementContextPayload) obj;
        return Objects.equals(customerProject(), other.customerProject());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EngagementContextPayload").add("CustomerProject", customerProject()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomerProject":
            return Optional.ofNullable(clazz.cast(customerProject()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #customerProject()} initialized to the given value.
     *
     * <p>
     * Contains detailed information about a customer project when the context type is "CustomerProject". This field is
     * present only when the Type in EngagementContextDetails is set to "CustomerProject".
     * </p>
     * 
     * @param customerProject
     *        Contains detailed information about a customer project when the context type is "CustomerProject". This
     *        field is present only when the Type in EngagementContextDetails is set to "CustomerProject".
     */
    public static EngagementContextPayload fromCustomerProject(CustomerProjectsContext customerProject) {
        return builder().customerProject(customerProject).build();
    }

    /**
     * Create an instance of this class with {@link #customerProject()} initialized to the given value.
     *
     * <p>
     * Contains detailed information about a customer project when the context type is "CustomerProject". This field is
     * present only when the Type in EngagementContextDetails is set to "CustomerProject".
     * </p>
     * 
     * @param customerProject
     *        Contains detailed information about a customer project when the context type is "CustomerProject". This
     *        field is present only when the Type in EngagementContextDetails is set to "CustomerProject".
     */
    public static EngagementContextPayload fromCustomerProject(Consumer<CustomerProjectsContext.Builder> customerProject) {
        CustomerProjectsContext.Builder builder = CustomerProjectsContext.builder();
        customerProject.accept(builder);
        return fromCustomerProject(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CustomerProject", CUSTOMER_PROJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EngagementContextPayload, T> g) {
        return obj -> g.apply((EngagementContextPayload) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EngagementContextPayload> {
        /**
         * <p>
         * Contains detailed information about a customer project when the context type is "CustomerProject". This field
         * is present only when the Type in EngagementContextDetails is set to "CustomerProject".
         * </p>
         * 
         * @param customerProject
         *        Contains detailed information about a customer project when the context type is "CustomerProject".
         *        This field is present only when the Type in EngagementContextDetails is set to "CustomerProject".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerProject(CustomerProjectsContext customerProject);

        /**
         * <p>
         * Contains detailed information about a customer project when the context type is "CustomerProject". This field
         * is present only when the Type in EngagementContextDetails is set to "CustomerProject".
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomerProjectsContext.Builder} avoiding
         * the need to create one manually via {@link CustomerProjectsContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomerProjectsContext.Builder#build()} is called immediately
         * and its result is passed to {@link #customerProject(CustomerProjectsContext)}.
         * 
         * @param customerProject
         *        a consumer that will call methods on {@link CustomerProjectsContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerProject(CustomerProjectsContext)
         */
        default Builder customerProject(Consumer<CustomerProjectsContext.Builder> customerProject) {
            return customerProject(CustomerProjectsContext.builder().applyMutation(customerProject).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CustomerProjectsContext customerProject;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EngagementContextPayload model) {
            customerProject(model.customerProject);
        }

        public final CustomerProjectsContext.Builder getCustomerProject() {
            return customerProject != null ? customerProject.toBuilder() : null;
        }

        public final void setCustomerProject(CustomerProjectsContext.BuilderImpl customerProject) {
            Object oldValue = this.customerProject;
            this.customerProject = customerProject != null ? customerProject.build() : null;
            handleUnionValueChange(Type.CUSTOMER_PROJECT, oldValue, this.customerProject);
        }

        @Override
        public final Builder customerProject(CustomerProjectsContext customerProject) {
            Object oldValue = this.customerProject;
            this.customerProject = customerProject;
            handleUnionValueChange(Type.CUSTOMER_PROJECT, oldValue, this.customerProject);
            return this;
        }

        @Override
        public EngagementContextPayload build() {
            return new EngagementContextPayload(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EngagementContextPayload#type()
     */
    public enum Type {
        CUSTOMER_PROJECT,

        UNKNOWN_TO_SDK_VERSION
    }
}
