/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides comprehensive details about a customer project associated with an Engagement. This may include information
 * such as project goals, timelines, and specific customer requirements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EngagementCustomerProjectDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<EngagementCustomerProjectDetails.Builder, EngagementCustomerProjectDetails> {
    private static final SdkField<String> BUSINESS_PROBLEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BusinessProblem").getter(getter(EngagementCustomerProjectDetails::businessProblem))
            .setter(setter(Builder::businessProblem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessProblem").build()).build();

    private static final SdkField<String> TARGET_COMPLETION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetCompletionDate").getter(getter(EngagementCustomerProjectDetails::targetCompletionDate))
            .setter(setter(Builder::targetCompletionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCompletionDate").build())
            .build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(EngagementCustomerProjectDetails::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUSINESS_PROBLEM_FIELD,
            TARGET_COMPLETION_DATE_FIELD, TITLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String businessProblem;

    private final String targetCompletionDate;

    private final String title;

    private EngagementCustomerProjectDetails(BuilderImpl builder) {
        this.businessProblem = builder.businessProblem;
        this.targetCompletionDate = builder.targetCompletionDate;
        this.title = builder.title;
    }

    /**
     * <p>
     * A description of the business problem the project aims to solve.
     * </p>
     * 
     * @return A description of the business problem the project aims to solve.
     */
    public final String businessProblem() {
        return businessProblem;
    }

    /**
     * <p>
     * The target completion date for the customer's project.
     * </p>
     * 
     * @return The target completion date for the customer's project.
     */
    public final String targetCompletionDate() {
        return targetCompletionDate;
    }

    /**
     * <p>
     * The title of the project.
     * </p>
     * 
     * @return The title of the project.
     */
    public final String title() {
        return title;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(businessProblem());
        hashCode = 31 * hashCode + Objects.hashCode(targetCompletionDate());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngagementCustomerProjectDetails)) {
            return false;
        }
        EngagementCustomerProjectDetails other = (EngagementCustomerProjectDetails) obj;
        return Objects.equals(businessProblem(), other.businessProblem())
                && Objects.equals(targetCompletionDate(), other.targetCompletionDate()) && Objects.equals(title(), other.title());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EngagementCustomerProjectDetails")
                .add("BusinessProblem", businessProblem() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TargetCompletionDate", targetCompletionDate()).add("Title", title()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BusinessProblem":
            return Optional.ofNullable(clazz.cast(businessProblem()));
        case "TargetCompletionDate":
            return Optional.ofNullable(clazz.cast(targetCompletionDate()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BusinessProblem", BUSINESS_PROBLEM_FIELD);
        map.put("TargetCompletionDate", TARGET_COMPLETION_DATE_FIELD);
        map.put("Title", TITLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EngagementCustomerProjectDetails, T> g) {
        return obj -> g.apply((EngagementCustomerProjectDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EngagementCustomerProjectDetails> {
        /**
         * <p>
         * A description of the business problem the project aims to solve.
         * </p>
         * 
         * @param businessProblem
         *        A description of the business problem the project aims to solve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessProblem(String businessProblem);

        /**
         * <p>
         * The target completion date for the customer's project.
         * </p>
         * 
         * @param targetCompletionDate
         *        The target completion date for the customer's project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCompletionDate(String targetCompletionDate);

        /**
         * <p>
         * The title of the project.
         * </p>
         * 
         * @param title
         *        The title of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);
    }

    static final class BuilderImpl implements Builder {
        private String businessProblem;

        private String targetCompletionDate;

        private String title;

        private BuilderImpl() {
        }

        private BuilderImpl(EngagementCustomerProjectDetails model) {
            businessProblem(model.businessProblem);
            targetCompletionDate(model.targetCompletionDate);
            title(model.title);
        }

        public final String getBusinessProblem() {
            return businessProblem;
        }

        public final void setBusinessProblem(String businessProblem) {
            this.businessProblem = businessProblem;
        }

        @Override
        public final Builder businessProblem(String businessProblem) {
            this.businessProblem = businessProblem;
            return this;
        }

        public final String getTargetCompletionDate() {
            return targetCompletionDate;
        }

        public final void setTargetCompletionDate(String targetCompletionDate) {
            this.targetCompletionDate = targetCompletionDate;
        }

        @Override
        public final Builder targetCompletionDate(String targetCompletionDate) {
            this.targetCompletionDate = targetCompletionDate;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        @Override
        public EngagementCustomerProjectDetails build() {
            return new EngagementCustomerProjectDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
