/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summarized view of the Engagement Invitation, including details like the identifier, status, and sender.
 * This summary helps partners track and manage AWS originated opportunities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EngagementInvitationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EngagementInvitationSummary.Builder, EngagementInvitationSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(EngagementInvitationSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(EngagementInvitationSummary::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> ENGAGEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngagementId").getter(getter(EngagementInvitationSummary::engagementId))
            .setter(setter(Builder::engagementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementId").build()).build();

    private static final SdkField<String> ENGAGEMENT_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngagementTitle").getter(getter(EngagementInvitationSummary::engagementTitle))
            .setter(setter(Builder::engagementTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementTitle").build()).build();

    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpirationDate")
            .getter(getter(EngagementInvitationSummary::expirationDate))
            .setter(setter(Builder::expirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(EngagementInvitationSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Instant> INVITATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("InvitationDate")
            .getter(getter(EngagementInvitationSummary::invitationDate))
            .setter(setter(Builder::invitationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvitationDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> PARTICIPANT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantType").getter(getter(EngagementInvitationSummary::participantTypeAsString))
            .setter(setter(Builder::participantType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantType").build()).build();

    private static final SdkField<String> PAYLOAD_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PayloadType").getter(getter(EngagementInvitationSummary::payloadTypeAsString))
            .setter(setter(Builder::payloadType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PayloadType").build()).build();

    private static final SdkField<Receiver> RECEIVER_FIELD = SdkField.<Receiver> builder(MarshallingType.SDK_POJO)
            .memberName("Receiver").getter(getter(EngagementInvitationSummary::receiver)).setter(setter(Builder::receiver))
            .constructor(Receiver::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Receiver").build()).build();

    private static final SdkField<String> SENDER_AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SenderAwsAccountId").getter(getter(EngagementInvitationSummary::senderAwsAccountId))
            .setter(setter(Builder::senderAwsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderAwsAccountId").build())
            .build();

    private static final SdkField<String> SENDER_COMPANY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SenderCompanyName").getter(getter(EngagementInvitationSummary::senderCompanyName))
            .setter(setter(Builder::senderCompanyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderCompanyName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(EngagementInvitationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CATALOG_FIELD,
            ENGAGEMENT_ID_FIELD, ENGAGEMENT_TITLE_FIELD, EXPIRATION_DATE_FIELD, ID_FIELD, INVITATION_DATE_FIELD,
            PARTICIPANT_TYPE_FIELD, PAYLOAD_TYPE_FIELD, RECEIVER_FIELD, SENDER_AWS_ACCOUNT_ID_FIELD, SENDER_COMPANY_NAME_FIELD,
            STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String catalog;

    private final String engagementId;

    private final String engagementTitle;

    private final Instant expirationDate;

    private final String id;

    private final Instant invitationDate;

    private final String participantType;

    private final String payloadType;

    private final Receiver receiver;

    private final String senderAwsAccountId;

    private final String senderCompanyName;

    private final String status;

    private EngagementInvitationSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.catalog = builder.catalog;
        this.engagementId = builder.engagementId;
        this.engagementTitle = builder.engagementTitle;
        this.expirationDate = builder.expirationDate;
        this.id = builder.id;
        this.invitationDate = builder.invitationDate;
        this.participantType = builder.participantType;
        this.payloadType = builder.payloadType;
        this.receiver = builder.receiver;
        this.senderAwsAccountId = builder.senderAwsAccountId;
        this.senderCompanyName = builder.senderCompanyName;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Engagement Invitation. The ARN is a unique identifier that allows partners
     * to reference the invitation in their system and manage its lifecycle.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Engagement Invitation. The ARN is a unique identifier that allows
     *         partners to reference the invitation in their system and manage its lifecycle.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Specifies the catalog in which the Engagement Invitation resides. This can be either the <code>AWS</code> or
     * <code>Sandbox</code> catalog, indicating whether the opportunity is live or being tested.
     * </p>
     * 
     * @return Specifies the catalog in which the Engagement Invitation resides. This can be either the <code>AWS</code>
     *         or <code>Sandbox</code> catalog, indicating whether the opportunity is live or being tested.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The identifier of the Engagement associated with this invitation. This links the invitation to its parent
     * Engagement.
     * </p>
     * 
     * @return The identifier of the Engagement associated with this invitation. This links the invitation to its parent
     *         Engagement.
     */
    public final String engagementId() {
        return engagementId;
    }

    /**
     * <p>
     * Provides a short title or description of the Engagement Invitation. This title helps partners quickly identify
     * and differentiate between multiple engagement opportunities.
     * </p>
     * 
     * @return Provides a short title or description of the Engagement Invitation. This title helps partners quickly
     *         identify and differentiate between multiple engagement opportunities.
     */
    public final String engagementTitle() {
        return engagementTitle;
    }

    /**
     * <p>
     * Indicates the date and time when the Engagement Invitation will expire. After this date, the invitation can no
     * longer be accepted, and the opportunity will be unavailable to the partner.
     * </p>
     * 
     * @return Indicates the date and time when the Engagement Invitation will expire. After this date, the invitation
     *         can no longer be accepted, and the opportunity will be unavailable to the partner.
     */
    public final Instant expirationDate() {
        return expirationDate;
    }

    /**
     * <p>
     * Represents the unique identifier of the Engagement Invitation. This identifier is used to track the invitation
     * and to manage responses like acceptance or rejection.
     * </p>
     * 
     * @return Represents the unique identifier of the Engagement Invitation. This identifier is used to track the
     *         invitation and to manage responses like acceptance or rejection.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Indicates the date when the Engagement Invitation was sent to the partner. This provides context for when the
     * opportunity was shared and helps in tracking the timeline for engagement.
     * </p>
     * 
     * @return Indicates the date when the Engagement Invitation was sent to the partner. This provides context for when
     *         the opportunity was shared and helps in tracking the timeline for engagement.
     */
    public final Instant invitationDate() {
        return invitationDate;
    }

    /**
     * <p>
     * Identifies the role of the caller in the engagement invitation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantType}
     * will return {@link ParticipantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantTypeAsString}.
     * </p>
     * 
     * @return Identifies the role of the caller in the engagement invitation.
     * @see ParticipantType
     */
    public final ParticipantType participantType() {
        return ParticipantType.fromValue(participantType);
    }

    /**
     * <p>
     * Identifies the role of the caller in the engagement invitation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantType}
     * will return {@link ParticipantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantTypeAsString}.
     * </p>
     * 
     * @return Identifies the role of the caller in the engagement invitation.
     * @see ParticipantType
     */
    public final String participantTypeAsString() {
        return participantType;
    }

    /**
     * <p>
     * Describes the type of payload associated with the Engagement Invitation, such as <code>Opportunity</code> or
     * <code>MarketplaceOffer</code>. This helps partners understand the nature of the engagement request from AWS.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #payloadType} will
     * return {@link EngagementInvitationPayloadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #payloadTypeAsString}.
     * </p>
     * 
     * @return Describes the type of payload associated with the Engagement Invitation, such as <code>Opportunity</code>
     *         or <code>MarketplaceOffer</code>. This helps partners understand the nature of the engagement request
     *         from AWS.
     * @see EngagementInvitationPayloadType
     */
    public final EngagementInvitationPayloadType payloadType() {
        return EngagementInvitationPayloadType.fromValue(payloadType);
    }

    /**
     * <p>
     * Describes the type of payload associated with the Engagement Invitation, such as <code>Opportunity</code> or
     * <code>MarketplaceOffer</code>. This helps partners understand the nature of the engagement request from AWS.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #payloadType} will
     * return {@link EngagementInvitationPayloadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #payloadTypeAsString}.
     * </p>
     * 
     * @return Describes the type of payload associated with the Engagement Invitation, such as <code>Opportunity</code>
     *         or <code>MarketplaceOffer</code>. This helps partners understand the nature of the engagement request
     *         from AWS.
     * @see EngagementInvitationPayloadType
     */
    public final String payloadTypeAsString() {
        return payloadType;
    }

    /**
     * <p>
     * Specifies the partner company or individual that received the Engagement Invitation. This field is important for
     * tracking who the invitation was sent to within the partner organization.
     * </p>
     * 
     * @return Specifies the partner company or individual that received the Engagement Invitation. This field is
     *         important for tracking who the invitation was sent to within the partner organization.
     */
    public final Receiver receiver() {
        return receiver;
    }

    /**
     * <p>
     * Specifies the AWS account ID of the sender who initiated the Engagement Invitation. This allows the partner to
     * identify the AWS entity or representative responsible for sharing the opportunity.
     * </p>
     * 
     * @return Specifies the AWS account ID of the sender who initiated the Engagement Invitation. This allows the
     *         partner to identify the AWS entity or representative responsible for sharing the opportunity.
     */
    public final String senderAwsAccountId() {
        return senderAwsAccountId;
    }

    /**
     * <p>
     * Indicates the name of the company or AWS division that sent the Engagement Invitation. This information is useful
     * for partners to know which part of AWS is requesting engagement.
     * </p>
     * 
     * @return Indicates the name of the company or AWS division that sent the Engagement Invitation. This information
     *         is useful for partners to know which part of AWS is requesting engagement.
     */
    public final String senderCompanyName() {
        return senderCompanyName;
    }

    /**
     * <p>
     * Represents the current status of the Engagement Invitation, such as <code>Pending</code>, <code>Accepted</code>,
     * or <code>Rejected</code>. The status helps track the progress and response to the invitation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InvitationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Represents the current status of the Engagement Invitation, such as <code>Pending</code>,
     *         <code>Accepted</code>, or <code>Rejected</code>. The status helps track the progress and response to the
     *         invitation.
     * @see InvitationStatus
     */
    public final InvitationStatus status() {
        return InvitationStatus.fromValue(status);
    }

    /**
     * <p>
     * Represents the current status of the Engagement Invitation, such as <code>Pending</code>, <code>Accepted</code>,
     * or <code>Rejected</code>. The status helps track the progress and response to the invitation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InvitationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Represents the current status of the Engagement Invitation, such as <code>Pending</code>,
     *         <code>Accepted</code>, or <code>Rejected</code>. The status helps track the progress and response to the
     *         invitation.
     * @see InvitationStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(engagementId());
        hashCode = 31 * hashCode + Objects.hashCode(engagementTitle());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(invitationDate());
        hashCode = 31 * hashCode + Objects.hashCode(participantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(payloadTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(receiver());
        hashCode = 31 * hashCode + Objects.hashCode(senderAwsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(senderCompanyName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngagementInvitationSummary)) {
            return false;
        }
        EngagementInvitationSummary other = (EngagementInvitationSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(catalog(), other.catalog())
                && Objects.equals(engagementId(), other.engagementId())
                && Objects.equals(engagementTitle(), other.engagementTitle())
                && Objects.equals(expirationDate(), other.expirationDate()) && Objects.equals(id(), other.id())
                && Objects.equals(invitationDate(), other.invitationDate())
                && Objects.equals(participantTypeAsString(), other.participantTypeAsString())
                && Objects.equals(payloadTypeAsString(), other.payloadTypeAsString())
                && Objects.equals(receiver(), other.receiver())
                && Objects.equals(senderAwsAccountId(), other.senderAwsAccountId())
                && Objects.equals(senderCompanyName(), other.senderCompanyName())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EngagementInvitationSummary").add("Arn", arn()).add("Catalog", catalog())
                .add("EngagementId", engagementId()).add("EngagementTitle", engagementTitle())
                .add("ExpirationDate", expirationDate()).add("Id", id()).add("InvitationDate", invitationDate())
                .add("ParticipantType", participantTypeAsString()).add("PayloadType", payloadTypeAsString())
                .add("Receiver", receiver())
                .add("SenderAwsAccountId", senderAwsAccountId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SenderCompanyName", senderCompanyName()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "EngagementId":
            return Optional.ofNullable(clazz.cast(engagementId()));
        case "EngagementTitle":
            return Optional.ofNullable(clazz.cast(engagementTitle()));
        case "ExpirationDate":
            return Optional.ofNullable(clazz.cast(expirationDate()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "InvitationDate":
            return Optional.ofNullable(clazz.cast(invitationDate()));
        case "ParticipantType":
            return Optional.ofNullable(clazz.cast(participantTypeAsString()));
        case "PayloadType":
            return Optional.ofNullable(clazz.cast(payloadTypeAsString()));
        case "Receiver":
            return Optional.ofNullable(clazz.cast(receiver()));
        case "SenderAwsAccountId":
            return Optional.ofNullable(clazz.cast(senderAwsAccountId()));
        case "SenderCompanyName":
            return Optional.ofNullable(clazz.cast(senderCompanyName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Catalog", CATALOG_FIELD);
        map.put("EngagementId", ENGAGEMENT_ID_FIELD);
        map.put("EngagementTitle", ENGAGEMENT_TITLE_FIELD);
        map.put("ExpirationDate", EXPIRATION_DATE_FIELD);
        map.put("Id", ID_FIELD);
        map.put("InvitationDate", INVITATION_DATE_FIELD);
        map.put("ParticipantType", PARTICIPANT_TYPE_FIELD);
        map.put("PayloadType", PAYLOAD_TYPE_FIELD);
        map.put("Receiver", RECEIVER_FIELD);
        map.put("SenderAwsAccountId", SENDER_AWS_ACCOUNT_ID_FIELD);
        map.put("SenderCompanyName", SENDER_COMPANY_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EngagementInvitationSummary, T> g) {
        return obj -> g.apply((EngagementInvitationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EngagementInvitationSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Engagement Invitation. The ARN is a unique identifier that allows
         * partners to reference the invitation in their system and manage its lifecycle.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the Engagement Invitation. The ARN is a unique identifier that
         *        allows partners to reference the invitation in their system and manage its lifecycle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Specifies the catalog in which the Engagement Invitation resides. This can be either the <code>AWS</code> or
         * <code>Sandbox</code> catalog, indicating whether the opportunity is live or being tested.
         * </p>
         * 
         * @param catalog
         *        Specifies the catalog in which the Engagement Invitation resides. This can be either the
         *        <code>AWS</code> or <code>Sandbox</code> catalog, indicating whether the opportunity is live or being
         *        tested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The identifier of the Engagement associated with this invitation. This links the invitation to its parent
         * Engagement.
         * </p>
         * 
         * @param engagementId
         *        The identifier of the Engagement associated with this invitation. This links the invitation to its
         *        parent Engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementId(String engagementId);

        /**
         * <p>
         * Provides a short title or description of the Engagement Invitation. This title helps partners quickly
         * identify and differentiate between multiple engagement opportunities.
         * </p>
         * 
         * @param engagementTitle
         *        Provides a short title or description of the Engagement Invitation. This title helps partners quickly
         *        identify and differentiate between multiple engagement opportunities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementTitle(String engagementTitle);

        /**
         * <p>
         * Indicates the date and time when the Engagement Invitation will expire. After this date, the invitation can
         * no longer be accepted, and the opportunity will be unavailable to the partner.
         * </p>
         * 
         * @param expirationDate
         *        Indicates the date and time when the Engagement Invitation will expire. After this date, the
         *        invitation can no longer be accepted, and the opportunity will be unavailable to the partner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(Instant expirationDate);

        /**
         * <p>
         * Represents the unique identifier of the Engagement Invitation. This identifier is used to track the
         * invitation and to manage responses like acceptance or rejection.
         * </p>
         * 
         * @param id
         *        Represents the unique identifier of the Engagement Invitation. This identifier is used to track the
         *        invitation and to manage responses like acceptance or rejection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Indicates the date when the Engagement Invitation was sent to the partner. This provides context for when the
         * opportunity was shared and helps in tracking the timeline for engagement.
         * </p>
         * 
         * @param invitationDate
         *        Indicates the date when the Engagement Invitation was sent to the partner. This provides context for
         *        when the opportunity was shared and helps in tracking the timeline for engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invitationDate(Instant invitationDate);

        /**
         * <p>
         * Identifies the role of the caller in the engagement invitation.
         * </p>
         * 
         * @param participantType
         *        Identifies the role of the caller in the engagement invitation.
         * @see ParticipantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantType
         */
        Builder participantType(String participantType);

        /**
         * <p>
         * Identifies the role of the caller in the engagement invitation.
         * </p>
         * 
         * @param participantType
         *        Identifies the role of the caller in the engagement invitation.
         * @see ParticipantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantType
         */
        Builder participantType(ParticipantType participantType);

        /**
         * <p>
         * Describes the type of payload associated with the Engagement Invitation, such as <code>Opportunity</code> or
         * <code>MarketplaceOffer</code>. This helps partners understand the nature of the engagement request from AWS.
         * </p>
         * 
         * @param payloadType
         *        Describes the type of payload associated with the Engagement Invitation, such as
         *        <code>Opportunity</code> or <code>MarketplaceOffer</code>. This helps partners understand the nature
         *        of the engagement request from AWS.
         * @see EngagementInvitationPayloadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngagementInvitationPayloadType
         */
        Builder payloadType(String payloadType);

        /**
         * <p>
         * Describes the type of payload associated with the Engagement Invitation, such as <code>Opportunity</code> or
         * <code>MarketplaceOffer</code>. This helps partners understand the nature of the engagement request from AWS.
         * </p>
         * 
         * @param payloadType
         *        Describes the type of payload associated with the Engagement Invitation, such as
         *        <code>Opportunity</code> or <code>MarketplaceOffer</code>. This helps partners understand the nature
         *        of the engagement request from AWS.
         * @see EngagementInvitationPayloadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngagementInvitationPayloadType
         */
        Builder payloadType(EngagementInvitationPayloadType payloadType);

        /**
         * <p>
         * Specifies the partner company or individual that received the Engagement Invitation. This field is important
         * for tracking who the invitation was sent to within the partner organization.
         * </p>
         * 
         * @param receiver
         *        Specifies the partner company or individual that received the Engagement Invitation. This field is
         *        important for tracking who the invitation was sent to within the partner organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiver(Receiver receiver);

        /**
         * <p>
         * Specifies the partner company or individual that received the Engagement Invitation. This field is important
         * for tracking who the invitation was sent to within the partner organization.
         * </p>
         * This is a convenience method that creates an instance of the {@link Receiver.Builder} avoiding the need to
         * create one manually via {@link Receiver#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Receiver.Builder#build()} is called immediately and its result is
         * passed to {@link #receiver(Receiver)}.
         * 
         * @param receiver
         *        a consumer that will call methods on {@link Receiver.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #receiver(Receiver)
         */
        default Builder receiver(Consumer<Receiver.Builder> receiver) {
            return receiver(Receiver.builder().applyMutation(receiver).build());
        }

        /**
         * <p>
         * Specifies the AWS account ID of the sender who initiated the Engagement Invitation. This allows the partner
         * to identify the AWS entity or representative responsible for sharing the opportunity.
         * </p>
         * 
         * @param senderAwsAccountId
         *        Specifies the AWS account ID of the sender who initiated the Engagement Invitation. This allows the
         *        partner to identify the AWS entity or representative responsible for sharing the opportunity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderAwsAccountId(String senderAwsAccountId);

        /**
         * <p>
         * Indicates the name of the company or AWS division that sent the Engagement Invitation. This information is
         * useful for partners to know which part of AWS is requesting engagement.
         * </p>
         * 
         * @param senderCompanyName
         *        Indicates the name of the company or AWS division that sent the Engagement Invitation. This
         *        information is useful for partners to know which part of AWS is requesting engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderCompanyName(String senderCompanyName);

        /**
         * <p>
         * Represents the current status of the Engagement Invitation, such as <code>Pending</code>,
         * <code>Accepted</code>, or <code>Rejected</code>. The status helps track the progress and response to the
         * invitation.
         * </p>
         * 
         * @param status
         *        Represents the current status of the Engagement Invitation, such as <code>Pending</code>,
         *        <code>Accepted</code>, or <code>Rejected</code>. The status helps track the progress and response to
         *        the invitation.
         * @see InvitationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvitationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Represents the current status of the Engagement Invitation, such as <code>Pending</code>,
         * <code>Accepted</code>, or <code>Rejected</code>. The status helps track the progress and response to the
         * invitation.
         * </p>
         * 
         * @param status
         *        Represents the current status of the Engagement Invitation, such as <code>Pending</code>,
         *        <code>Accepted</code>, or <code>Rejected</code>. The status helps track the progress and response to
         *        the invitation.
         * @see InvitationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvitationStatus
         */
        Builder status(InvitationStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String catalog;

        private String engagementId;

        private String engagementTitle;

        private Instant expirationDate;

        private String id;

        private Instant invitationDate;

        private String participantType;

        private String payloadType;

        private Receiver receiver;

        private String senderAwsAccountId;

        private String senderCompanyName;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(EngagementInvitationSummary model) {
            arn(model.arn);
            catalog(model.catalog);
            engagementId(model.engagementId);
            engagementTitle(model.engagementTitle);
            expirationDate(model.expirationDate);
            id(model.id);
            invitationDate(model.invitationDate);
            participantType(model.participantType);
            payloadType(model.payloadType);
            receiver(model.receiver);
            senderAwsAccountId(model.senderAwsAccountId);
            senderCompanyName(model.senderCompanyName);
            status(model.status);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getEngagementId() {
            return engagementId;
        }

        public final void setEngagementId(String engagementId) {
            this.engagementId = engagementId;
        }

        @Override
        public final Builder engagementId(String engagementId) {
            this.engagementId = engagementId;
            return this;
        }

        public final String getEngagementTitle() {
            return engagementTitle;
        }

        public final void setEngagementTitle(String engagementTitle) {
            this.engagementTitle = engagementTitle;
        }

        @Override
        public final Builder engagementTitle(String engagementTitle) {
            this.engagementTitle = engagementTitle;
            return this;
        }

        public final Instant getExpirationDate() {
            return expirationDate;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getInvitationDate() {
            return invitationDate;
        }

        public final void setInvitationDate(Instant invitationDate) {
            this.invitationDate = invitationDate;
        }

        @Override
        public final Builder invitationDate(Instant invitationDate) {
            this.invitationDate = invitationDate;
            return this;
        }

        public final String getParticipantType() {
            return participantType;
        }

        public final void setParticipantType(String participantType) {
            this.participantType = participantType;
        }

        @Override
        public final Builder participantType(String participantType) {
            this.participantType = participantType;
            return this;
        }

        @Override
        public final Builder participantType(ParticipantType participantType) {
            this.participantType(participantType == null ? null : participantType.toString());
            return this;
        }

        public final String getPayloadType() {
            return payloadType;
        }

        public final void setPayloadType(String payloadType) {
            this.payloadType = payloadType;
        }

        @Override
        public final Builder payloadType(String payloadType) {
            this.payloadType = payloadType;
            return this;
        }

        @Override
        public final Builder payloadType(EngagementInvitationPayloadType payloadType) {
            this.payloadType(payloadType == null ? null : payloadType.toString());
            return this;
        }

        public final Receiver.Builder getReceiver() {
            return receiver != null ? receiver.toBuilder() : null;
        }

        public final void setReceiver(Receiver.BuilderImpl receiver) {
            this.receiver = receiver != null ? receiver.build() : null;
        }

        @Override
        public final Builder receiver(Receiver receiver) {
            this.receiver = receiver;
            return this;
        }

        public final String getSenderAwsAccountId() {
            return senderAwsAccountId;
        }

        public final void setSenderAwsAccountId(String senderAwsAccountId) {
            this.senderAwsAccountId = senderAwsAccountId;
        }

        @Override
        public final Builder senderAwsAccountId(String senderAwsAccountId) {
            this.senderAwsAccountId = senderAwsAccountId;
            return this;
        }

        public final String getSenderCompanyName() {
            return senderCompanyName;
        }

        public final void setSenderCompanyName(String senderCompanyName) {
            this.senderCompanyName = senderCompanyName;
        }

        @Override
        public final Builder senderCompanyName(String senderCompanyName) {
            this.senderCompanyName = senderCompanyName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InvitationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public EngagementInvitationSummary build() {
            return new EngagementInvitationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
