/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The EngagementMemberSummary provides a snapshot of essential information about participants in an AWS Partner Central
 * Engagement. This compact data structure encapsulates key details of each member, facilitating efficient collaboration
 * and management within the Engagement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EngagementMemberSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EngagementMemberSummary.Builder, EngagementMemberSummary> {
    private static final SdkField<String> COMPANY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompanyName").getter(getter(EngagementMemberSummary::companyName)).setter(setter(Builder::companyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompanyName").build()).build();

    private static final SdkField<String> WEBSITE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebsiteUrl").getter(getter(EngagementMemberSummary::websiteUrl)).setter(setter(Builder::websiteUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebsiteUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPANY_NAME_FIELD,
            WEBSITE_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String companyName;

    private final String websiteUrl;

    private EngagementMemberSummary(BuilderImpl builder) {
        this.companyName = builder.companyName;
        this.websiteUrl = builder.websiteUrl;
    }

    /**
     * <p>
     * The official name of the member's company or organization.
     * </p>
     * 
     * @return The official name of the member's company or organization.
     */
    public final String companyName() {
        return companyName;
    }

    /**
     * <p>
     * The URL of the member company's website. This offers a way to find more information about the member organization
     * and serves as an additional identifier.
     * </p>
     * 
     * @return The URL of the member company's website. This offers a way to find more information about the member
     *         organization and serves as an additional identifier.
     */
    public final String websiteUrl() {
        return websiteUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(companyName());
        hashCode = 31 * hashCode + Objects.hashCode(websiteUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngagementMemberSummary)) {
            return false;
        }
        EngagementMemberSummary other = (EngagementMemberSummary) obj;
        return Objects.equals(companyName(), other.companyName()) && Objects.equals(websiteUrl(), other.websiteUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EngagementMemberSummary").add("CompanyName", companyName()).add("WebsiteUrl", websiteUrl())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompanyName":
            return Optional.ofNullable(clazz.cast(companyName()));
        case "WebsiteUrl":
            return Optional.ofNullable(clazz.cast(websiteUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CompanyName", COMPANY_NAME_FIELD);
        map.put("WebsiteUrl", WEBSITE_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EngagementMemberSummary, T> g) {
        return obj -> g.apply((EngagementMemberSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EngagementMemberSummary> {
        /**
         * <p>
         * The official name of the member's company or organization.
         * </p>
         * 
         * @param companyName
         *        The official name of the member's company or organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder companyName(String companyName);

        /**
         * <p>
         * The URL of the member company's website. This offers a way to find more information about the member
         * organization and serves as an additional identifier.
         * </p>
         * 
         * @param websiteUrl
         *        The URL of the member company's website. This offers a way to find more information about the member
         *        organization and serves as an additional identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder websiteUrl(String websiteUrl);
    }

    static final class BuilderImpl implements Builder {
        private String companyName;

        private String websiteUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(EngagementMemberSummary model) {
            companyName(model.companyName);
            websiteUrl(model.websiteUrl);
        }

        public final String getCompanyName() {
            return companyName;
        }

        public final void setCompanyName(String companyName) {
            this.companyName = companyName;
        }

        @Override
        public final Builder companyName(String companyName) {
            this.companyName = companyName;
            return this;
        }

        public final String getWebsiteUrl() {
            return websiteUrl;
        }

        public final void setWebsiteUrl(String websiteUrl) {
            this.websiteUrl = websiteUrl;
        }

        @Override
        public final Builder websiteUrl(String websiteUrl) {
            this.websiteUrl = websiteUrl;
            return this;
        }

        @Override
        public EngagementMemberSummary build() {
            return new EngagementMemberSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
