/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This provide a streamlined view of the relationships between engagements and resources. These summaries offer a
 * crucial link between collaborative engagements and the specific resources involved, such as opportunities.These
 * summaries are particularly valuable for partners navigating complex engagements with multiple resources. They enable
 * quick insights into resource distribution across engagements, support efficient resource management, and help
 * maintain a clear overview of collaborative activities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EngagementResourceAssociationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EngagementResourceAssociationSummary.Builder, EngagementResourceAssociationSummary> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(EngagementResourceAssociationSummary::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedBy").getter(getter(EngagementResourceAssociationSummary::createdBy))
            .setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<String> ENGAGEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngagementId").getter(getter(EngagementResourceAssociationSummary::engagementId))
            .setter(setter(Builder::engagementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementId").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(EngagementResourceAssociationSummary::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(EngagementResourceAssociationSummary::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            CREATED_BY_FIELD, ENGAGEMENT_ID_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String catalog;

    private final String createdBy;

    private final String engagementId;

    private final String resourceId;

    private final String resourceType;

    private EngagementResourceAssociationSummary(BuilderImpl builder) {
        this.catalog = builder.catalog;
        this.createdBy = builder.createdBy;
        this.engagementId = builder.engagementId;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
    }

    /**
     * <p>
     * Indicates the environment in which the resource and engagement exist.
     * </p>
     * 
     * @return Indicates the environment in which the resource and engagement exist.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The AWS account ID of the entity that owns the resource. Identifies the account responsible for or having primary
     * control over the resource.
     * </p>
     * 
     * @return The AWS account ID of the entity that owns the resource. Identifies the account responsible for or having
     *         primary control over the resource.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * A unique identifier for the engagement associated with the resource.
     * </p>
     * 
     * @return A unique identifier for the engagement associated with the resource.
     */
    public final String engagementId() {
        return engagementId;
    }

    /**
     * <p>
     * A unique identifier for the specific resource. Varies depending on the resource type.
     * </p>
     * 
     * @return A unique identifier for the specific resource. Varies depending on the resource type.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * Categorizes the type of resource associated with the engagement.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Categorizes the type of resource associated with the engagement.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * Categorizes the type of resource associated with the engagement.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Categorizes the type of resource associated with the engagement.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(engagementId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngagementResourceAssociationSummary)) {
            return false;
        }
        EngagementResourceAssociationSummary other = (EngagementResourceAssociationSummary) obj;
        return Objects.equals(catalog(), other.catalog()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(engagementId(), other.engagementId()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EngagementResourceAssociationSummary").add("Catalog", catalog())
                .add("CreatedBy", createdBy() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EngagementId", engagementId()).add("ResourceId", resourceId()).add("ResourceType", resourceTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "EngagementId":
            return Optional.ofNullable(clazz.cast(engagementId()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("EngagementId", ENGAGEMENT_ID_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EngagementResourceAssociationSummary, T> g) {
        return obj -> g.apply((EngagementResourceAssociationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EngagementResourceAssociationSummary> {
        /**
         * <p>
         * Indicates the environment in which the resource and engagement exist.
         * </p>
         * 
         * @param catalog
         *        Indicates the environment in which the resource and engagement exist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The AWS account ID of the entity that owns the resource. Identifies the account responsible for or having
         * primary control over the resource.
         * </p>
         * 
         * @param createdBy
         *        The AWS account ID of the entity that owns the resource. Identifies the account responsible for or
         *        having primary control over the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * A unique identifier for the engagement associated with the resource.
         * </p>
         * 
         * @param engagementId
         *        A unique identifier for the engagement associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementId(String engagementId);

        /**
         * <p>
         * A unique identifier for the specific resource. Varies depending on the resource type.
         * </p>
         * 
         * @param resourceId
         *        A unique identifier for the specific resource. Varies depending on the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * Categorizes the type of resource associated with the engagement.
         * </p>
         * 
         * @param resourceType
         *        Categorizes the type of resource associated with the engagement.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Categorizes the type of resource associated with the engagement.
         * </p>
         * 
         * @param resourceType
         *        Categorizes the type of resource associated with the engagement.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);
    }

    static final class BuilderImpl implements Builder {
        private String catalog;

        private String createdBy;

        private String engagementId;

        private String resourceId;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(EngagementResourceAssociationSummary model) {
            catalog(model.catalog);
            createdBy(model.createdBy);
            engagementId(model.engagementId);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getEngagementId() {
            return engagementId;
        }

        public final void setEngagementId(String engagementId) {
            this.engagementId = engagementId;
        }

        @Override
        public final Builder engagementId(String engagementId) {
            this.engagementId = engagementId;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        @Override
        public EngagementResourceAssociationSummary build() {
            return new EngagementResourceAssociationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
