/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAwsOpportunitySummaryResponse extends PartnerCentralSellingResponse implements
        ToCopyableBuilder<GetAwsOpportunitySummaryResponse.Builder, GetAwsOpportunitySummaryResponse> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(GetAwsOpportunitySummaryResponse::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<AwsOpportunityCustomer> CUSTOMER_FIELD = SdkField
            .<AwsOpportunityCustomer> builder(MarshallingType.SDK_POJO).memberName("Customer")
            .getter(getter(GetAwsOpportunitySummaryResponse::customer)).setter(setter(Builder::customer))
            .constructor(AwsOpportunityCustomer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Customer").build()).build();

    private static final SdkField<AwsOpportunityInsights> INSIGHTS_FIELD = SdkField
            .<AwsOpportunityInsights> builder(MarshallingType.SDK_POJO).memberName("Insights")
            .getter(getter(GetAwsOpportunitySummaryResponse::insights)).setter(setter(Builder::insights))
            .constructor(AwsOpportunityInsights::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Insights").build()).build();

    private static final SdkField<String> INVOLVEMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvolvementType").getter(getter(GetAwsOpportunitySummaryResponse::involvementTypeAsString))
            .setter(setter(Builder::involvementType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvolvementType").build()).build();

    private static final SdkField<String> INVOLVEMENT_TYPE_CHANGE_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InvolvementTypeChangeReason")
            .getter(getter(GetAwsOpportunitySummaryResponse::involvementTypeChangeReasonAsString))
            .setter(setter(Builder::involvementTypeChangeReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvolvementTypeChangeReason")
                    .build()).build();

    private static final SdkField<AwsOpportunityLifeCycle> LIFE_CYCLE_FIELD = SdkField
            .<AwsOpportunityLifeCycle> builder(MarshallingType.SDK_POJO).memberName("LifeCycle")
            .getter(getter(GetAwsOpportunitySummaryResponse::lifeCycle)).setter(setter(Builder::lifeCycle))
            .constructor(AwsOpportunityLifeCycle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycle").build()).build();

    private static final SdkField<List<AwsTeamMember>> OPPORTUNITY_TEAM_FIELD = SdkField
            .<List<AwsTeamMember>> builder(MarshallingType.LIST)
            .memberName("OpportunityTeam")
            .getter(getter(GetAwsOpportunitySummaryResponse::opportunityTeam))
            .setter(setter(Builder::opportunityTeam))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunityTeam").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsTeamMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsTeamMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ORIGIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Origin")
            .getter(getter(GetAwsOpportunitySummaryResponse::originAsString)).setter(setter(Builder::origin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin").build()).build();

    private static final SdkField<AwsOpportunityProject> PROJECT_FIELD = SdkField
            .<AwsOpportunityProject> builder(MarshallingType.SDK_POJO).memberName("Project")
            .getter(getter(GetAwsOpportunitySummaryResponse::project)).setter(setter(Builder::project))
            .constructor(AwsOpportunityProject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Project").build()).build();

    private static final SdkField<AwsOpportunityRelatedEntities> RELATED_ENTITY_IDS_FIELD = SdkField
            .<AwsOpportunityRelatedEntities> builder(MarshallingType.SDK_POJO).memberName("RelatedEntityIds")
            .getter(getter(GetAwsOpportunitySummaryResponse::relatedEntityIds)).setter(setter(Builder::relatedEntityIds))
            .constructor(AwsOpportunityRelatedEntities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedEntityIds").build()).build();

    private static final SdkField<String> RELATED_OPPORTUNITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelatedOpportunityId").getter(getter(GetAwsOpportunitySummaryResponse::relatedOpportunityId))
            .setter(setter(Builder::relatedOpportunityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedOpportunityId").build())
            .build();

    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(GetAwsOpportunitySummaryResponse::visibilityAsString))
            .setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, CUSTOMER_FIELD,
            INSIGHTS_FIELD, INVOLVEMENT_TYPE_FIELD, INVOLVEMENT_TYPE_CHANGE_REASON_FIELD, LIFE_CYCLE_FIELD,
            OPPORTUNITY_TEAM_FIELD, ORIGIN_FIELD, PROJECT_FIELD, RELATED_ENTITY_IDS_FIELD, RELATED_OPPORTUNITY_ID_FIELD,
            VISIBILITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final AwsOpportunityCustomer customer;

    private final AwsOpportunityInsights insights;

    private final String involvementType;

    private final String involvementTypeChangeReason;

    private final AwsOpportunityLifeCycle lifeCycle;

    private final List<AwsTeamMember> opportunityTeam;

    private final String origin;

    private final AwsOpportunityProject project;

    private final AwsOpportunityRelatedEntities relatedEntityIds;

    private final String relatedOpportunityId;

    private final String visibility;

    private GetAwsOpportunitySummaryResponse(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.customer = builder.customer;
        this.insights = builder.insights;
        this.involvementType = builder.involvementType;
        this.involvementTypeChangeReason = builder.involvementTypeChangeReason;
        this.lifeCycle = builder.lifeCycle;
        this.opportunityTeam = builder.opportunityTeam;
        this.origin = builder.origin;
        this.project = builder.project;
        this.relatedEntityIds = builder.relatedEntityIds;
        this.relatedOpportunityId = builder.relatedOpportunityId;
        this.visibility = builder.visibility;
    }

    /**
     * <p>
     * Specifies the catalog in which the AWS Opportunity exists. This is the environment (e.g., <code>AWS</code> or
     * <code>Sandbox</code>) where the opportunity is being managed.
     * </p>
     * 
     * @return Specifies the catalog in which the AWS Opportunity exists. This is the environment (e.g.,
     *         <code>AWS</code> or <code>Sandbox</code>) where the opportunity is being managed.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * Provides details about the customer associated with the AWS Opportunity, including account information, industry,
     * and other customer data. These details help partners understand the business context of the opportunity.
     * </p>
     * 
     * @return Provides details about the customer associated with the AWS Opportunity, including account information,
     *         industry, and other customer data. These details help partners understand the business context of the
     *         opportunity.
     */
    public final AwsOpportunityCustomer customer() {
        return customer;
    }

    /**
     * <p>
     * Provides insights into the AWS Opportunity, including engagement score and recommended actions that AWS suggests
     * for the partner.
     * </p>
     * 
     * @return Provides insights into the AWS Opportunity, including engagement score and recommended actions that AWS
     *         suggests for the partner.
     */
    public final AwsOpportunityInsights insights() {
        return insights;
    }

    /**
     * <p>
     * Specifies the type of involvement AWS has in the opportunity, such as direct cosell or advisory support. This
     * field helps partners understand the role AWS plays in advancing the opportunity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #involvementType}
     * will return {@link SalesInvolvementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #involvementTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of involvement AWS has in the opportunity, such as direct cosell or advisory support.
     *         This field helps partners understand the role AWS plays in advancing the opportunity.
     * @see SalesInvolvementType
     */
    public final SalesInvolvementType involvementType() {
        return SalesInvolvementType.fromValue(involvementType);
    }

    /**
     * <p>
     * Specifies the type of involvement AWS has in the opportunity, such as direct cosell or advisory support. This
     * field helps partners understand the role AWS plays in advancing the opportunity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #involvementType}
     * will return {@link SalesInvolvementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #involvementTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of involvement AWS has in the opportunity, such as direct cosell or advisory support.
     *         This field helps partners understand the role AWS plays in advancing the opportunity.
     * @see SalesInvolvementType
     */
    public final String involvementTypeAsString() {
        return involvementType;
    }

    /**
     * <p>
     * Provides a reason for any changes in the involvement type of AWS in the opportunity. This field is used to track
     * why the level of AWS engagement has changed from <code>For Visibility Only</code> to <code>Co-sell</code>
     * offering transparency into the partnership dynamics.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #involvementTypeChangeReason} will return {@link InvolvementTypeChangeReason#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #involvementTypeChangeReasonAsString}.
     * </p>
     * 
     * @return Provides a reason for any changes in the involvement type of AWS in the opportunity. This field is used
     *         to track why the level of AWS engagement has changed from <code>For Visibility Only</code> to
     *         <code>Co-sell</code> offering transparency into the partnership dynamics.
     * @see InvolvementTypeChangeReason
     */
    public final InvolvementTypeChangeReason involvementTypeChangeReason() {
        return InvolvementTypeChangeReason.fromValue(involvementTypeChangeReason);
    }

    /**
     * <p>
     * Provides a reason for any changes in the involvement type of AWS in the opportunity. This field is used to track
     * why the level of AWS engagement has changed from <code>For Visibility Only</code> to <code>Co-sell</code>
     * offering transparency into the partnership dynamics.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #involvementTypeChangeReason} will return {@link InvolvementTypeChangeReason#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #involvementTypeChangeReasonAsString}.
     * </p>
     * 
     * @return Provides a reason for any changes in the involvement type of AWS in the opportunity. This field is used
     *         to track why the level of AWS engagement has changed from <code>For Visibility Only</code> to
     *         <code>Co-sell</code> offering transparency into the partnership dynamics.
     * @see InvolvementTypeChangeReason
     */
    public final String involvementTypeChangeReasonAsString() {
        return involvementTypeChangeReason;
    }

    /**
     * <p>
     * Contains lifecycle information for the AWS Opportunity, including review status, stage, and target close date.
     * This field is crucial for partners to monitor the progression of the opportunity.
     * </p>
     * 
     * @return Contains lifecycle information for the AWS Opportunity, including review status, stage, and target close
     *         date. This field is crucial for partners to monitor the progression of the opportunity.
     */
    public final AwsOpportunityLifeCycle lifeCycle() {
        return lifeCycle;
    }

    /**
     * For responses, this returns true if the service returned a value for the OpportunityTeam property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOpportunityTeam() {
        return opportunityTeam != null && !(opportunityTeam instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details the AWS opportunity team, including members involved. This information helps partners know who from AWS
     * is engaged and what their role is.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOpportunityTeam} method.
     * </p>
     * 
     * @return Details the AWS opportunity team, including members involved. This information helps partners know who
     *         from AWS is engaged and what their role is.
     */
    public final List<AwsTeamMember> opportunityTeam() {
        return opportunityTeam;
    }

    /**
     * <p>
     * Specifies whether the AWS Opportunity originated from AWS or the partner. This helps distinguish between
     * opportunities that were sourced by AWS and those referred by the partner.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #origin} will
     * return {@link OpportunityOrigin#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #originAsString}.
     * </p>
     * 
     * @return Specifies whether the AWS Opportunity originated from AWS or the partner. This helps distinguish between
     *         opportunities that were sourced by AWS and those referred by the partner.
     * @see OpportunityOrigin
     */
    public final OpportunityOrigin origin() {
        return OpportunityOrigin.fromValue(origin);
    }

    /**
     * <p>
     * Specifies whether the AWS Opportunity originated from AWS or the partner. This helps distinguish between
     * opportunities that were sourced by AWS and those referred by the partner.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #origin} will
     * return {@link OpportunityOrigin#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #originAsString}.
     * </p>
     * 
     * @return Specifies whether the AWS Opportunity originated from AWS or the partner. This helps distinguish between
     *         opportunities that were sourced by AWS and those referred by the partner.
     * @see OpportunityOrigin
     */
    public final String originAsString() {
        return origin;
    }

    /**
     * <p>
     * Provides details about the project associated with the AWS Opportunity, including the customer’s business
     * problem, expected outcomes, and project scope. This information is crucial for understanding the broader context
     * of the opportunity.
     * </p>
     * 
     * @return Provides details about the project associated with the AWS Opportunity, including the customer’s business
     *         problem, expected outcomes, and project scope. This information is crucial for understanding the broader
     *         context of the opportunity.
     */
    public final AwsOpportunityProject project() {
        return project;
    }

    /**
     * <p>
     * Lists related entity identifiers, such as AWS products or partner solutions, associated with the AWS Opportunity.
     * These identifiers provide additional context and help partners understand which AWS services are involved.
     * </p>
     * 
     * @return Lists related entity identifiers, such as AWS products or partner solutions, associated with the AWS
     *         Opportunity. These identifiers provide additional context and help partners understand which AWS services
     *         are involved.
     */
    public final AwsOpportunityRelatedEntities relatedEntityIds() {
        return relatedEntityIds;
    }

    /**
     * <p>
     * Provides the unique identifier of the related partner opportunity, allowing partners to link the AWS Opportunity
     * to their corresponding opportunity in their CRM system.
     * </p>
     * 
     * @return Provides the unique identifier of the related partner opportunity, allowing partners to link the AWS
     *         Opportunity to their corresponding opportunity in their CRM system.
     */
    public final String relatedOpportunityId() {
        return relatedOpportunityId;
    }

    /**
     * <p>
     * Defines the visibility level for the AWS Opportunity. Use <code>Full</code> visibility for most cases, while
     * <code>Limited</code> visibility is reserved for special programs or sensitive opportunities.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return Defines the visibility level for the AWS Opportunity. Use <code>Full</code> visibility for most cases,
     *         while <code>Limited</code> visibility is reserved for special programs or sensitive opportunities.
     * @see Visibility
     */
    public final Visibility visibility() {
        return Visibility.fromValue(visibility);
    }

    /**
     * <p>
     * Defines the visibility level for the AWS Opportunity. Use <code>Full</code> visibility for most cases, while
     * <code>Limited</code> visibility is reserved for special programs or sensitive opportunities.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return Defines the visibility level for the AWS Opportunity. Use <code>Full</code> visibility for most cases,
     *         while <code>Limited</code> visibility is reserved for special programs or sensitive opportunities.
     * @see Visibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(customer());
        hashCode = 31 * hashCode + Objects.hashCode(insights());
        hashCode = 31 * hashCode + Objects.hashCode(involvementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(involvementTypeChangeReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lifeCycle());
        hashCode = 31 * hashCode + Objects.hashCode(hasOpportunityTeam() ? opportunityTeam() : null);
        hashCode = 31 * hashCode + Objects.hashCode(originAsString());
        hashCode = 31 * hashCode + Objects.hashCode(project());
        hashCode = 31 * hashCode + Objects.hashCode(relatedEntityIds());
        hashCode = 31 * hashCode + Objects.hashCode(relatedOpportunityId());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAwsOpportunitySummaryResponse)) {
            return false;
        }
        GetAwsOpportunitySummaryResponse other = (GetAwsOpportunitySummaryResponse) obj;
        return Objects.equals(catalog(), other.catalog()) && Objects.equals(customer(), other.customer())
                && Objects.equals(insights(), other.insights())
                && Objects.equals(involvementTypeAsString(), other.involvementTypeAsString())
                && Objects.equals(involvementTypeChangeReasonAsString(), other.involvementTypeChangeReasonAsString())
                && Objects.equals(lifeCycle(), other.lifeCycle()) && hasOpportunityTeam() == other.hasOpportunityTeam()
                && Objects.equals(opportunityTeam(), other.opportunityTeam())
                && Objects.equals(originAsString(), other.originAsString()) && Objects.equals(project(), other.project())
                && Objects.equals(relatedEntityIds(), other.relatedEntityIds())
                && Objects.equals(relatedOpportunityId(), other.relatedOpportunityId())
                && Objects.equals(visibilityAsString(), other.visibilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAwsOpportunitySummaryResponse").add("Catalog", catalog()).add("Customer", customer())
                .add("Insights", insights()).add("InvolvementType", involvementTypeAsString())
                .add("InvolvementTypeChangeReason", involvementTypeChangeReasonAsString()).add("LifeCycle", lifeCycle())
                .add("OpportunityTeam", hasOpportunityTeam() ? opportunityTeam() : null).add("Origin", originAsString())
                .add("Project", project()).add("RelatedEntityIds", relatedEntityIds())
                .add("RelatedOpportunityId", relatedOpportunityId()).add("Visibility", visibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "Customer":
            return Optional.ofNullable(clazz.cast(customer()));
        case "Insights":
            return Optional.ofNullable(clazz.cast(insights()));
        case "InvolvementType":
            return Optional.ofNullable(clazz.cast(involvementTypeAsString()));
        case "InvolvementTypeChangeReason":
            return Optional.ofNullable(clazz.cast(involvementTypeChangeReasonAsString()));
        case "LifeCycle":
            return Optional.ofNullable(clazz.cast(lifeCycle()));
        case "OpportunityTeam":
            return Optional.ofNullable(clazz.cast(opportunityTeam()));
        case "Origin":
            return Optional.ofNullable(clazz.cast(originAsString()));
        case "Project":
            return Optional.ofNullable(clazz.cast(project()));
        case "RelatedEntityIds":
            return Optional.ofNullable(clazz.cast(relatedEntityIds()));
        case "RelatedOpportunityId":
            return Optional.ofNullable(clazz.cast(relatedOpportunityId()));
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("Customer", CUSTOMER_FIELD);
        map.put("Insights", INSIGHTS_FIELD);
        map.put("InvolvementType", INVOLVEMENT_TYPE_FIELD);
        map.put("InvolvementTypeChangeReason", INVOLVEMENT_TYPE_CHANGE_REASON_FIELD);
        map.put("LifeCycle", LIFE_CYCLE_FIELD);
        map.put("OpportunityTeam", OPPORTUNITY_TEAM_FIELD);
        map.put("Origin", ORIGIN_FIELD);
        map.put("Project", PROJECT_FIELD);
        map.put("RelatedEntityIds", RELATED_ENTITY_IDS_FIELD);
        map.put("RelatedOpportunityId", RELATED_OPPORTUNITY_ID_FIELD);
        map.put("Visibility", VISIBILITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAwsOpportunitySummaryResponse, T> g) {
        return obj -> g.apply((GetAwsOpportunitySummaryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PartnerCentralSellingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAwsOpportunitySummaryResponse> {
        /**
         * <p>
         * Specifies the catalog in which the AWS Opportunity exists. This is the environment (e.g., <code>AWS</code> or
         * <code>Sandbox</code>) where the opportunity is being managed.
         * </p>
         * 
         * @param catalog
         *        Specifies the catalog in which the AWS Opportunity exists. This is the environment (e.g.,
         *        <code>AWS</code> or <code>Sandbox</code>) where the opportunity is being managed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * Provides details about the customer associated with the AWS Opportunity, including account information,
         * industry, and other customer data. These details help partners understand the business context of the
         * opportunity.
         * </p>
         * 
         * @param customer
         *        Provides details about the customer associated with the AWS Opportunity, including account
         *        information, industry, and other customer data. These details help partners understand the business
         *        context of the opportunity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customer(AwsOpportunityCustomer customer);

        /**
         * <p>
         * Provides details about the customer associated with the AWS Opportunity, including account information,
         * industry, and other customer data. These details help partners understand the business context of the
         * opportunity.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsOpportunityCustomer.Builder} avoiding
         * the need to create one manually via {@link AwsOpportunityCustomer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsOpportunityCustomer.Builder#build()} is called immediately and
         * its result is passed to {@link #customer(AwsOpportunityCustomer)}.
         * 
         * @param customer
         *        a consumer that will call methods on {@link AwsOpportunityCustomer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customer(AwsOpportunityCustomer)
         */
        default Builder customer(Consumer<AwsOpportunityCustomer.Builder> customer) {
            return customer(AwsOpportunityCustomer.builder().applyMutation(customer).build());
        }

        /**
         * <p>
         * Provides insights into the AWS Opportunity, including engagement score and recommended actions that AWS
         * suggests for the partner.
         * </p>
         * 
         * @param insights
         *        Provides insights into the AWS Opportunity, including engagement score and recommended actions that
         *        AWS suggests for the partner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insights(AwsOpportunityInsights insights);

        /**
         * <p>
         * Provides insights into the AWS Opportunity, including engagement score and recommended actions that AWS
         * suggests for the partner.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsOpportunityInsights.Builder} avoiding
         * the need to create one manually via {@link AwsOpportunityInsights#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsOpportunityInsights.Builder#build()} is called immediately and
         * its result is passed to {@link #insights(AwsOpportunityInsights)}.
         * 
         * @param insights
         *        a consumer that will call methods on {@link AwsOpportunityInsights.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insights(AwsOpportunityInsights)
         */
        default Builder insights(Consumer<AwsOpportunityInsights.Builder> insights) {
            return insights(AwsOpportunityInsights.builder().applyMutation(insights).build());
        }

        /**
         * <p>
         * Specifies the type of involvement AWS has in the opportunity, such as direct cosell or advisory support. This
         * field helps partners understand the role AWS plays in advancing the opportunity.
         * </p>
         * 
         * @param involvementType
         *        Specifies the type of involvement AWS has in the opportunity, such as direct cosell or advisory
         *        support. This field helps partners understand the role AWS plays in advancing the opportunity.
         * @see SalesInvolvementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SalesInvolvementType
         */
        Builder involvementType(String involvementType);

        /**
         * <p>
         * Specifies the type of involvement AWS has in the opportunity, such as direct cosell or advisory support. This
         * field helps partners understand the role AWS plays in advancing the opportunity.
         * </p>
         * 
         * @param involvementType
         *        Specifies the type of involvement AWS has in the opportunity, such as direct cosell or advisory
         *        support. This field helps partners understand the role AWS plays in advancing the opportunity.
         * @see SalesInvolvementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SalesInvolvementType
         */
        Builder involvementType(SalesInvolvementType involvementType);

        /**
         * <p>
         * Provides a reason for any changes in the involvement type of AWS in the opportunity. This field is used to
         * track why the level of AWS engagement has changed from <code>For Visibility Only</code> to
         * <code>Co-sell</code> offering transparency into the partnership dynamics.
         * </p>
         * 
         * @param involvementTypeChangeReason
         *        Provides a reason for any changes in the involvement type of AWS in the opportunity. This field is
         *        used to track why the level of AWS engagement has changed from <code>For Visibility Only</code> to
         *        <code>Co-sell</code> offering transparency into the partnership dynamics.
         * @see InvolvementTypeChangeReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvolvementTypeChangeReason
         */
        Builder involvementTypeChangeReason(String involvementTypeChangeReason);

        /**
         * <p>
         * Provides a reason for any changes in the involvement type of AWS in the opportunity. This field is used to
         * track why the level of AWS engagement has changed from <code>For Visibility Only</code> to
         * <code>Co-sell</code> offering transparency into the partnership dynamics.
         * </p>
         * 
         * @param involvementTypeChangeReason
         *        Provides a reason for any changes in the involvement type of AWS in the opportunity. This field is
         *        used to track why the level of AWS engagement has changed from <code>For Visibility Only</code> to
         *        <code>Co-sell</code> offering transparency into the partnership dynamics.
         * @see InvolvementTypeChangeReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvolvementTypeChangeReason
         */
        Builder involvementTypeChangeReason(InvolvementTypeChangeReason involvementTypeChangeReason);

        /**
         * <p>
         * Contains lifecycle information for the AWS Opportunity, including review status, stage, and target close
         * date. This field is crucial for partners to monitor the progression of the opportunity.
         * </p>
         * 
         * @param lifeCycle
         *        Contains lifecycle information for the AWS Opportunity, including review status, stage, and target
         *        close date. This field is crucial for partners to monitor the progression of the opportunity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycle(AwsOpportunityLifeCycle lifeCycle);

        /**
         * <p>
         * Contains lifecycle information for the AWS Opportunity, including review status, stage, and target close
         * date. This field is crucial for partners to monitor the progression of the opportunity.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsOpportunityLifeCycle.Builder} avoiding
         * the need to create one manually via {@link AwsOpportunityLifeCycle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsOpportunityLifeCycle.Builder#build()} is called immediately
         * and its result is passed to {@link #lifeCycle(AwsOpportunityLifeCycle)}.
         * 
         * @param lifeCycle
         *        a consumer that will call methods on {@link AwsOpportunityLifeCycle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifeCycle(AwsOpportunityLifeCycle)
         */
        default Builder lifeCycle(Consumer<AwsOpportunityLifeCycle.Builder> lifeCycle) {
            return lifeCycle(AwsOpportunityLifeCycle.builder().applyMutation(lifeCycle).build());
        }

        /**
         * <p>
         * Details the AWS opportunity team, including members involved. This information helps partners know who from
         * AWS is engaged and what their role is.
         * </p>
         * 
         * @param opportunityTeam
         *        Details the AWS opportunity team, including members involved. This information helps partners know who
         *        from AWS is engaged and what their role is.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opportunityTeam(Collection<AwsTeamMember> opportunityTeam);

        /**
         * <p>
         * Details the AWS opportunity team, including members involved. This information helps partners know who from
         * AWS is engaged and what their role is.
         * </p>
         * 
         * @param opportunityTeam
         *        Details the AWS opportunity team, including members involved. This information helps partners know who
         *        from AWS is engaged and what their role is.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opportunityTeam(AwsTeamMember... opportunityTeam);

        /**
         * <p>
         * Details the AWS opportunity team, including members involved. This information helps partners know who from
         * AWS is engaged and what their role is.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.AwsTeamMember.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.partnercentralselling.model.AwsTeamMember#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.AwsTeamMember.Builder#build()} is called
         * immediately and its result is passed to {@link #opportunityTeam(List<AwsTeamMember>)}.
         * 
         * @param opportunityTeam
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.AwsTeamMember.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #opportunityTeam(java.util.Collection<AwsTeamMember>)
         */
        Builder opportunityTeam(Consumer<AwsTeamMember.Builder>... opportunityTeam);

        /**
         * <p>
         * Specifies whether the AWS Opportunity originated from AWS or the partner. This helps distinguish between
         * opportunities that were sourced by AWS and those referred by the partner.
         * </p>
         * 
         * @param origin
         *        Specifies whether the AWS Opportunity originated from AWS or the partner. This helps distinguish
         *        between opportunities that were sourced by AWS and those referred by the partner.
         * @see OpportunityOrigin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpportunityOrigin
         */
        Builder origin(String origin);

        /**
         * <p>
         * Specifies whether the AWS Opportunity originated from AWS or the partner. This helps distinguish between
         * opportunities that were sourced by AWS and those referred by the partner.
         * </p>
         * 
         * @param origin
         *        Specifies whether the AWS Opportunity originated from AWS or the partner. This helps distinguish
         *        between opportunities that were sourced by AWS and those referred by the partner.
         * @see OpportunityOrigin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpportunityOrigin
         */
        Builder origin(OpportunityOrigin origin);

        /**
         * <p>
         * Provides details about the project associated with the AWS Opportunity, including the customer’s business
         * problem, expected outcomes, and project scope. This information is crucial for understanding the broader
         * context of the opportunity.
         * </p>
         * 
         * @param project
         *        Provides details about the project associated with the AWS Opportunity, including the customer’s
         *        business problem, expected outcomes, and project scope. This information is crucial for understanding
         *        the broader context of the opportunity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(AwsOpportunityProject project);

        /**
         * <p>
         * Provides details about the project associated with the AWS Opportunity, including the customer’s business
         * problem, expected outcomes, and project scope. This information is crucial for understanding the broader
         * context of the opportunity.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsOpportunityProject.Builder} avoiding
         * the need to create one manually via {@link AwsOpportunityProject#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsOpportunityProject.Builder#build()} is called immediately and
         * its result is passed to {@link #project(AwsOpportunityProject)}.
         * 
         * @param project
         *        a consumer that will call methods on {@link AwsOpportunityProject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #project(AwsOpportunityProject)
         */
        default Builder project(Consumer<AwsOpportunityProject.Builder> project) {
            return project(AwsOpportunityProject.builder().applyMutation(project).build());
        }

        /**
         * <p>
         * Lists related entity identifiers, such as AWS products or partner solutions, associated with the AWS
         * Opportunity. These identifiers provide additional context and help partners understand which AWS services are
         * involved.
         * </p>
         * 
         * @param relatedEntityIds
         *        Lists related entity identifiers, such as AWS products or partner solutions, associated with the AWS
         *        Opportunity. These identifiers provide additional context and help partners understand which AWS
         *        services are involved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedEntityIds(AwsOpportunityRelatedEntities relatedEntityIds);

        /**
         * <p>
         * Lists related entity identifiers, such as AWS products or partner solutions, associated with the AWS
         * Opportunity. These identifiers provide additional context and help partners understand which AWS services are
         * involved.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsOpportunityRelatedEntities.Builder}
         * avoiding the need to create one manually via {@link AwsOpportunityRelatedEntities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsOpportunityRelatedEntities.Builder#build()} is called
         * immediately and its result is passed to {@link #relatedEntityIds(AwsOpportunityRelatedEntities)}.
         * 
         * @param relatedEntityIds
         *        a consumer that will call methods on {@link AwsOpportunityRelatedEntities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relatedEntityIds(AwsOpportunityRelatedEntities)
         */
        default Builder relatedEntityIds(Consumer<AwsOpportunityRelatedEntities.Builder> relatedEntityIds) {
            return relatedEntityIds(AwsOpportunityRelatedEntities.builder().applyMutation(relatedEntityIds).build());
        }

        /**
         * <p>
         * Provides the unique identifier of the related partner opportunity, allowing partners to link the AWS
         * Opportunity to their corresponding opportunity in their CRM system.
         * </p>
         * 
         * @param relatedOpportunityId
         *        Provides the unique identifier of the related partner opportunity, allowing partners to link the AWS
         *        Opportunity to their corresponding opportunity in their CRM system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedOpportunityId(String relatedOpportunityId);

        /**
         * <p>
         * Defines the visibility level for the AWS Opportunity. Use <code>Full</code> visibility for most cases, while
         * <code>Limited</code> visibility is reserved for special programs or sensitive opportunities.
         * </p>
         * 
         * @param visibility
         *        Defines the visibility level for the AWS Opportunity. Use <code>Full</code> visibility for most cases,
         *        while <code>Limited</code> visibility is reserved for special programs or sensitive opportunities.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * Defines the visibility level for the AWS Opportunity. Use <code>Full</code> visibility for most cases, while
         * <code>Limited</code> visibility is reserved for special programs or sensitive opportunities.
         * </p>
         * 
         * @param visibility
         *        Defines the visibility level for the AWS Opportunity. Use <code>Full</code> visibility for most cases,
         *        while <code>Limited</code> visibility is reserved for special programs or sensitive opportunities.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(Visibility visibility);
    }

    static final class BuilderImpl extends PartnerCentralSellingResponse.BuilderImpl implements Builder {
        private String catalog;

        private AwsOpportunityCustomer customer;

        private AwsOpportunityInsights insights;

        private String involvementType;

        private String involvementTypeChangeReason;

        private AwsOpportunityLifeCycle lifeCycle;

        private List<AwsTeamMember> opportunityTeam = DefaultSdkAutoConstructList.getInstance();

        private String origin;

        private AwsOpportunityProject project;

        private AwsOpportunityRelatedEntities relatedEntityIds;

        private String relatedOpportunityId;

        private String visibility;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAwsOpportunitySummaryResponse model) {
            super(model);
            catalog(model.catalog);
            customer(model.customer);
            insights(model.insights);
            involvementType(model.involvementType);
            involvementTypeChangeReason(model.involvementTypeChangeReason);
            lifeCycle(model.lifeCycle);
            opportunityTeam(model.opportunityTeam);
            origin(model.origin);
            project(model.project);
            relatedEntityIds(model.relatedEntityIds);
            relatedOpportunityId(model.relatedOpportunityId);
            visibility(model.visibility);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final AwsOpportunityCustomer.Builder getCustomer() {
            return customer != null ? customer.toBuilder() : null;
        }

        public final void setCustomer(AwsOpportunityCustomer.BuilderImpl customer) {
            this.customer = customer != null ? customer.build() : null;
        }

        @Override
        public final Builder customer(AwsOpportunityCustomer customer) {
            this.customer = customer;
            return this;
        }

        public final AwsOpportunityInsights.Builder getInsights() {
            return insights != null ? insights.toBuilder() : null;
        }

        public final void setInsights(AwsOpportunityInsights.BuilderImpl insights) {
            this.insights = insights != null ? insights.build() : null;
        }

        @Override
        public final Builder insights(AwsOpportunityInsights insights) {
            this.insights = insights;
            return this;
        }

        public final String getInvolvementType() {
            return involvementType;
        }

        public final void setInvolvementType(String involvementType) {
            this.involvementType = involvementType;
        }

        @Override
        public final Builder involvementType(String involvementType) {
            this.involvementType = involvementType;
            return this;
        }

        @Override
        public final Builder involvementType(SalesInvolvementType involvementType) {
            this.involvementType(involvementType == null ? null : involvementType.toString());
            return this;
        }

        public final String getInvolvementTypeChangeReason() {
            return involvementTypeChangeReason;
        }

        public final void setInvolvementTypeChangeReason(String involvementTypeChangeReason) {
            this.involvementTypeChangeReason = involvementTypeChangeReason;
        }

        @Override
        public final Builder involvementTypeChangeReason(String involvementTypeChangeReason) {
            this.involvementTypeChangeReason = involvementTypeChangeReason;
            return this;
        }

        @Override
        public final Builder involvementTypeChangeReason(InvolvementTypeChangeReason involvementTypeChangeReason) {
            this.involvementTypeChangeReason(involvementTypeChangeReason == null ? null : involvementTypeChangeReason.toString());
            return this;
        }

        public final AwsOpportunityLifeCycle.Builder getLifeCycle() {
            return lifeCycle != null ? lifeCycle.toBuilder() : null;
        }

        public final void setLifeCycle(AwsOpportunityLifeCycle.BuilderImpl lifeCycle) {
            this.lifeCycle = lifeCycle != null ? lifeCycle.build() : null;
        }

        @Override
        public final Builder lifeCycle(AwsOpportunityLifeCycle lifeCycle) {
            this.lifeCycle = lifeCycle;
            return this;
        }

        public final List<AwsTeamMember.Builder> getOpportunityTeam() {
            List<AwsTeamMember.Builder> result = AwsOpportunityTeamMembersListCopier.copyToBuilder(this.opportunityTeam);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOpportunityTeam(Collection<AwsTeamMember.BuilderImpl> opportunityTeam) {
            this.opportunityTeam = AwsOpportunityTeamMembersListCopier.copyFromBuilder(opportunityTeam);
        }

        @Override
        public final Builder opportunityTeam(Collection<AwsTeamMember> opportunityTeam) {
            this.opportunityTeam = AwsOpportunityTeamMembersListCopier.copy(opportunityTeam);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opportunityTeam(AwsTeamMember... opportunityTeam) {
            opportunityTeam(Arrays.asList(opportunityTeam));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opportunityTeam(Consumer<AwsTeamMember.Builder>... opportunityTeam) {
            opportunityTeam(Stream.of(opportunityTeam).map(c -> AwsTeamMember.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getOrigin() {
            return origin;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(OpportunityOrigin origin) {
            this.origin(origin == null ? null : origin.toString());
            return this;
        }

        public final AwsOpportunityProject.Builder getProject() {
            return project != null ? project.toBuilder() : null;
        }

        public final void setProject(AwsOpportunityProject.BuilderImpl project) {
            this.project = project != null ? project.build() : null;
        }

        @Override
        public final Builder project(AwsOpportunityProject project) {
            this.project = project;
            return this;
        }

        public final AwsOpportunityRelatedEntities.Builder getRelatedEntityIds() {
            return relatedEntityIds != null ? relatedEntityIds.toBuilder() : null;
        }

        public final void setRelatedEntityIds(AwsOpportunityRelatedEntities.BuilderImpl relatedEntityIds) {
            this.relatedEntityIds = relatedEntityIds != null ? relatedEntityIds.build() : null;
        }

        @Override
        public final Builder relatedEntityIds(AwsOpportunityRelatedEntities relatedEntityIds) {
            this.relatedEntityIds = relatedEntityIds;
            return this;
        }

        public final String getRelatedOpportunityId() {
            return relatedOpportunityId;
        }

        public final void setRelatedOpportunityId(String relatedOpportunityId) {
            this.relatedOpportunityId = relatedOpportunityId;
        }

        @Override
        public final Builder relatedOpportunityId(String relatedOpportunityId) {
            this.relatedOpportunityId = relatedOpportunityId;
            return this;
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        @Override
        public GetAwsOpportunitySummaryResponse build() {
            return new GetAwsOpportunitySummaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
