/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEngagementInvitationResponse extends PartnerCentralSellingResponse implements
        ToCopyableBuilder<GetEngagementInvitationResponse.Builder, GetEngagementInvitationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetEngagementInvitationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(GetEngagementInvitationResponse::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> ENGAGEMENT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngagementDescription").getter(getter(GetEngagementInvitationResponse::engagementDescription))
            .setter(setter(Builder::engagementDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementDescription").build())
            .build();

    private static final SdkField<String> ENGAGEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngagementId").getter(getter(GetEngagementInvitationResponse::engagementId))
            .setter(setter(Builder::engagementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementId").build()).build();

    private static final SdkField<String> ENGAGEMENT_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngagementTitle").getter(getter(GetEngagementInvitationResponse::engagementTitle))
            .setter(setter(Builder::engagementTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementTitle").build()).build();

    private static final SdkField<List<EngagementMemberSummary>> EXISTING_MEMBERS_FIELD = SdkField
            .<List<EngagementMemberSummary>> builder(MarshallingType.LIST)
            .memberName("ExistingMembers")
            .getter(getter(GetEngagementInvitationResponse::existingMembers))
            .setter(setter(Builder::existingMembers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExistingMembers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EngagementMemberSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EngagementMemberSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpirationDate")
            .getter(getter(GetEngagementInvitationResponse::expirationDate))
            .setter(setter(Builder::expirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(GetEngagementInvitationResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Instant> INVITATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("InvitationDate")
            .getter(getter(GetEngagementInvitationResponse::invitationDate))
            .setter(setter(Builder::invitationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvitationDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> INVITATION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvitationMessage").getter(getter(GetEngagementInvitationResponse::invitationMessage))
            .setter(setter(Builder::invitationMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvitationMessage").build()).build();

    private static final SdkField<Payload> PAYLOAD_FIELD = SdkField.<Payload> builder(MarshallingType.SDK_POJO)
            .memberName("Payload").getter(getter(GetEngagementInvitationResponse::payload)).setter(setter(Builder::payload))
            .constructor(Payload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Payload").build()).build();

    private static final SdkField<String> PAYLOAD_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PayloadType").getter(getter(GetEngagementInvitationResponse::payloadTypeAsString))
            .setter(setter(Builder::payloadType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PayloadType").build()).build();

    private static final SdkField<Receiver> RECEIVER_FIELD = SdkField.<Receiver> builder(MarshallingType.SDK_POJO)
            .memberName("Receiver").getter(getter(GetEngagementInvitationResponse::receiver)).setter(setter(Builder::receiver))
            .constructor(Receiver::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Receiver").build()).build();

    private static final SdkField<String> REJECTION_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RejectionReason").getter(getter(GetEngagementInvitationResponse::rejectionReason))
            .setter(setter(Builder::rejectionReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RejectionReason").build()).build();

    private static final SdkField<String> SENDER_AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SenderAwsAccountId").getter(getter(GetEngagementInvitationResponse::senderAwsAccountId))
            .setter(setter(Builder::senderAwsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderAwsAccountId").build())
            .build();

    private static final SdkField<String> SENDER_COMPANY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SenderCompanyName").getter(getter(GetEngagementInvitationResponse::senderCompanyName))
            .setter(setter(Builder::senderCompanyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderCompanyName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetEngagementInvitationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CATALOG_FIELD,
            ENGAGEMENT_DESCRIPTION_FIELD, ENGAGEMENT_ID_FIELD, ENGAGEMENT_TITLE_FIELD, EXISTING_MEMBERS_FIELD,
            EXPIRATION_DATE_FIELD, ID_FIELD, INVITATION_DATE_FIELD, INVITATION_MESSAGE_FIELD, PAYLOAD_FIELD, PAYLOAD_TYPE_FIELD,
            RECEIVER_FIELD, REJECTION_REASON_FIELD, SENDER_AWS_ACCOUNT_ID_FIELD, SENDER_COMPANY_NAME_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String catalog;

    private final String engagementDescription;

    private final String engagementId;

    private final String engagementTitle;

    private final List<EngagementMemberSummary> existingMembers;

    private final Instant expirationDate;

    private final String id;

    private final Instant invitationDate;

    private final String invitationMessage;

    private final Payload payload;

    private final String payloadType;

    private final Receiver receiver;

    private final String rejectionReason;

    private final String senderAwsAccountId;

    private final String senderCompanyName;

    private final String status;

    private GetEngagementInvitationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.catalog = builder.catalog;
        this.engagementDescription = builder.engagementDescription;
        this.engagementId = builder.engagementId;
        this.engagementTitle = builder.engagementTitle;
        this.existingMembers = builder.existingMembers;
        this.expirationDate = builder.expirationDate;
        this.id = builder.id;
        this.invitationDate = builder.invitationDate;
        this.invitationMessage = builder.invitationMessage;
        this.payload = builder.payload;
        this.payloadType = builder.payloadType;
        this.receiver = builder.receiver;
        this.rejectionReason = builder.rejectionReason;
        this.senderAwsAccountId = builder.senderAwsAccountId;
        this.senderCompanyName = builder.senderCompanyName;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the engagement invitation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the engagement invitation.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Indicates the catalog from which the engagement invitation details are retrieved. This field helps in identifying
     * the appropriate catalog (e.g., <code>AWS</code> or <code>Sandbox</code>) used in the request.
     * </p>
     * 
     * @return Indicates the catalog from which the engagement invitation details are retrieved. This field helps in
     *         identifying the appropriate catalog (e.g., <code>AWS</code> or <code>Sandbox</code>) used in the request.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The description of the engagement associated with this invitation.
     * </p>
     * 
     * @return The description of the engagement associated with this invitation.
     */
    public final String engagementDescription() {
        return engagementDescription;
    }

    /**
     * <p>
     * The identifier of the engagement associated with this invitation.This ID links the invitation to its
     * corresponding engagement.
     * </p>
     * 
     * @return The identifier of the engagement associated with this invitation.This ID links the invitation to its
     *         corresponding engagement.
     */
    public final String engagementId() {
        return engagementId;
    }

    /**
     * <p>
     * The title of the engagement invitation, summarizing the purpose or objectives of the opportunity shared by AWS.
     * </p>
     * 
     * @return The title of the engagement invitation, summarizing the purpose or objectives of the opportunity shared
     *         by AWS.
     */
    public final String engagementTitle() {
        return engagementTitle;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExistingMembers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExistingMembers() {
        return existingMembers != null && !(existingMembers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of active members currently part of the Engagement. This array contains a maximum of 10 members, each
     * represented by an object with the following properties.
     * </p>
     * <ul>
     * <li>
     * <p>
     * CompanyName: The name of the member's company.
     * </p>
     * </li>
     * <li>
     * <p>
     * WebsiteUrl: The website URL of the member's company.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExistingMembers} method.
     * </p>
     * 
     * @return A list of active members currently part of the Engagement. This array contains a maximum of 10 members,
     *         each represented by an object with the following properties.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CompanyName: The name of the member's company.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WebsiteUrl: The website URL of the member's company.
     *         </p>
     *         </li>
     */
    public final List<EngagementMemberSummary> existingMembers() {
        return existingMembers;
    }

    /**
     * <p>
     * Indicates the date on which the engagement invitation will expire if not accepted by the partner.
     * </p>
     * 
     * @return Indicates the date on which the engagement invitation will expire if not accepted by the partner.
     */
    public final Instant expirationDate() {
        return expirationDate;
    }

    /**
     * <p>
     * Unique identifier assigned to the engagement invitation being retrieved.
     * </p>
     * 
     * @return Unique identifier assigned to the engagement invitation being retrieved.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The date when the engagement invitation was sent to the partner.
     * </p>
     * 
     * @return The date when the engagement invitation was sent to the partner.
     */
    public final Instant invitationDate() {
        return invitationDate;
    }

    /**
     * <p>
     * The message sent to the invited partner when the invitation was created.
     * </p>
     * 
     * @return The message sent to the invited partner when the invitation was created.
     */
    public final String invitationMessage() {
        return invitationMessage;
    }

    /**
     * <p>
     * Details of the engagement invitation payload, including specific data relevant to the invitation's contents, such
     * as customer information and opportunity insights.
     * </p>
     * 
     * @return Details of the engagement invitation payload, including specific data relevant to the invitation's
     *         contents, such as customer information and opportunity insights.
     */
    public final Payload payload() {
        return payload;
    }

    /**
     * <p>
     * The type of payload contained in the engagement invitation, indicating what data or context the payload covers.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #payloadType} will
     * return {@link EngagementInvitationPayloadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #payloadTypeAsString}.
     * </p>
     * 
     * @return The type of payload contained in the engagement invitation, indicating what data or context the payload
     *         covers.
     * @see EngagementInvitationPayloadType
     */
    public final EngagementInvitationPayloadType payloadType() {
        return EngagementInvitationPayloadType.fromValue(payloadType);
    }

    /**
     * <p>
     * The type of payload contained in the engagement invitation, indicating what data or context the payload covers.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #payloadType} will
     * return {@link EngagementInvitationPayloadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #payloadTypeAsString}.
     * </p>
     * 
     * @return The type of payload contained in the engagement invitation, indicating what data or context the payload
     *         covers.
     * @see EngagementInvitationPayloadType
     */
    public final String payloadTypeAsString() {
        return payloadType;
    }

    /**
     * <p>
     * Information about the partner organization or team that received the engagement invitation, including contact
     * details and identifiers.
     * </p>
     * 
     * @return Information about the partner organization or team that received the engagement invitation, including
     *         contact details and identifiers.
     */
    public final Receiver receiver() {
        return receiver;
    }

    /**
     * <p>
     * If the engagement invitation was rejected, this field specifies the reason provided by the partner for the
     * rejection.
     * </p>
     * 
     * @return If the engagement invitation was rejected, this field specifies the reason provided by the partner for
     *         the rejection.
     */
    public final String rejectionReason() {
        return rejectionReason;
    }

    /**
     * <p>
     * Specifies the AWS Account ID of the sender, which identifies the AWS team responsible for sharing the engagement
     * invitation.
     * </p>
     * 
     * @return Specifies the AWS Account ID of the sender, which identifies the AWS team responsible for sharing the
     *         engagement invitation.
     */
    public final String senderAwsAccountId() {
        return senderAwsAccountId;
    }

    /**
     * <p>
     * The name of the AWS organization or team that sent the engagement invitation.
     * </p>
     * 
     * @return The name of the AWS organization or team that sent the engagement invitation.
     */
    public final String senderCompanyName() {
        return senderCompanyName;
    }

    /**
     * <p>
     * The current status of the engagement invitation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InvitationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the engagement invitation.
     * @see InvitationStatus
     */
    public final InvitationStatus status() {
        return InvitationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the engagement invitation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InvitationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the engagement invitation.
     * @see InvitationStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(engagementDescription());
        hashCode = 31 * hashCode + Objects.hashCode(engagementId());
        hashCode = 31 * hashCode + Objects.hashCode(engagementTitle());
        hashCode = 31 * hashCode + Objects.hashCode(hasExistingMembers() ? existingMembers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(invitationDate());
        hashCode = 31 * hashCode + Objects.hashCode(invitationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        hashCode = 31 * hashCode + Objects.hashCode(payloadTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(receiver());
        hashCode = 31 * hashCode + Objects.hashCode(rejectionReason());
        hashCode = 31 * hashCode + Objects.hashCode(senderAwsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(senderCompanyName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEngagementInvitationResponse)) {
            return false;
        }
        GetEngagementInvitationResponse other = (GetEngagementInvitationResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(catalog(), other.catalog())
                && Objects.equals(engagementDescription(), other.engagementDescription())
                && Objects.equals(engagementId(), other.engagementId())
                && Objects.equals(engagementTitle(), other.engagementTitle())
                && hasExistingMembers() == other.hasExistingMembers()
                && Objects.equals(existingMembers(), other.existingMembers())
                && Objects.equals(expirationDate(), other.expirationDate()) && Objects.equals(id(), other.id())
                && Objects.equals(invitationDate(), other.invitationDate())
                && Objects.equals(invitationMessage(), other.invitationMessage()) && Objects.equals(payload(), other.payload())
                && Objects.equals(payloadTypeAsString(), other.payloadTypeAsString())
                && Objects.equals(receiver(), other.receiver()) && Objects.equals(rejectionReason(), other.rejectionReason())
                && Objects.equals(senderAwsAccountId(), other.senderAwsAccountId())
                && Objects.equals(senderCompanyName(), other.senderCompanyName())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEngagementInvitationResponse").add("Arn", arn()).add("Catalog", catalog())
                .add("EngagementDescription", engagementDescription()).add("EngagementId", engagementId())
                .add("EngagementTitle", engagementTitle())
                .add("ExistingMembers", hasExistingMembers() ? existingMembers() : null).add("ExpirationDate", expirationDate())
                .add("Id", id()).add("InvitationDate", invitationDate()).add("InvitationMessage", invitationMessage())
                .add("Payload", payload()).add("PayloadType", payloadTypeAsString()).add("Receiver", receiver())
                .add("RejectionReason", rejectionReason())
                .add("SenderAwsAccountId", senderAwsAccountId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SenderCompanyName", senderCompanyName()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "EngagementDescription":
            return Optional.ofNullable(clazz.cast(engagementDescription()));
        case "EngagementId":
            return Optional.ofNullable(clazz.cast(engagementId()));
        case "EngagementTitle":
            return Optional.ofNullable(clazz.cast(engagementTitle()));
        case "ExistingMembers":
            return Optional.ofNullable(clazz.cast(existingMembers()));
        case "ExpirationDate":
            return Optional.ofNullable(clazz.cast(expirationDate()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "InvitationDate":
            return Optional.ofNullable(clazz.cast(invitationDate()));
        case "InvitationMessage":
            return Optional.ofNullable(clazz.cast(invitationMessage()));
        case "Payload":
            return Optional.ofNullable(clazz.cast(payload()));
        case "PayloadType":
            return Optional.ofNullable(clazz.cast(payloadTypeAsString()));
        case "Receiver":
            return Optional.ofNullable(clazz.cast(receiver()));
        case "RejectionReason":
            return Optional.ofNullable(clazz.cast(rejectionReason()));
        case "SenderAwsAccountId":
            return Optional.ofNullable(clazz.cast(senderAwsAccountId()));
        case "SenderCompanyName":
            return Optional.ofNullable(clazz.cast(senderCompanyName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Catalog", CATALOG_FIELD);
        map.put("EngagementDescription", ENGAGEMENT_DESCRIPTION_FIELD);
        map.put("EngagementId", ENGAGEMENT_ID_FIELD);
        map.put("EngagementTitle", ENGAGEMENT_TITLE_FIELD);
        map.put("ExistingMembers", EXISTING_MEMBERS_FIELD);
        map.put("ExpirationDate", EXPIRATION_DATE_FIELD);
        map.put("Id", ID_FIELD);
        map.put("InvitationDate", INVITATION_DATE_FIELD);
        map.put("InvitationMessage", INVITATION_MESSAGE_FIELD);
        map.put("Payload", PAYLOAD_FIELD);
        map.put("PayloadType", PAYLOAD_TYPE_FIELD);
        map.put("Receiver", RECEIVER_FIELD);
        map.put("RejectionReason", REJECTION_REASON_FIELD);
        map.put("SenderAwsAccountId", SENDER_AWS_ACCOUNT_ID_FIELD);
        map.put("SenderCompanyName", SENDER_COMPANY_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEngagementInvitationResponse, T> g) {
        return obj -> g.apply((GetEngagementInvitationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PartnerCentralSellingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEngagementInvitationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the engagement invitation.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) that identifies the engagement invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Indicates the catalog from which the engagement invitation details are retrieved. This field helps in
         * identifying the appropriate catalog (e.g., <code>AWS</code> or <code>Sandbox</code>) used in the request.
         * </p>
         * 
         * @param catalog
         *        Indicates the catalog from which the engagement invitation details are retrieved. This field helps in
         *        identifying the appropriate catalog (e.g., <code>AWS</code> or <code>Sandbox</code>) used in the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The description of the engagement associated with this invitation.
         * </p>
         * 
         * @param engagementDescription
         *        The description of the engagement associated with this invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementDescription(String engagementDescription);

        /**
         * <p>
         * The identifier of the engagement associated with this invitation.This ID links the invitation to its
         * corresponding engagement.
         * </p>
         * 
         * @param engagementId
         *        The identifier of the engagement associated with this invitation.This ID links the invitation to its
         *        corresponding engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementId(String engagementId);

        /**
         * <p>
         * The title of the engagement invitation, summarizing the purpose or objectives of the opportunity shared by
         * AWS.
         * </p>
         * 
         * @param engagementTitle
         *        The title of the engagement invitation, summarizing the purpose or objectives of the opportunity
         *        shared by AWS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementTitle(String engagementTitle);

        /**
         * <p>
         * A list of active members currently part of the Engagement. This array contains a maximum of 10 members, each
         * represented by an object with the following properties.
         * </p>
         * <ul>
         * <li>
         * <p>
         * CompanyName: The name of the member's company.
         * </p>
         * </li>
         * <li>
         * <p>
         * WebsiteUrl: The website URL of the member's company.
         * </p>
         * </li>
         * </ul>
         * 
         * @param existingMembers
         *        A list of active members currently part of the Engagement. This array contains a maximum of 10
         *        members, each represented by an object with the following properties.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CompanyName: The name of the member's company.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WebsiteUrl: The website URL of the member's company.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder existingMembers(Collection<EngagementMemberSummary> existingMembers);

        /**
         * <p>
         * A list of active members currently part of the Engagement. This array contains a maximum of 10 members, each
         * represented by an object with the following properties.
         * </p>
         * <ul>
         * <li>
         * <p>
         * CompanyName: The name of the member's company.
         * </p>
         * </li>
         * <li>
         * <p>
         * WebsiteUrl: The website URL of the member's company.
         * </p>
         * </li>
         * </ul>
         * 
         * @param existingMembers
         *        A list of active members currently part of the Engagement. This array contains a maximum of 10
         *        members, each represented by an object with the following properties.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CompanyName: The name of the member's company.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WebsiteUrl: The website URL of the member's company.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder existingMembers(EngagementMemberSummary... existingMembers);

        /**
         * <p>
         * A list of active members currently part of the Engagement. This array contains a maximum of 10 members, each
         * represented by an object with the following properties.
         * </p>
         * <ul>
         * <li>
         * <p>
         * CompanyName: The name of the member's company.
         * </p>
         * </li>
         * <li>
         * <p>
         * WebsiteUrl: The website URL of the member's company.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.EngagementMemberSummary.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.partnercentralselling.model.EngagementMemberSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.EngagementMemberSummary.Builder#build()}
         * is called immediately and its result is passed to {@link #existingMembers(List<EngagementMemberSummary>)}.
         * 
         * @param existingMembers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.EngagementMemberSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #existingMembers(java.util.Collection<EngagementMemberSummary>)
         */
        Builder existingMembers(Consumer<EngagementMemberSummary.Builder>... existingMembers);

        /**
         * <p>
         * Indicates the date on which the engagement invitation will expire if not accepted by the partner.
         * </p>
         * 
         * @param expirationDate
         *        Indicates the date on which the engagement invitation will expire if not accepted by the partner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(Instant expirationDate);

        /**
         * <p>
         * Unique identifier assigned to the engagement invitation being retrieved.
         * </p>
         * 
         * @param id
         *        Unique identifier assigned to the engagement invitation being retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The date when the engagement invitation was sent to the partner.
         * </p>
         * 
         * @param invitationDate
         *        The date when the engagement invitation was sent to the partner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invitationDate(Instant invitationDate);

        /**
         * <p>
         * The message sent to the invited partner when the invitation was created.
         * </p>
         * 
         * @param invitationMessage
         *        The message sent to the invited partner when the invitation was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invitationMessage(String invitationMessage);

        /**
         * <p>
         * Details of the engagement invitation payload, including specific data relevant to the invitation's contents,
         * such as customer information and opportunity insights.
         * </p>
         * 
         * @param payload
         *        Details of the engagement invitation payload, including specific data relevant to the invitation's
         *        contents, such as customer information and opportunity insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(Payload payload);

        /**
         * <p>
         * Details of the engagement invitation payload, including specific data relevant to the invitation's contents,
         * such as customer information and opportunity insights.
         * </p>
         * This is a convenience method that creates an instance of the {@link Payload.Builder} avoiding the need to
         * create one manually via {@link Payload#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Payload.Builder#build()} is called immediately and its result is
         * passed to {@link #payload(Payload)}.
         * 
         * @param payload
         *        a consumer that will call methods on {@link Payload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #payload(Payload)
         */
        default Builder payload(Consumer<Payload.Builder> payload) {
            return payload(Payload.builder().applyMutation(payload).build());
        }

        /**
         * <p>
         * The type of payload contained in the engagement invitation, indicating what data or context the payload
         * covers.
         * </p>
         * 
         * @param payloadType
         *        The type of payload contained in the engagement invitation, indicating what data or context the
         *        payload covers.
         * @see EngagementInvitationPayloadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngagementInvitationPayloadType
         */
        Builder payloadType(String payloadType);

        /**
         * <p>
         * The type of payload contained in the engagement invitation, indicating what data or context the payload
         * covers.
         * </p>
         * 
         * @param payloadType
         *        The type of payload contained in the engagement invitation, indicating what data or context the
         *        payload covers.
         * @see EngagementInvitationPayloadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngagementInvitationPayloadType
         */
        Builder payloadType(EngagementInvitationPayloadType payloadType);

        /**
         * <p>
         * Information about the partner organization or team that received the engagement invitation, including contact
         * details and identifiers.
         * </p>
         * 
         * @param receiver
         *        Information about the partner organization or team that received the engagement invitation, including
         *        contact details and identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiver(Receiver receiver);

        /**
         * <p>
         * Information about the partner organization or team that received the engagement invitation, including contact
         * details and identifiers.
         * </p>
         * This is a convenience method that creates an instance of the {@link Receiver.Builder} avoiding the need to
         * create one manually via {@link Receiver#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Receiver.Builder#build()} is called immediately and its result is
         * passed to {@link #receiver(Receiver)}.
         * 
         * @param receiver
         *        a consumer that will call methods on {@link Receiver.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #receiver(Receiver)
         */
        default Builder receiver(Consumer<Receiver.Builder> receiver) {
            return receiver(Receiver.builder().applyMutation(receiver).build());
        }

        /**
         * <p>
         * If the engagement invitation was rejected, this field specifies the reason provided by the partner for the
         * rejection.
         * </p>
         * 
         * @param rejectionReason
         *        If the engagement invitation was rejected, this field specifies the reason provided by the partner for
         *        the rejection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectionReason(String rejectionReason);

        /**
         * <p>
         * Specifies the AWS Account ID of the sender, which identifies the AWS team responsible for sharing the
         * engagement invitation.
         * </p>
         * 
         * @param senderAwsAccountId
         *        Specifies the AWS Account ID of the sender, which identifies the AWS team responsible for sharing the
         *        engagement invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderAwsAccountId(String senderAwsAccountId);

        /**
         * <p>
         * The name of the AWS organization or team that sent the engagement invitation.
         * </p>
         * 
         * @param senderCompanyName
         *        The name of the AWS organization or team that sent the engagement invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderCompanyName(String senderCompanyName);

        /**
         * <p>
         * The current status of the engagement invitation.
         * </p>
         * 
         * @param status
         *        The current status of the engagement invitation.
         * @see InvitationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvitationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the engagement invitation.
         * </p>
         * 
         * @param status
         *        The current status of the engagement invitation.
         * @see InvitationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvitationStatus
         */
        Builder status(InvitationStatus status);
    }

    static final class BuilderImpl extends PartnerCentralSellingResponse.BuilderImpl implements Builder {
        private String arn;

        private String catalog;

        private String engagementDescription;

        private String engagementId;

        private String engagementTitle;

        private List<EngagementMemberSummary> existingMembers = DefaultSdkAutoConstructList.getInstance();

        private Instant expirationDate;

        private String id;

        private Instant invitationDate;

        private String invitationMessage;

        private Payload payload;

        private String payloadType;

        private Receiver receiver;

        private String rejectionReason;

        private String senderAwsAccountId;

        private String senderCompanyName;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEngagementInvitationResponse model) {
            super(model);
            arn(model.arn);
            catalog(model.catalog);
            engagementDescription(model.engagementDescription);
            engagementId(model.engagementId);
            engagementTitle(model.engagementTitle);
            existingMembers(model.existingMembers);
            expirationDate(model.expirationDate);
            id(model.id);
            invitationDate(model.invitationDate);
            invitationMessage(model.invitationMessage);
            payload(model.payload);
            payloadType(model.payloadType);
            receiver(model.receiver);
            rejectionReason(model.rejectionReason);
            senderAwsAccountId(model.senderAwsAccountId);
            senderCompanyName(model.senderCompanyName);
            status(model.status);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getEngagementDescription() {
            return engagementDescription;
        }

        public final void setEngagementDescription(String engagementDescription) {
            this.engagementDescription = engagementDescription;
        }

        @Override
        public final Builder engagementDescription(String engagementDescription) {
            this.engagementDescription = engagementDescription;
            return this;
        }

        public final String getEngagementId() {
            return engagementId;
        }

        public final void setEngagementId(String engagementId) {
            this.engagementId = engagementId;
        }

        @Override
        public final Builder engagementId(String engagementId) {
            this.engagementId = engagementId;
            return this;
        }

        public final String getEngagementTitle() {
            return engagementTitle;
        }

        public final void setEngagementTitle(String engagementTitle) {
            this.engagementTitle = engagementTitle;
        }

        @Override
        public final Builder engagementTitle(String engagementTitle) {
            this.engagementTitle = engagementTitle;
            return this;
        }

        public final List<EngagementMemberSummary.Builder> getExistingMembers() {
            List<EngagementMemberSummary.Builder> result = EngagementMemberSummariesCopier.copyToBuilder(this.existingMembers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExistingMembers(Collection<EngagementMemberSummary.BuilderImpl> existingMembers) {
            this.existingMembers = EngagementMemberSummariesCopier.copyFromBuilder(existingMembers);
        }

        @Override
        public final Builder existingMembers(Collection<EngagementMemberSummary> existingMembers) {
            this.existingMembers = EngagementMemberSummariesCopier.copy(existingMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder existingMembers(EngagementMemberSummary... existingMembers) {
            existingMembers(Arrays.asList(existingMembers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder existingMembers(Consumer<EngagementMemberSummary.Builder>... existingMembers) {
            existingMembers(Stream.of(existingMembers).map(c -> EngagementMemberSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getExpirationDate() {
            return expirationDate;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getInvitationDate() {
            return invitationDate;
        }

        public final void setInvitationDate(Instant invitationDate) {
            this.invitationDate = invitationDate;
        }

        @Override
        public final Builder invitationDate(Instant invitationDate) {
            this.invitationDate = invitationDate;
            return this;
        }

        public final String getInvitationMessage() {
            return invitationMessage;
        }

        public final void setInvitationMessage(String invitationMessage) {
            this.invitationMessage = invitationMessage;
        }

        @Override
        public final Builder invitationMessage(String invitationMessage) {
            this.invitationMessage = invitationMessage;
            return this;
        }

        public final Payload.Builder getPayload() {
            return payload != null ? payload.toBuilder() : null;
        }

        public final void setPayload(Payload.BuilderImpl payload) {
            this.payload = payload != null ? payload.build() : null;
        }

        @Override
        public final Builder payload(Payload payload) {
            this.payload = payload;
            return this;
        }

        public final String getPayloadType() {
            return payloadType;
        }

        public final void setPayloadType(String payloadType) {
            this.payloadType = payloadType;
        }

        @Override
        public final Builder payloadType(String payloadType) {
            this.payloadType = payloadType;
            return this;
        }

        @Override
        public final Builder payloadType(EngagementInvitationPayloadType payloadType) {
            this.payloadType(payloadType == null ? null : payloadType.toString());
            return this;
        }

        public final Receiver.Builder getReceiver() {
            return receiver != null ? receiver.toBuilder() : null;
        }

        public final void setReceiver(Receiver.BuilderImpl receiver) {
            this.receiver = receiver != null ? receiver.build() : null;
        }

        @Override
        public final Builder receiver(Receiver receiver) {
            this.receiver = receiver;
            return this;
        }

        public final String getRejectionReason() {
            return rejectionReason;
        }

        public final void setRejectionReason(String rejectionReason) {
            this.rejectionReason = rejectionReason;
        }

        @Override
        public final Builder rejectionReason(String rejectionReason) {
            this.rejectionReason = rejectionReason;
            return this;
        }

        public final String getSenderAwsAccountId() {
            return senderAwsAccountId;
        }

        public final void setSenderAwsAccountId(String senderAwsAccountId) {
            this.senderAwsAccountId = senderAwsAccountId;
        }

        @Override
        public final Builder senderAwsAccountId(String senderAwsAccountId) {
            this.senderAwsAccountId = senderAwsAccountId;
            return this;
        }

        public final String getSenderCompanyName() {
            return senderCompanyName;
        }

        public final void setSenderCompanyName(String senderCompanyName) {
            this.senderCompanyName = senderCompanyName;
        }

        @Override
        public final Builder senderCompanyName(String senderCompanyName) {
            this.senderCompanyName = senderCompanyName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InvitationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetEngagementInvitationResponse build() {
            return new GetEngagementInvitationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
