/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOpportunityRequest extends PartnerCentralSellingRequest implements
        ToCopyableBuilder<GetOpportunityRequest.Builder, GetOpportunityRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(GetOpportunityRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(GetOpportunityRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final String identifier;

    private GetOpportunityRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.identifier = builder.identifier;
    }

    /**
     * <p>
     * Specifies the catalog associated with the request. This field takes a string value from a predefined list:
     * <code>AWS</code> or <code>Sandbox</code>. The catalog determines which environment the opportunity is fetched
     * from. Use <code>AWS</code> to retrieve opportunities in the Amazon Web Services catalog, and <code>Sandbox</code>
     * to retrieve opportunities in a secure, isolated testing environment.
     * </p>
     * 
     * @return Specifies the catalog associated with the request. This field takes a string value from a predefined
     *         list: <code>AWS</code> or <code>Sandbox</code>. The catalog determines which environment the opportunity
     *         is fetched from. Use <code>AWS</code> to retrieve opportunities in the Amazon Web Services catalog, and
     *         <code>Sandbox</code> to retrieve opportunities in a secure, isolated testing environment.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * Read-only, system generated <code>Opportunity</code> unique identifier.
     * </p>
     * 
     * @return Read-only, system generated <code>Opportunity</code> unique identifier.
     */
    public final String identifier() {
        return identifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOpportunityRequest)) {
            return false;
        }
        GetOpportunityRequest other = (GetOpportunityRequest) obj;
        return Objects.equals(catalog(), other.catalog()) && Objects.equals(identifier(), other.identifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOpportunityRequest").add("Catalog", catalog()).add("Identifier", identifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOpportunityRequest, T> g) {
        return obj -> g.apply((GetOpportunityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PartnerCentralSellingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetOpportunityRequest> {
        /**
         * <p>
         * Specifies the catalog associated with the request. This field takes a string value from a predefined list:
         * <code>AWS</code> or <code>Sandbox</code>. The catalog determines which environment the opportunity is fetched
         * from. Use <code>AWS</code> to retrieve opportunities in the Amazon Web Services catalog, and
         * <code>Sandbox</code> to retrieve opportunities in a secure, isolated testing environment.
         * </p>
         * 
         * @param catalog
         *        Specifies the catalog associated with the request. This field takes a string value from a predefined
         *        list: <code>AWS</code> or <code>Sandbox</code>. The catalog determines which environment the
         *        opportunity is fetched from. Use <code>AWS</code> to retrieve opportunities in the Amazon Web Services
         *        catalog, and <code>Sandbox</code> to retrieve opportunities in a secure, isolated testing environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * Read-only, system generated <code>Opportunity</code> unique identifier.
         * </p>
         * 
         * @param identifier
         *        Read-only, system generated <code>Opportunity</code> unique identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralSellingRequest.BuilderImpl implements Builder {
        private String catalog;

        private String identifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOpportunityRequest model) {
            super(model);
            catalog(model.catalog);
            identifier(model.identifier);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetOpportunityRequest build() {
            return new GetOpportunityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
