/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceSnapshotResponse extends PartnerCentralSellingResponse implements
        ToCopyableBuilder<GetResourceSnapshotResponse.Builder, GetResourceSnapshotResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetResourceSnapshotResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(GetResourceSnapshotResponse::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(GetResourceSnapshotResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedBy").getter(getter(GetResourceSnapshotResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<String> ENGAGEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngagementId").getter(getter(GetResourceSnapshotResponse::engagementId))
            .setter(setter(Builder::engagementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementId").build()).build();

    private static final SdkField<ResourceSnapshotPayload> PAYLOAD_FIELD = SdkField
            .<ResourceSnapshotPayload> builder(MarshallingType.SDK_POJO).memberName("Payload")
            .getter(getter(GetResourceSnapshotResponse::payload)).setter(setter(Builder::payload))
            .constructor(ResourceSnapshotPayload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Payload").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(GetResourceSnapshotResponse::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> RESOURCE_SNAPSHOT_TEMPLATE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceSnapshotTemplateName")
            .getter(getter(GetResourceSnapshotResponse::resourceSnapshotTemplateName))
            .setter(setter(Builder::resourceSnapshotTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSnapshotTemplateName")
                    .build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(GetResourceSnapshotResponse::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<Integer> REVISION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Revision").getter(getter(GetResourceSnapshotResponse::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Revision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CATALOG_FIELD,
            CREATED_AT_FIELD, CREATED_BY_FIELD, ENGAGEMENT_ID_FIELD, PAYLOAD_FIELD, RESOURCE_ID_FIELD,
            RESOURCE_SNAPSHOT_TEMPLATE_NAME_FIELD, RESOURCE_TYPE_FIELD, REVISION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String catalog;

    private final Instant createdAt;

    private final String createdBy;

    private final String engagementId;

    private final ResourceSnapshotPayload payload;

    private final String resourceId;

    private final String resourceSnapshotTemplateName;

    private final String resourceType;

    private final Integer revision;

    private GetResourceSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.catalog = builder.catalog;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.engagementId = builder.engagementId;
        this.payload = builder.payload;
        this.resourceId = builder.resourceId;
        this.resourceSnapshotTemplateName = builder.resourceSnapshotTemplateName;
        this.resourceType = builder.resourceType;
        this.revision = builder.revision;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies the resource snapshot.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that uniquely identifies the resource snapshot.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The catalog in which the snapshot was created. Matches the Catalog specified in the request.
     * </p>
     * 
     * @return The catalog in which the snapshot was created. Matches the Catalog specified in the request.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The timestamp when the snapshot was created, in ISO 8601 format (e.g., "2023-06-01T14:30:00Z"). This allows for
     * precise tracking of when the snapshot was taken.
     * </p>
     * 
     * @return The timestamp when the snapshot was created, in ISO 8601 format (e.g., "2023-06-01T14:30:00Z"). This
     *         allows for precise tracking of when the snapshot was taken.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The AWS account ID of the principal (user or role) who created the snapshot. This helps in tracking the origin of
     * the snapshot.
     * </p>
     * 
     * @return The AWS account ID of the principal (user or role) who created the snapshot. This helps in tracking the
     *         origin of the snapshot.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The identifier of the engagement associated with this snapshot. Matches the EngagementIdentifier specified in the
     * request.
     * </p>
     * 
     * @return The identifier of the engagement associated with this snapshot. Matches the EngagementIdentifier
     *         specified in the request.
     */
    public final String engagementId() {
        return engagementId;
    }

    /**
     * Returns the value of the Payload property for this object.
     * 
     * @return The value of the Payload property for this object.
     */
    public final ResourceSnapshotPayload payload() {
        return payload;
    }

    /**
     * <p>
     * The identifier of the specific resource that was snapshotted. Matches the ResourceIdentifier specified in the
     * request.
     * </p>
     * 
     * @return The identifier of the specific resource that was snapshotted. Matches the ResourceIdentifier specified in
     *         the request.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The name of the view used for this snapshot. This is the same as the template name.
     * </p>
     * 
     * @return The name of the view used for this snapshot. This is the same as the template name.
     */
    public final String resourceSnapshotTemplateName() {
        return resourceSnapshotTemplateName;
    }

    /**
     * <p>
     * The type of the resource that was snapshotted. Matches the ResourceType specified in the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the resource that was snapshotted. Matches the ResourceType specified in the request.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of the resource that was snapshotted. Matches the ResourceType specified in the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the resource that was snapshotted. Matches the ResourceType specified in the request.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The revision number of this snapshot. This is a positive integer that is sequential and unique within the context
     * of a resource view.
     * </p>
     * 
     * @return The revision number of this snapshot. This is a positive integer that is sequential and unique within the
     *         context of a resource view.
     */
    public final Integer revision() {
        return revision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(engagementId());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceSnapshotTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceSnapshotResponse)) {
            return false;
        }
        GetResourceSnapshotResponse other = (GetResourceSnapshotResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(catalog(), other.catalog())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(engagementId(), other.engagementId()) && Objects.equals(payload(), other.payload())
                && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(resourceSnapshotTemplateName(), other.resourceSnapshotTemplateName())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(revision(), other.revision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourceSnapshotResponse").add("Arn", arn()).add("Catalog", catalog())
                .add("CreatedAt", createdAt()).add("CreatedBy", createdBy() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EngagementId", engagementId()).add("Payload", payload()).add("ResourceId", resourceId())
                .add("ResourceSnapshotTemplateName", resourceSnapshotTemplateName()).add("ResourceType", resourceTypeAsString())
                .add("Revision", revision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "EngagementId":
            return Optional.ofNullable(clazz.cast(engagementId()));
        case "Payload":
            return Optional.ofNullable(clazz.cast(payload()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceSnapshotTemplateName":
            return Optional.ofNullable(clazz.cast(resourceSnapshotTemplateName()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "Revision":
            return Optional.ofNullable(clazz.cast(revision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Catalog", CATALOG_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("EngagementId", ENGAGEMENT_ID_FIELD);
        map.put("Payload", PAYLOAD_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ResourceSnapshotTemplateName", RESOURCE_SNAPSHOT_TEMPLATE_NAME_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("Revision", REVISION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourceSnapshotResponse, T> g) {
        return obj -> g.apply((GetResourceSnapshotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PartnerCentralSellingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetResourceSnapshotResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies the resource snapshot.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) that uniquely identifies the resource snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The catalog in which the snapshot was created. Matches the Catalog specified in the request.
         * </p>
         * 
         * @param catalog
         *        The catalog in which the snapshot was created. Matches the Catalog specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The timestamp when the snapshot was created, in ISO 8601 format (e.g., "2023-06-01T14:30:00Z"). This allows
         * for precise tracking of when the snapshot was taken.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the snapshot was created, in ISO 8601 format (e.g., "2023-06-01T14:30:00Z"). This
         *        allows for precise tracking of when the snapshot was taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The AWS account ID of the principal (user or role) who created the snapshot. This helps in tracking the
         * origin of the snapshot.
         * </p>
         * 
         * @param createdBy
         *        The AWS account ID of the principal (user or role) who created the snapshot. This helps in tracking
         *        the origin of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The identifier of the engagement associated with this snapshot. Matches the EngagementIdentifier specified in
         * the request.
         * </p>
         * 
         * @param engagementId
         *        The identifier of the engagement associated with this snapshot. Matches the EngagementIdentifier
         *        specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementId(String engagementId);

        /**
         * Sets the value of the Payload property for this object.
         *
         * @param payload
         *        The new value for the Payload property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(ResourceSnapshotPayload payload);

        /**
         * Sets the value of the Payload property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResourceSnapshotPayload.Builder} avoiding
         * the need to create one manually via {@link ResourceSnapshotPayload#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceSnapshotPayload.Builder#build()} is called immediately
         * and its result is passed to {@link #payload(ResourceSnapshotPayload)}.
         * 
         * @param payload
         *        a consumer that will call methods on {@link ResourceSnapshotPayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #payload(ResourceSnapshotPayload)
         */
        default Builder payload(Consumer<ResourceSnapshotPayload.Builder> payload) {
            return payload(ResourceSnapshotPayload.builder().applyMutation(payload).build());
        }

        /**
         * <p>
         * The identifier of the specific resource that was snapshotted. Matches the ResourceIdentifier specified in the
         * request.
         * </p>
         * 
         * @param resourceId
         *        The identifier of the specific resource that was snapshotted. Matches the ResourceIdentifier specified
         *        in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The name of the view used for this snapshot. This is the same as the template name.
         * </p>
         * 
         * @param resourceSnapshotTemplateName
         *        The name of the view used for this snapshot. This is the same as the template name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSnapshotTemplateName(String resourceSnapshotTemplateName);

        /**
         * <p>
         * The type of the resource that was snapshotted. Matches the ResourceType specified in the request.
         * </p>
         * 
         * @param resourceType
         *        The type of the resource that was snapshotted. Matches the ResourceType specified in the request.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of the resource that was snapshotted. Matches the ResourceType specified in the request.
         * </p>
         * 
         * @param resourceType
         *        The type of the resource that was snapshotted. Matches the ResourceType specified in the request.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The revision number of this snapshot. This is a positive integer that is sequential and unique within the
         * context of a resource view.
         * </p>
         * 
         * @param revision
         *        The revision number of this snapshot. This is a positive integer that is sequential and unique within
         *        the context of a resource view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(Integer revision);
    }

    static final class BuilderImpl extends PartnerCentralSellingResponse.BuilderImpl implements Builder {
        private String arn;

        private String catalog;

        private Instant createdAt;

        private String createdBy;

        private String engagementId;

        private ResourceSnapshotPayload payload;

        private String resourceId;

        private String resourceSnapshotTemplateName;

        private String resourceType;

        private Integer revision;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceSnapshotResponse model) {
            super(model);
            arn(model.arn);
            catalog(model.catalog);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            engagementId(model.engagementId);
            payload(model.payload);
            resourceId(model.resourceId);
            resourceSnapshotTemplateName(model.resourceSnapshotTemplateName);
            resourceType(model.resourceType);
            revision(model.revision);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getEngagementId() {
            return engagementId;
        }

        public final void setEngagementId(String engagementId) {
            this.engagementId = engagementId;
        }

        @Override
        public final Builder engagementId(String engagementId) {
            this.engagementId = engagementId;
            return this;
        }

        public final ResourceSnapshotPayload.Builder getPayload() {
            return payload != null ? payload.toBuilder() : null;
        }

        public final void setPayload(ResourceSnapshotPayload.BuilderImpl payload) {
            this.payload = payload != null ? payload.build() : null;
        }

        @Override
        public final Builder payload(ResourceSnapshotPayload payload) {
            this.payload = payload;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceSnapshotTemplateName() {
            return resourceSnapshotTemplateName;
        }

        public final void setResourceSnapshotTemplateName(String resourceSnapshotTemplateName) {
            this.resourceSnapshotTemplateName = resourceSnapshotTemplateName;
        }

        @Override
        public final Builder resourceSnapshotTemplateName(String resourceSnapshotTemplateName) {
            this.resourceSnapshotTemplateName = resourceSnapshotTemplateName;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final Integer getRevision() {
            return revision;
        }

        public final void setRevision(Integer revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(Integer revision) {
            this.revision = revision;
            return this;
        }

        @Override
        public GetResourceSnapshotResponse build() {
            return new GetResourceSnapshotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
