/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSellingSystemSettingsResponse extends PartnerCentralSellingResponse implements
        ToCopyableBuilder<GetSellingSystemSettingsResponse.Builder, GetSellingSystemSettingsResponse> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(GetSellingSystemSettingsResponse::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> RESOURCE_SNAPSHOT_JOB_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceSnapshotJobRoleArn")
            .getter(getter(GetSellingSystemSettingsResponse::resourceSnapshotJobRoleArn))
            .setter(setter(Builder::resourceSnapshotJobRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSnapshotJobRoleArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            RESOURCE_SNAPSHOT_JOB_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final String resourceSnapshotJobRoleArn;

    private GetSellingSystemSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.resourceSnapshotJobRoleArn = builder.resourceSnapshotJobRoleArn;
    }

    /**
     * <p>
     * Specifies the catalog in which the settings are defined. Acceptable values include <code>AWS</code> for
     * production and <code>Sandbox</code> for testing environments.
     * </p>
     * 
     * @return Specifies the catalog in which the settings are defined. Acceptable values include <code>AWS</code> for
     *         production and <code>Sandbox</code> for testing environments.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * Specifies the ARN of the IAM Role used for resource snapshot job executions.
     * </p>
     * 
     * @return Specifies the ARN of the IAM Role used for resource snapshot job executions.
     */
    public final String resourceSnapshotJobRoleArn() {
        return resourceSnapshotJobRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(resourceSnapshotJobRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSellingSystemSettingsResponse)) {
            return false;
        }
        GetSellingSystemSettingsResponse other = (GetSellingSystemSettingsResponse) obj;
        return Objects.equals(catalog(), other.catalog())
                && Objects.equals(resourceSnapshotJobRoleArn(), other.resourceSnapshotJobRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSellingSystemSettingsResponse").add("Catalog", catalog())
                .add("ResourceSnapshotJobRoleArn", resourceSnapshotJobRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "ResourceSnapshotJobRoleArn":
            return Optional.ofNullable(clazz.cast(resourceSnapshotJobRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("ResourceSnapshotJobRoleArn", RESOURCE_SNAPSHOT_JOB_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSellingSystemSettingsResponse, T> g) {
        return obj -> g.apply((GetSellingSystemSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PartnerCentralSellingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSellingSystemSettingsResponse> {
        /**
         * <p>
         * Specifies the catalog in which the settings are defined. Acceptable values include <code>AWS</code> for
         * production and <code>Sandbox</code> for testing environments.
         * </p>
         * 
         * @param catalog
         *        Specifies the catalog in which the settings are defined. Acceptable values include <code>AWS</code>
         *        for production and <code>Sandbox</code> for testing environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * Specifies the ARN of the IAM Role used for resource snapshot job executions.
         * </p>
         * 
         * @param resourceSnapshotJobRoleArn
         *        Specifies the ARN of the IAM Role used for resource snapshot job executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSnapshotJobRoleArn(String resourceSnapshotJobRoleArn);
    }

    static final class BuilderImpl extends PartnerCentralSellingResponse.BuilderImpl implements Builder {
        private String catalog;

        private String resourceSnapshotJobRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSellingSystemSettingsResponse model) {
            super(model);
            catalog(model.catalog);
            resourceSnapshotJobRoleArn(model.resourceSnapshotJobRoleArn);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getResourceSnapshotJobRoleArn() {
            return resourceSnapshotJobRoleArn;
        }

        public final void setResourceSnapshotJobRoleArn(String resourceSnapshotJobRoleArn) {
            this.resourceSnapshotJobRoleArn = resourceSnapshotJobRoleArn;
        }

        @Override
        public final Builder resourceSnapshotJobRoleArn(String resourceSnapshotJobRoleArn) {
            this.resourceSnapshotJobRoleArn = resourceSnapshotJobRoleArn;
            return this;
        }

        @Override
        public GetSellingSystemSettingsResponse build() {
            return new GetSellingSystemSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
