/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a filter to retrieve opportunities based on the last modified date. This filter is useful for tracking
 * changes or updates to opportunities over time.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LastModifiedDate implements SdkPojo, Serializable,
        ToCopyableBuilder<LastModifiedDate.Builder, LastModifiedDate> {
    private static final SdkField<Instant> AFTER_LAST_MODIFIED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("AfterLastModifiedDate")
            .getter(getter(LastModifiedDate::afterLastModifiedDate))
            .setter(setter(Builder::afterLastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AfterLastModifiedDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> BEFORE_LAST_MODIFIED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("BeforeLastModifiedDate")
            .getter(getter(LastModifiedDate::beforeLastModifiedDate))
            .setter(setter(Builder::beforeLastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeforeLastModifiedDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AFTER_LAST_MODIFIED_DATE_FIELD, BEFORE_LAST_MODIFIED_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant afterLastModifiedDate;

    private final Instant beforeLastModifiedDate;

    private LastModifiedDate(BuilderImpl builder) {
        this.afterLastModifiedDate = builder.afterLastModifiedDate;
        this.beforeLastModifiedDate = builder.beforeLastModifiedDate;
    }

    /**
     * <p>
     * Specifies the date after which the opportunities were modified. Use this filter to retrieve only those
     * opportunities that were modified after a given timestamp.
     * </p>
     * 
     * @return Specifies the date after which the opportunities were modified. Use this filter to retrieve only those
     *         opportunities that were modified after a given timestamp.
     */
    public final Instant afterLastModifiedDate() {
        return afterLastModifiedDate;
    }

    /**
     * <p>
     * Specifies the date before which the opportunities were modified. Use this filter to retrieve only those
     * opportunities that were modified before a given timestamp.
     * </p>
     * 
     * @return Specifies the date before which the opportunities were modified. Use this filter to retrieve only those
     *         opportunities that were modified before a given timestamp.
     */
    public final Instant beforeLastModifiedDate() {
        return beforeLastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(afterLastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(beforeLastModifiedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LastModifiedDate)) {
            return false;
        }
        LastModifiedDate other = (LastModifiedDate) obj;
        return Objects.equals(afterLastModifiedDate(), other.afterLastModifiedDate())
                && Objects.equals(beforeLastModifiedDate(), other.beforeLastModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LastModifiedDate").add("AfterLastModifiedDate", afterLastModifiedDate())
                .add("BeforeLastModifiedDate", beforeLastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AfterLastModifiedDate":
            return Optional.ofNullable(clazz.cast(afterLastModifiedDate()));
        case "BeforeLastModifiedDate":
            return Optional.ofNullable(clazz.cast(beforeLastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AfterLastModifiedDate", AFTER_LAST_MODIFIED_DATE_FIELD);
        map.put("BeforeLastModifiedDate", BEFORE_LAST_MODIFIED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LastModifiedDate, T> g) {
        return obj -> g.apply((LastModifiedDate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LastModifiedDate> {
        /**
         * <p>
         * Specifies the date after which the opportunities were modified. Use this filter to retrieve only those
         * opportunities that were modified after a given timestamp.
         * </p>
         * 
         * @param afterLastModifiedDate
         *        Specifies the date after which the opportunities were modified. Use this filter to retrieve only those
         *        opportunities that were modified after a given timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterLastModifiedDate(Instant afterLastModifiedDate);

        /**
         * <p>
         * Specifies the date before which the opportunities were modified. Use this filter to retrieve only those
         * opportunities that were modified before a given timestamp.
         * </p>
         * 
         * @param beforeLastModifiedDate
         *        Specifies the date before which the opportunities were modified. Use this filter to retrieve only
         *        those opportunities that were modified before a given timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeLastModifiedDate(Instant beforeLastModifiedDate);
    }

    static final class BuilderImpl implements Builder {
        private Instant afterLastModifiedDate;

        private Instant beforeLastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(LastModifiedDate model) {
            afterLastModifiedDate(model.afterLastModifiedDate);
            beforeLastModifiedDate(model.beforeLastModifiedDate);
        }

        public final Instant getAfterLastModifiedDate() {
            return afterLastModifiedDate;
        }

        public final void setAfterLastModifiedDate(Instant afterLastModifiedDate) {
            this.afterLastModifiedDate = afterLastModifiedDate;
        }

        @Override
        public final Builder afterLastModifiedDate(Instant afterLastModifiedDate) {
            this.afterLastModifiedDate = afterLastModifiedDate;
            return this;
        }

        public final Instant getBeforeLastModifiedDate() {
            return beforeLastModifiedDate;
        }

        public final void setBeforeLastModifiedDate(Instant beforeLastModifiedDate) {
            this.beforeLastModifiedDate = beforeLastModifiedDate;
        }

        @Override
        public final Builder beforeLastModifiedDate(Instant beforeLastModifiedDate) {
            this.beforeLastModifiedDate = beforeLastModifiedDate;
            return this;
        }

        @Override
        public LastModifiedDate build() {
            return new LastModifiedDate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
